/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.app.Application;
import android.content.Context;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntegerRes;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.delight.pushlibrary.R;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.push.PushManager;
import java.util.ArrayList;
import java.util.List;

public class MoEngage {
    private static final String TAG = "MoEngage";
    private Builder mBuilder;

    private MoEngage(Builder builder) {
        this.mBuilder = builder;
    }

    public static void initialise(@NonNull MoEngage moEngage) {
        ArrayList<String> activityNameList;
        if (moEngage == null) {
            Logger.e("MoEngage Object instance is null cannot initialise");
            return;
        }
        Builder builder = moEngage.mBuilder;
        if (builder == null || builder.context == null || builder.application == null) {
            Logger.e("MoEngageBuilder/Context/Application is null. Cannot initialise SDK.");
            return;
        }
        Context context = builder.context;
        ConfigurationProvider.shouldReadManifestConfig = false;
        ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
        if (TextUtils.isEmpty((CharSequence)builder.appId)) {
            Logger.e("MoEngageinit() : App-id not passed. Cannot use MoEngage Platform");
            return;
        }
        provider.setAppId(builder.appId);
        if (builder.largeIcon != -1) {
            provider.setLargeIcon(builder.largeIcon);
        } else {
            Logger.e("MoEngageinit() : Large icon not set");
        }
        if (builder.smallIcon != -1) {
            provider.setSmallIcon(builder.smallIcon);
        } else {
            Logger.e("MoEngageinit() : Small icon not set cannot show notification");
        }
        if (!TextUtils.isEmpty((CharSequence)builder.senderId)) {
            provider.setSenderID(builder.senderId);
        }
        if (builder.color != -1) {
            provider.setNotificationColor(builder.color);
        } else {
            provider.setColorFallback();
        }
        if (!TextUtils.isEmpty((CharSequence)builder.tone)) {
            String tone = builder.tone;
            if (builder.tone.contains(".")) {
                tone = builder.tone.substring(0, builder.tone.lastIndexOf("."));
            }
            provider.setNotificationTone(tone);
        }
        provider.setNotificationType(context.getResources().getInteger(builder.notificationType));
        if (builder.inAppOptOutList != null) {
            try {
                activityNameList = new ArrayList<String>(builder.inAppOptOutList.size());
                for (Class clazz : builder.inAppOptOutList) {
                    activityNameList.add(clazz.getName());
                }
                provider.setInAppOptOutActivityList(activityNameList);
            }
            catch (Exception e) {
                Logger.f("MoEngageinit() : Activity Opt out ", e);
            }
        }
        if (builder.activityTrackingOptOutList != null) {
            try {
                activityNameList = new ArrayList(builder.activityTrackingOptOutList.size());
                for (Class clazz : builder.activityTrackingOptOutList) {
                    activityNameList.add(clazz.getName());
                }
                provider.setTrackingOptedOutActivities(activityNameList);
            }
            catch (Exception e) {
                Logger.f("MoEngageinit() : Activity Opt out ", e);
            }
        }
        PushManager.getInstance().optoutBackStackBuilder(builder.backStackBuilderOptOut);
        provider.setNavBarOptOut(builder.navBarOptOut);
        PushManager.getInstance().optOutMoEngageExtras(builder.moEngageExtrasOptOut);
        provider.optOutOfAdIdCollection(builder.gaidOptOut);
        provider.optOutOfAndroidIdCollection(builder.androidIdOptOut);
        provider.optOutOfIMEICollection(builder.imeiOptOut);
        provider.optOutOfTrackLocation(builder.locationOptOut);
        provider.optOutOfSetGeoFence(builder.geofenceOptOut);
        provider.optOutOfOperatorNameCollection(builder.carrierNameOptOut);
        provider.optOutOfDeviceAttributesCollection(builder.deviceAttributeOptOut);
        provider.setPushRegistrationState(builder.isPushRegistrationEnabled);
        provider.setDataRegion(builder.redirectionRegion.getRegion());
        provider.setLocationServicesState(builder.locationServices);
        if (builder.enableBaiduPush && !TextUtils.isEmpty((CharSequence)builder.baiduKey)) {
            PushManager.getInstance().enableBaiduPush();
            provider.setBaiduApiKey(builder.baiduKey);
        }
        if (builder.application != null) {
            MoEHelper.getInstance(context).autoIntegrate(builder.application);
        }
        if (builder.flushInterval != -1L) {
            MoEHelper.getInstance(context).setFlushInterval(builder.flushInterval);
        }
        MoEHelper.getInstance(context).setPeriodicFlushState(builder.isPeriodicFlushEnabled);
        Logger.setLogLevel(builder.logLevel);
        if (builder.logStatus) {
            Logger.setLogStatus(builder.logStatus);
        }
        provider.optOutOfNotificationLargeIcon(builder.optOutNotificationLargeIcon);
        try {
            StringBuilder stringBuilder = new StringBuilder("SDK Init Config: Details -> \n");
            stringBuilder.append("\n App id: ").append(builder.appId).append("\n sender id: ").append(builder.senderId).append("\n large icon: ").append(builder.largeIcon).append("\n small icon: ").append(builder.smallIcon).append("\n notification color: ").append(builder.color).append("\n notification tone: ").append(builder.tone).append("\n in-app out list");
            if (builder.inAppOptOutList != null) {
                stringBuilder.append(builder.inAppOptOutList.toString());
            }
            stringBuilder.append("\n activity tracking opt-out: ");
            if (builder.activityTrackingOptOutList != null) {
                stringBuilder.append(builder.activityTrackingOptOutList.toString());
            }
            stringBuilder.append("\n notification type: ").append(builder.notificationType).append("\n backStackBuilderOptOut: ").append(builder.backStackBuilderOptOut).append("\n navBarOptOut: ").append(builder.navBarOptOut).append("\n moEngageExtrasOptOut: ").append(builder.moEngageExtrasOptOut).append("\n gaidOptOut: ").append(builder.gaidOptOut).append("\n androidIdOptOut: ").append(builder.androidIdOptOut).append("\n imeiOptOut: ").append(builder.imeiOptOut).append("\n locationOptOut: ").append(builder.locationOptOut).append("\n geofenceOptOut: ").append(builder.geofenceOptOut).append("\n carrierNameOptOut: ").append(builder.carrierNameOptOut).append("\n carrierNameOptOut: ").append(builder.carrierNameOptOut).append("\n isPushRegistrationEnabled: ").append(builder.isPushRegistrationEnabled).append("\n redirectionRegion: ").append(builder.redirectionRegion.getRegion()).append("\n flushInterval: ").append(builder.flushInterval).append("\n isPeriodicFlushEnabled: ").append(builder.isPeriodicFlushEnabled).append("\n enableBaiduPush: ").append(builder.enableBaiduPush).append("\n baiduKey: ").append(builder.baiduKey).append("\n logLevel: ").append(builder.logLevel).append("\n logStatus: ").append(builder.logStatus).append("\n locationServices: ").append(builder.locationServices).append("\n optOutNotificationLargeIcon: ").append(builder.optOutNotificationLargeIcon);
            Logger.d("MoEngage initialise(): Config: " + stringBuilder.toString());
        }
        catch (Exception e) {
            Logger.e("MoEngage initialise() : ", e);
        }
    }

    public static class Builder {
        private static final String TAG = "MoEngage.Builder";
        private Context context;
        private String appId;
        private int largeIcon = -1;
        private int smallIcon = -1;
        private String senderId;
        private int color = -1;
        private String tone;
        private int notificationType = R.integer.notification_type_single;
        private Application application;
        private List<Class> inAppOptOutList;
        private List<Class> activityTrackingOptOutList;
        private boolean backStackBuilderOptOut;
        private boolean navBarOptOut;
        private boolean moEngageExtrasOptOut;
        private boolean gaidOptOut;
        private boolean androidIdOptOut;
        private boolean imeiOptOut = true;
        private boolean locationOptOut;
        private boolean geofenceOptOut;
        private boolean carrierNameOptOut;
        private boolean deviceAttributeOptOut;
        private boolean isPushRegistrationEnabled = true;
        private DATA_REGION redirectionRegion = DATA_REGION.REGION_DEFAULT;
        private long flushInterval = -1L;
        private boolean isPeriodicFlushEnabled = true;
        private boolean enableBaiduPush;
        private String baiduKey;
        private int logLevel = 2;
        private boolean logStatus;
        private boolean locationServices;
        private boolean optOutNotificationLargeIcon;

        public Builder(@NonNull Application application, @NonNull String appId) {
            this.application = application;
            this.context = application.getApplicationContext();
            this.appId = appId;
        }

        public Builder setNotificationLargeIcon(@DrawableRes int largeIcon) {
            this.largeIcon = largeIcon;
            return this;
        }

        public Builder setNotificationSmallIcon(@DrawableRes int smallIcon) {
            this.smallIcon = smallIcon;
            return this;
        }

        public Builder setSenderId(@NonNull String senderId) {
            this.senderId = senderId;
            return this;
        }

        public Builder setNotificationColor(@ColorRes int color) {
            this.color = color;
            return this;
        }

        public Builder setNotificationTone(String tone) {
            this.tone = tone;
            return this;
        }

        public Builder setNotificationType(@IntegerRes int notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        public Builder setInAppOptOut(List<Class> inAppOptOutClassList) {
            this.inAppOptOutList = inAppOptOutClassList;
            return this;
        }

        public Builder setTrackingOptOut(List<Class> trackingOptOut) {
            this.activityTrackingOptOutList = trackingOptOut;
            return this;
        }

        public Builder optOutBackStackBuilder() {
            this.backStackBuilderOptOut = true;
            return this;
        }

        public Builder optOutNavBar() {
            this.navBarOptOut = true;
            return this;
        }

        public Builder optOutMoEngageExtras() {
            this.moEngageExtrasOptOut = true;
            return this;
        }

        public Builder optOutGAIDCollection() {
            this.gaidOptOut = true;
            return this;
        }

        public Builder optOutAndroidIdCollection() {
            this.androidIdOptOut = true;
            return this;
        }

        public Builder optInIMEICollection() {
            this.imeiOptOut = false;
            return this;
        }

        public Builder optOutLocationTracking() {
            this.locationOptOut = true;
            return this;
        }

        public Builder optOutGeoFence() {
            this.geofenceOptOut = true;
            return this;
        }

        public Builder optOutCarrierNameCollection() {
            this.carrierNameOptOut = true;
            return this;
        }

        public Builder optOutDeviceAttributeCollection() {
            this.deviceAttributeOptOut = true;
            return this;
        }

        public Builder optOutTokenRegistration() {
            this.isPushRegistrationEnabled = false;
            return this;
        }

        public Builder redirectDataToRegion(DATA_REGION regionConstant) {
            this.redirectionRegion = regionConstant;
            return this;
        }

        public Builder setFlushInterval(long interval) {
            this.flushInterval = interval;
            return this;
        }

        public Builder optOutPeriodicFlush() {
            this.isPeriodicFlushEnabled = false;
            return this;
        }

        public Builder setLogLevel(int logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder enableLogsForSignedBuild() {
            this.logStatus = true;
            return this;
        }

        public Builder enableBaiduPush(@NonNull String baiduPushKey) {
            this.enableBaiduPush = true;
            this.baiduKey = baiduPushKey;
            return this;
        }

        public Builder enableLocationServices() {
            this.locationServices = true;
            return this;
        }

        public Builder optOutNotificationLargeIcon() {
            this.optOutNotificationLargeIcon = true;
            return this;
        }

        public MoEngage build() {
            return new MoEngage(this);
        }
    }

    public static enum DATA_REGION {
        REGION_INDIA(1001),
        REGION_EU(1002),
        REGION_DEFAULT(1003);

        private final int region;

        private DATA_REGION(int region) {
            this.region = region;
        }

        public int getRegion() {
            return this.region;
        }
    }
}

