/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;

public class MoEWorkerTask
extends SDKTask {
    private String workerTaskType;
    private Bundle extras;

    public MoEWorkerTask(Context context, @NonNull String workerTaskType, @Nullable Bundle extras) {
        super(context);
        this.workerTaskType = workerTaskType;
        this.extras = extras;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("MoEWorkerTask: executing task");
            if (TextUtils.isEmpty((CharSequence)this.workerTaskType)) {
                return null;
            }
            switch (this.workerTaskType) {
                case "APP_UPDATE": {
                    MoEDispatcher.getInstance(this.mContext).handleAppUpdateEvent();
                    break;
                }
                case "LOGOUT": {
                    boolean logoutType = false;
                    if (this.extras != null && this.extras.containsKey("IS_FORCE_LOGOUT")) {
                        logoutType = this.extras.getBoolean("IS_FORCE_LOGOUT");
                    }
                    MoEDispatcher.getInstance(this.mContext).handleLogout(logoutType);
                    break;
                }
                default: {
                    Logger.e("Not a valid task type");
                }
            }
            Logger.v("MoEWorkerTask: completed task");
        }
        catch (Exception e) {
            Logger.e("MoEWorkerTask: execute() ", e);
        }
        return null;
    }

    @Override
    public String getTaskTag() {
        return "MOE_WORKER_TASK";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }
}

