/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.location;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;

public final class GeoManager {
    private LocationHandler handler;
    private static GeoManager _THIS;

    private GeoManager() {
        this.loadHandler();
    }

    public static GeoManager getInstance() {
        if (null == _THIS) {
            _THIS = new GeoManager();
        }
        return _THIS;
    }

    private void loadHandler() {
        try {
            this.handler = (LocationHandler)Class.forName("com.moengage.locationlibrary.LocationHandlerImpl").newInstance();
        }
        catch (ClassNotFoundException e) {
            Logger.e("Location Handler class Not Found Exception");
        }
        catch (Exception e) {
            Logger.e("Exception", e);
        }
    }

    @Nullable
    public LocationHandler getHandler(@NonNull Context context) {
        if (null == context) {
            return null;
        }
        if (!ConfigurationProvider.getInstance(context).isGeoEnabled()) {
            return null;
        }
        if (!ConfigurationProvider.getInstance(context).isManifestParsingEnabled() && ConfigurationProvider.getInstance(context).getLocationServiceState()) {
            return this.handler;
        }
        if (ConfigurationProvider.getInstance(context).isManifestParsingEnabled()) {
            return this.handler;
        }
        return null;
    }

    public void updateFenceAndLocation(Context context) {
        if (this.getHandler(context) != null) {
            this.getHandler(context).updateFenceAndLocation(context);
        }
    }

    public static enum TASK_TYPE {
        GET_GEOFENCE,
        GEOFENCE_HIT;

    }

    public static interface LocationHandler {
        public void setGeoFences(Context var1, String var2);

        public void onGeoFenceHit(Context var1, Intent var2);

        public void updateFenceAndLocation(Context var1);
    }
}

