/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.text.TextUtils;
import com.moengage.core.APIManager;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppController;
import java.util.HashMap;
import org.json.JSONObject;

public class InAppNetworkCallsTask
extends SDKTask {
    private HashMap<String, String> paramsMap;
    String API;
    private String requestBody;
    private InAppController.NETWORK_CALL_TYPE networkCallType;
    private InAppController.InAppHandler inAppHandler;

    public InAppNetworkCallsTask(Context context, String API, HashMap<String, String> paramsMap, String requestBody, InAppController.NETWORK_CALL_TYPE networkCallType) {
        super(context);
        this.API = API;
        this.paramsMap = paramsMap;
        this.requestBody = requestBody;
        this.networkCallType = networkCallType;
        this.inAppHandler = InAppController.getInstance().getInAppHandler();
    }

    @Override
    public TaskResult execute() {
        Logger.v("InAppNetworkCallsTask : started execution, Task Type : " + (Object)((Object)this.networkCallType));
        String response = null;
        if (this.inAppHandler != null) {
            try {
                if (!ConfigurationProvider.getInstance(this.mContext).isInAppEnabled() || !ConfigurationProvider.getInstance(this.mContext).isAppEnabled()) {
                    return null;
                }
                switch (this.networkCallType) {
                    case SYNC_IN_APPS: {
                        Logger.v("InAppNetworkCallsTask: executing sync in-apps");
                        this.mTaskResult.setPayload((Object)InAppController.NETWORK_CALL_TYPE.SYNC_IN_APPS);
                        response = APIManager.fetchInAppCampaigns(this.mContext, this.API, this.paramsMap, this.requestBody);
                        if (!TextUtils.isEmpty((CharSequence)response)) {
                            JSONObject jsonResponse = new JSONObject(response);
                            this.inAppHandler.parseAndSaveInApps(jsonResponse, this.mContext);
                            this.mTaskResult.setIsSuccess(true);
                            break;
                        }
                        Logger.e("MoEParser:parseAndSaveCampaignInfo not a valid response");
                        break;
                    }
                    case AUTO_TRIGGER_EVENT: {
                        Logger.v("InAppNetworkCallsTask: executing auto-trigger in-apps");
                        response = APIManager.logASmartEvent(this.mContext, this.API, this.paramsMap, this.requestBody);
                        if (TextUtils.isEmpty((CharSequence)response)) break;
                        JSONObject jsonResponse = new JSONObject(response);
                        this.inAppHandler.tryShowAutoTriggerInApp(this.mContext, jsonResponse);
                        break;
                    }
                    case SINGLE_FETCH: {
                        Logger.v("InAppNetworkCallsTask: executing single fetch in-apps");
                        response = APIManager.fetchSingleInApp(this.mContext, this.API, this.paramsMap);
                        if (!TextUtils.isEmpty((CharSequence)response)) {
                            JSONObject jsonResponse = new JSONObject(response);
                            this.inAppHandler.showLinkedInApp(this.mContext, jsonResponse, this.paramsMap);
                            break;
                        }
                        String errorString = "Network Error Could not show test in-app.\n CampaignId : " + this.paramsMap.get("campaign_id") + ".\nPlease try again or contact MoEngage Support with the screenshot.";
                        this.inAppHandler.showTestInAppErrorDialog(errorString);
                    }
                }
            }
            catch (Exception e) {
                Logger.f("InAppNetworkCallsTask : execute JSONException", e);
            }
        }
        Logger.v("InAppNetworkCallsTask : completed execution");
        return this.mTaskResult;
    }

    @Override
    public String getTaskTag() {
        return "INAPP_NETWORK_TASK";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }
}

