package com.moengage.core.integrationVerification;

import android.content.Context;
import android.os.Bundle;
import com.delight.pushlibrary.R;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.IntegrationVerificationNetworkCallTask;
import com.moengage.core.IntegrationVerificationNetworkCallTask.TASK_TYPE;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.OnTaskCompleteListener;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskProcessor;
import com.moengage.core.executor.TaskResult;

/**
 * @author Umang Chamaria
 */

public class IntegrationVerificationPresenter
    implements IntegrationVerificationContract.Presenter, OnTaskCompleteListener {
  private Context context;
  private IntegrationVerificationContract.View view;

  public IntegrationVerificationPresenter(Context context,
      IntegrationVerificationContract.View view) {
    this.context = context;
    this.view = view;
    TaskProcessor.getInstance().setOnTaskCompleteListener(this);
  }

  @Override public void registerDevice() {
    MoEDispatcher.getInstance(context)
        .addTaskToQueueBeginning(
            new IntegrationVerificationNetworkCallTask(context, TASK_TYPE.REGISTER_DEVICE));
    view.showLoadingDialog("Registering Device for Integration Verification");
  }

  @Override public void unregisterDevice() {
    MoEDispatcher.getInstance((context))
        .addTaskToQueueBeginning(
            new IntegrationVerificationNetworkCallTask(context, TASK_TYPE.UNREGISTER_DEVICE));
    view.showLoadingDialog("Un-registering Device from Integration Verification");
  }

  @Override public void checkAndRestoreState() {
    MoEUtils.updateTestDeviceState(context);
    if (!ConfigurationProvider.getInstance(context).isDeviceRegisteredForVerification()){
      registerDevice();
    }else {
      view.messageAndButton("Device is registered for Integration verification. Click on the "
          + "button to un-register your device.", R.id.unregisterButton);
    }
  }

  @Override public void onTaskComplete(String tag, TaskResult taskResult) {
    switch (tag) {
      case SDKTask.TAG_INTEGRATION_VERIFICATION_NETWORK_TASK:
        Bundle result = (Bundle)taskResult.getPayload();
        view.dismissLoadingDialog();
        view.messageAndButton(result.getString("message"), result.getInt("button_id"));
    }
  }
}
