/* ************************************************************************
 * 
 * MOENGAGE CONFIDENTIAL
 * __________________
 * 
 *  [2014] - [2015] MoEngage Inc. 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moengage.core;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager.NameNotFoundException;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.models.UserAttribute;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moe.pushlibrary.utils.ReflectionUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import static android.Manifest.permission.ACCESS_WIFI_STATE;
import static android.Manifest.permission.READ_PHONE_STATE;
import static android.content.Context.CONNECTIVITY_SERVICE;
import static android.content.Context.TELEPHONY_SERVICE;
import static android.content.pm.PackageManager.FEATURE_TELEPHONY;
import static android.provider.Settings.Secure.ANDROID_ID;
import static android.provider.Settings.Secure.getString;
import static com.moengage.core.MoEConstants.API_V2_INDIA;

/**
 * @author MoEngage (abhishek@moenegage.com)
 * @version 5.0
 * @since 1.0
 */
public final class MoEUtils {

  @Nullable static JSONObject deviceInfo(Context context) {
    if (ConfigurationProvider.getInstance(context).isDeviceAttributesCollectionProhibited()) {
      return null;
    }
    JSONObject jsonDevice = new JSONObject();
    try {
      jsonDevice.put("OS_VERSION", Build.VERSION.RELEASE); //string
      jsonDevice.put("OS_API_LEVEL", Build.VERSION.SDK_INT); //int
      jsonDevice.put("DEVICE", Build.DEVICE); //string
      jsonDevice.put("MODEL", Build.MODEL); //string
      jsonDevice.put("PRODUCT", Build.PRODUCT); //string
      jsonDevice.put("MANUFACTURER", Build.MANUFACTURER);
      //GOOGLE PLAY SERVICES INFO
      //boolean isAvailable = MoEHelperUtils.checkPlayServices(context);
      //jsonDevice.put("HAS_PLAY_SERVICES", isAvailable);
      //if (isAvailable) {
      if (!ConfigurationProvider.getInstance(context).isAdIdCollectionProhibitted()) {
        AdvertisingIdClient.AdInfo adInfo = MoEUtils.getAdvertisementInfo(context);
        if (null != adInfo) {
          jsonDevice.put(MoEConstants.ATTR_MOE_GAID, adInfo.getId());
          jsonDevice.put(MoEConstants.ATTR_IS_LAT, adInfo.isLimitAdTrackingEnabled());
        }
      }
      try {
        int v = context.getPackageManager().getPackageInfo("com.google.android.gms", 0).versionCode;
        jsonDevice.put("GOOGLE_PLAY_SERVICES_VERSION", v);
      } catch (NameNotFoundException e) {
        Logger.f("Google Play services version: ", e);
      } catch (Exception e) {
        Logger.f("Google Play services version: ", e);
      }
      //}
      //get display data
      WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
      DisplayMetrics outMetrics = new DisplayMetrics();
      wm.getDefaultDisplay().getMetrics(outMetrics);
      jsonDevice.put("DENSITYDPI", outMetrics.densityDpi);
      jsonDevice.put("WIDTH", outMetrics.widthPixels);
      jsonDevice.put("HEIGHT", outMetrics.heightPixels);
      //get device information
      String imei = getIMEI(context);
      if (!TextUtils.isEmpty(imei)) {
        jsonDevice.put("IMEI", imei);
      }
      String deviceId = getAndroidID(context);
      if (!TextUtils.isEmpty(deviceId)) {
        jsonDevice.put("DEVICE_ID", deviceId);
      }
      String operator = getOperatorName(context);
      if (!TextUtils.isEmpty(operator)) {
        jsonDevice.put("CARRIER", operator);
      }
    } catch (Exception e) {
      Logger.f("MoEUtils: deviceInfo", e);
    }
    return jsonDevice;
  }

  @Nullable private static String getOperatorName(Context context) {
    try {
      if (!ConfigurationProvider.getInstance(context).isOperatorNameCollectionProhibited()) {
        if (MoEHelperUtils.hasPermission(context, READ_PHONE_STATE) && hasFeature(context,
            FEATURE_TELEPHONY)) {
          TelephonyManager telephonyManager =
              ((TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE));
          return telephonyManager.getSimOperatorName();
        }
      }
    } catch (Exception ignored) {
    }
    return null;
  }

  public static String convertBundletoJSONString(Bundle newBundle) {
    Set<String> keys = newBundle.keySet();
    JSONObject jsonObject = new JSONObject();
    for (String key : keys) {
      try {
        jsonObject.put(key, newBundle.get(key));
      } catch (Exception e) {
        Logger.f("MoEUtils:convertBundletoJSONString", e);
      }
    }
    return jsonObject.toString();
  }

  public static void showNormalDialogWithOk(String message, Context context) {
    if (null == context) return;
    AlertDialog.Builder builder = new AlertDialog.Builder(context);
    builder.setMessage(message).setPositiveButton("OK", new DialogInterface.OnClickListener() {
      public void onClick(DialogInterface dialog, int id) {
      }
    });
    AlertDialog dialog = builder.create();
    dialog.show();
  }

  public static void showCouponDialog(String message, final String couponcode,
      final Context context) {
    if (null == context) return;
    AlertDialog.Builder builder = new AlertDialog.Builder(context);
    builder.setMessage(message)
        .setPositiveButton("Copy Code", new DialogInterface.OnClickListener() {
          public void onClick(DialogInterface dialog, int id) {
            MoEHelperUtils.copyCouponCodeToClipboard(context, couponcode);

            JSONObject newJson = new JSONObject();
            try {
              newJson.put("coupon_code", couponcode);
            } catch (Exception e) {
              Logger.f("showCouponDialog", e);
            }

            MoEHelper.getInstance(context)
                .trackEvent(MoEConstants.EVENT_ACTION_COUPON_CODE_COPY, newJson);
          }
        });
    AlertDialog dialog = builder.create();
    dialog.show();
  }

  /*
   * Checks if user has enabled "Opt out of interest-based ads"
   *
   * @param context An instance of the application {@link Context}
   * @return return {@link AdvertisingIdClient.AdInfo}
   */
  @Nullable public static AdvertisingIdClient.AdInfo getAdvertisementInfo(Context context) {
    try {
      try {
        return AdvertisingIdClient.getAdvertisingIdInfo(context);
      } catch (Exception e) {
        Object adInfo = ReflectionUtils.invokeStatic(
            "com.google.android.gms.ads.identifier.AdvertisingIdClient", "getAdvertisingIdInfo",
            new Class[] { Context.class }, new Object[] { context });
        if (null != adInfo) {
          String advertisingId =
              (String) ReflectionUtils.invokeInstance(adInfo, "getId", null, null);
          boolean isLimit =
              ((Boolean) ReflectionUtils.invokeInstance(adInfo, "isLimitAdTrackingEnabled", null,
                  null)).booleanValue();
          return new AdvertisingIdClient.AdInfo(
              TextUtils.isEmpty(advertisingId) ? null : advertisingId, isLimit ? 1 : 0);
        } else {
          Logger.v(
              "It is advised that you add ----> com.google.android.gms:play-services-ads:7.5.0");
        }
      }
    } catch (Exception e) {
      Logger.f("MoEUtils:getAdvertisementInfo", e);
    }
    return null;
  }

  /**
   * Set the current exponential back off counter whihc needs to be used for
   * the device add call or the GCM registration
   *
   * @param context An instance of the Application Context
   * @param delayInSeconds The exponential backoff counter in seconds
   */
  public static void saveCurrentExponentialCounter(Context context, int delayInSeconds) {
    if (null == context) return;
    SharedPreferences sp = getSharedPrefs(context);
    sp.edit().putInt(MoEConstants.EXPONENTIAL_CONSTANT_MOE, delayInSeconds).apply();
  }

  /**
   * Get the current exponential backoff counter which needs to be used for
   * GCM registration or device add call
   *
   * @param context AN instance of the application context
   * @return the exponential back off counter in seconds
   */
  public static int getCurrentExponentialCounter(Context context) {
    if (null == context) return 1;
    SharedPreferences sp = getSharedPrefs(context);
    return sp.getInt(MoEConstants.EXPONENTIAL_CONSTANT_MOE, 1);
  }

  /**
   * Set install registered state as true
   *
   * @param context Application Context
   */
  public static void setInstallRegistered(Context context) {
    if (null == context) return;
    SharedPreferences sp = getSharedPrefs(context);
    sp.edit().putBoolean(MoEConstants.PREF_KEY_INSTALL_LOGGED, true).apply();
  }

  /**
   * Check whether install has been registered or not
   *
   * @param context Application Context
   * @return true if the install has been registered and false otherwise
   */
  public static boolean isInstallRegistered(Context context) {
    if (null == context) return false;
    SharedPreferences sp = getSharedPrefs(context);
    return sp.getBoolean(MoEConstants.PREF_KEY_INSTALL_LOGGED, false);
  }

  private static SharedPreferences getSharedPrefs(Context context) {
    if (null == context) return null;
    return context.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE);
  }

  private static final String PREF_NAME = "pref_moe";

  public static boolean isRegistrationScheduled(Context context) {
    SharedPreferences sp = getSharedPrefs(context);
    return sp.getBoolean(MoEConstants.PREF_KEY_DEVICE_ADD_SCHEDULED, false);
  }

  public static void setRegistrationScheduled(Context context, boolean scheduled) {
    SharedPreferences sp = getSharedPrefs(context);
    sp.edit().putBoolean(MoEConstants.PREF_KEY_DEVICE_ADD_SCHEDULED, scheduled).apply();
  }

  /* Returns true if the application has the given feature. */
  public static boolean hasFeature(Context context, String feature) {
    return context.getPackageManager().hasSystemFeature(feature);
  }

  /* Returns true if the string is null, or empty (once trimmed). */
  public static boolean isNullOrEmpty(CharSequence text) {
    return TextUtils.isEmpty(text) || TextUtils.getTrimmedLength(text) == 0;
  }

  /* Returns true if the collection or has a size 0. */
  public static boolean isNullOrEmpty(Collection collection) {
    return collection == null || collection.size() == 0;
  }

  /*
   * @param map
   * @return Returns true if the map is null or empty, false otherwise.
   * */
  public static boolean isNullOrEmpty(Map map) {
    return map == null || map.size() == 0;
  }

  /*
   * @param context Application Context
   * @return Returns the system service for the given string.
   * */
  @SuppressWarnings("unchecked") public static <T> T getSystemService(Context context,
      String serviceConstant) {
    return (T) context.getSystemService(serviceConstant);
  }

  public static String getAndroidID(Context context) {
    if (!ConfigurationProvider.getInstance(context).isAndroidIdCollectionProhibited()) {
      String androidId = getString(context.getContentResolver(), ANDROID_ID);
      if (!isNullOrEmpty(androidId) && !"9774d56d682e549c".equals(androidId) && !"unknown".equals(
          androidId) && !"000000000000000".equals(androidId)) {
        return androidId;
      }
    }
    return null;
  }

  public static String getIMEI(Context context) {
    try {
      if (!ConfigurationProvider.getInstance(context).isIMEICollectionProhibited() && MoEHelperUtils
          .hasPermission(context, READ_PHONE_STATE) && hasFeature(context, FEATURE_TELEPHONY)) {
        TelephonyManager telephonyManager = getSystemService(context, TELEPHONY_SERVICE);
        return telephonyManager.getDeviceId();
      }
    } catch (Exception ignored) {
    }
    return null;
  }

  public static String getNetworkType(Context context) {
    try {
      if (MoEHelperUtils.hasPermission(context, ACCESS_WIFI_STATE)) {
        NetworkInfo wifiInfo =
            ((ConnectivityManager) context.getSystemService(CONNECTIVITY_SERVICE)).getNetworkInfo(
                1);
        if ((null != wifiInfo) && (wifiInfo.isConnectedOrConnecting())) {
          return "wifi";
        }
      }
      if (MoEHelperUtils.hasPermission(context, READ_PHONE_STATE) && hasFeature(context,
          FEATURE_TELEPHONY)) {
        TelephonyManager telephonyManager = getSystemService(context, TELEPHONY_SERVICE);
        int type = telephonyManager.getNetworkType();
        switch (type) {
          case TelephonyManager.NETWORK_TYPE_GPRS:
          case TelephonyManager.NETWORK_TYPE_EDGE:
          case TelephonyManager.NETWORK_TYPE_CDMA:
          case TelephonyManager.NETWORK_TYPE_1xRTT:
          case TelephonyManager.NETWORK_TYPE_IDEN: //api<8 : replace by 11
            return "2G";
          case TelephonyManager.NETWORK_TYPE_UMTS:
          case TelephonyManager.NETWORK_TYPE_EVDO_0:
          case TelephonyManager.NETWORK_TYPE_EVDO_A:
          case TelephonyManager.NETWORK_TYPE_HSDPA:
          case TelephonyManager.NETWORK_TYPE_HSUPA:
          case TelephonyManager.NETWORK_TYPE_HSPA:
          case TelephonyManager.NETWORK_TYPE_EVDO_B: //api<9 : replace by 14
          case TelephonyManager.NETWORK_TYPE_EHRPD:  //api<11 : replace by 12
          case TelephonyManager.NETWORK_TYPE_HSPAP:  //api<13 : replace by 15
            return "3G";
          case TelephonyManager.NETWORK_TYPE_LTE:    //api<11 : replace by 13
            return "4G";
          default:
            return "CouldNotDetermine";
        }
      }
    } catch (Exception e) {
      Logger.f("MoEUtils: getNetworkType", e);
    }
    return null;
  }

  /**
   * Call this for tracking activity see and activity stopped only<br>
   * <b>Note : Don't call from UI thread.</b>
   *
   * @param activityState activity state being tracked
   * @param activityName The name of the activity which is changing view state
   * @param context An instance of the application {@link Context}
   */
  @WorkerThread static void trackActivityStates(String activityState, String activityName,
      Context context) {
    JSONObject activityJson = new JSONObject();
    try {
      activityJson.put(MoEConstants.EVENT_ACTIVITY_NAME, activityName);
      trackEventInternal(activityState, activityJson, context);
    } catch (Exception e) {
      Logger.f("MoEUtils :trackActivityStates", e);
    }
  }

  static void trackEventInternal(String event, JSONObject object, Context context) {
    Event ev = new Event(event, object);
    MoEDAO.getInstance(context).addEvent(ev, context);
  }

  /**
   * Sets a user attribute
   *
   * @param context Application/Activity context
   * @param attr attribute name
   * @param value value for the attribute
   */
  public static void setUserAttributeInternal(Context context, String attr, String value) {
    JSONObject userJson = new JSONObject();
    try {
      userJson.put(attr, value);
      trackEventInternal(MoEConstants.EVENT_ACTION_USER_ATTRIBUTE, userJson, context);
    } catch (Exception e) {
      Logger.f("MoEutils : setUserAttribute", e);
    }
  }

  public static String getAPIRoute(Context context) {
    int region = ConfigurationProvider.getInstance(context).getDataRegion();
    if (region != -999){
      switch(region){
        case MoEHelperConstants.MOE_REGION_EU:
          return MoEConstants.API_V2_EU;
        case MoEHelperConstants.MOE_REGION_INDIA:
          return MoEConstants.API_V2_INDIA;
        case MoEHelperConstants.MOE_REGION_DEFAULT:
          return MoEConstants.API_GENERAL_V2;
        default:
          return MoEConstants.API_GENERAL_V2;
      }
    }else {
      if (ConfigurationProvider.getInstance(context).shouldRouteTraffic()) {
        return API_V2_INDIA;
      }
    }
    return MoEConstants.API_GENERAL_V2;
  }

  public static String addDebugIfRequired(Context con, String appId) {
    boolean DEBUG_ENABLED =
        (0 != (con.getApplicationInfo().flags & ApplicationInfo.FLAG_DEBUGGABLE));
    if (DEBUG_ENABLED) {
      appId += "_DEBUG";
    }
    return appId;
  }

  @Nullable public static Bundle convertMapToBundle(Map<String, String> map) {
    if (map == null) return null;
    Bundle bundle = new Bundle();
    try {
      for (Map.Entry<String, String> entry : map.entrySet()) {
        bundle.putString(entry.getKey(), entry.getValue());
      }
    } catch (Exception e) {
      Logger.f("MoEUtils#convertMapToBundle : Exception", e);
    }
    return bundle;
  }

  @Nullable public static Bundle jsonToBundle(JSONObject json) {
    if (json == null) return null;
    try {
      Bundle bundle = new Bundle();
      Iterator iter = json.keys();
      while (iter.hasNext()) {
        String key = (String) iter.next();
        String value = json.getString(key);
        bundle.putString(key, value);
      }
      return bundle;
    } catch (JSONException e) {
      Logger.f("MoEUtils : jsonToBundle", e);
    }
    return null;
  }

  public static void updateTestDeviceState(Context context) {
    long registeredTime =
        ConfigurationProvider.getInstance(context).getVerificationRegistrationTime();
    if ((registeredTime + (3600 * 1000)) < System.currentTimeMillis()) {
      ConfigurationProvider.getInstance(context).setVerificationRegistration(false);
    }
  }

  @Nullable static String convertJSONArrayToString(JSONArray array) {
    if (array == null) return null;
    StringBuilder builder = new StringBuilder();
    try {
      for (int i = 0; i < array.length(); i++) {
        builder.append((String) array.get(i));
        if (i != array.length() - 1) {
          builder.append(MoEConstants.EVENT_SEPERATOR);
        }
      }
      return builder.toString();
    } catch (Exception e) {
      Logger.f("MoEUtils: convertJSONArrayToString", e);
    }
    return null;
  }

  static JSONArray convertStringToJSONArray(String jsonArrayString){
    if (TextUtils.isEmpty(jsonArrayString)) return new JSONArray();
    JSONArray array = new JSONArray();
    String[] arrayElements = jsonArrayString.split(MoEConstants.EVENT_SEPERATOR);
    for (String element:arrayElements) {
      array.put(element);
    }
    return array;
  }

  @Nullable static UserAttribute getUserAttributePoJo(JSONObject userJSON) {
    UserAttribute userAttribute = null;
    try {
      Iterator jsonKeys = userJSON.keys();
      while (jsonKeys.hasNext()) {
        userAttribute = new UserAttribute();
        userAttribute.userAttributeName = (String) jsonKeys.next();
        userAttribute.userAttributeValue = userJSON.getString(userAttribute.userAttributeName);
      }
    } catch (Exception e) {
      Logger.f("MoEDispatcher : getUserAttributePoJo", e);
    }
    return userAttribute;
  }

  static boolean shouldSendUserAttribute(UserAttribute currentUserAttributes,
      UserAttribute savedUserAttributes){
    return currentUserAttributes == null
        || savedUserAttributes == null
        || !savedUserAttributes.equals(currentUserAttributes);
  }

  @Nullable static UserAttribute getSavedUserAttribute(Context context, String userAttributeName){
    return MoEDAO.getInstance(context).getUserAttributesForKey(userAttributeName);
  }

}
