package com.moengage.core;

import android.content.Context;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;

/**
 * Makes a device add call on fresh installation
 * Service constant MSG_DEVICE_ADD
 * @author Umang Chamaria
 */
public class DeviceAddTask extends SDKTask {

  public DeviceAddTask(Context context) {
    super(context);
  }

  @Override public TaskResult execute() {
    Logger.v("DeviceAddTask : execution started");
      if (APIManager.addDevice(mContext)) {
        ConfigurationProvider.getInstance(mContext).setDeviceRegistered(true);
        MoEUtils.saveCurrentExponentialCounter(mContext, 1);
        MoEDispatcher.getInstance(mContext).cancelRegistrationFallback();
        mTaskResult.setIsSuccess(true);
      }
    Logger.v("DeviceAddTask : execution completed");
    return mTaskResult;
  }

  @Override public String getTaskTag() {
    return TAG_DEVICE_ADD;
  }

  @Override public boolean isSynchronous() {
    return true;
  }
}
