/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.inapp.InAppController;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class MoEEventManager {
    private static MoEEventManager _INSTANCE = null;
    private List<String> mBlackListedEvents = null;
    private ConfigurationProvider mConfigProvider = null;
    private Context mContext;
    private int mEventCounter = 0;
    private List<String> mTriggerEvents;
    private List<String> mFlushEvents;

    private MoEEventManager(Context context) {
        this.mContext = context;
        this.mConfigProvider = ConfigurationProvider.getInstance(context);
        this.getBlackListedEvents();
        this.getTriggerEvents();
        this.getFlushEvents();
    }

    public static MoEEventManager getInstance(Context context) {
        if (_INSTANCE == null) {
            _INSTANCE = new MoEEventManager(context);
        }
        return _INSTANCE;
    }

    private boolean isEventBlackListed(String eventName) {
        return !this.mBlackListedEvents.isEmpty() && this.mBlackListedEvents.contains(eventName);
    }

    void getBlackListedEvents() {
        try {
            String[] blackListEventArrary;
            this.mBlackListedEvents = new ArrayList<String>();
            String blackListEventsString = this.mConfigProvider.getBlackListEvents();
            if (!TextUtils.isEmpty((CharSequence)blackListEventsString) && (blackListEventArrary = blackListEventsString.split(";")) != null && blackListEventArrary.length > 0) {
                for (String blackEvent : blackListEventArrary) {
                    this.mBlackListedEvents.add(blackEvent);
                }
            }
        }
        catch (Exception e) {
            Logger.e("MoEEventManager: getBlackListedEvents() ", e);
        }
    }

    int getEventCounter() {
        return this.mEventCounter;
    }

    void incrementEventCounter() {
        ++this.mEventCounter;
    }

    void setEventCounter(int counter) {
        this.mEventCounter = counter;
    }

    public void trackEvent(String action, JSONObject attrs) {
        try {
            if (!this.mConfigProvider.isAppEnabled()) {
                return;
            }
            if (this.isEventBlackListed(action)) {
                Logger.e("MoEEventManager: Event Blacklisted : " + action);
                return;
            }
            Event event = new Event(MoEHelperUtils.getDatapointJSON(action.trim(), attrs));
            if (action.equals("INSTALL")) {
                MoEUtils.setInstallRegistered(this.mContext);
            }
            if (this.isSmartTriggerEvent(action)) {
                Logger.v("MoEEventManager:acting on auto trigger");
                InAppController.InAppHandler inAppHandler = InAppController.getInstance().getInAppHandler();
                if (inAppHandler != null) {
                    inAppHandler.registerAutoTriggerEvent(this.mContext, event);
                }
            }
            MoEDispatcher.getInstance(this.mContext).writeDataPointToStorage(event);
            if (this.isFlushEvent(action)) {
                Logger.v("MoEEventManager: trackEvent() flush event, flushing events");
                MoEHelper.getInstance(this.mContext).syncInteractionDataNow();
            }
        }
        catch (Exception e) {
            Logger.f("MoEEventManager: trackEvent() ", e);
        }
    }

    private boolean isSmartTriggerEvent(String action) {
        return this.mTriggerEvents != null && this.mTriggerEvents.contains(action) || "INSTALL".equals(action);
    }

    public void getTriggerEvents() {
        try {
            String list = this.mConfigProvider.getSmartTriggerList();
            if (list == null) {
                Logger.v("MoEEventManager:No smart triggers found");
                return;
            }
            String[] triggers = list.split(";");
            this.mTriggerEvents = new ArrayList<String>(triggers.length);
            for (String event : triggers) {
                this.mTriggerEvents.add(event);
            }
        }
        catch (Exception e) {
            Logger.e("MoEEventManager: getTriggerEvents()", e);
        }
    }

    void getFlushEvents() {
        try {
            String events = this.mConfigProvider.getFlushEvents();
            if (TextUtils.isEmpty((CharSequence)events)) {
                Logger.v("MoEEventManager: getFlushEvents() No flush events");
                return;
            }
            String[] flushEvents = events.split(";");
            this.mFlushEvents = new ArrayList<String>(flushEvents.length);
            for (String event : flushEvents) {
                this.mFlushEvents.add(event);
            }
        }
        catch (Exception e) {
            Logger.e("MoEEventManager: getFlushEvents()");
        }
    }

    private boolean isFlushEvent(String eventName) {
        return this.mFlushEvents != null && this.mFlushEvents.contains(eventName);
    }
}

