package com.moengage.core.integrationVerification;

/**
 * @author Umang Chamaria
 */

public class IntegrationVerificationContract {

  interface View {
    /**
     *
     * @param message
     */
    void showLoadingDialog(String message);

    /**
     *
     */
    void dismissLoadingDialog();

    /**
     *
     * @param message
     * @param buttonId
     */
    void messageAndButton(String message, int buttonId);
  }

  interface Presenter {
    /**
     * Register device for integration verification
     */
    void registerDevice();

    /**
     * Unregister device from verification
     */
    void unregisterDevice();

    /**
     * Check if device is registered or not. If registered, show option to unregister, else
     * register.
     */
    void checkAndRestoreState();
  }
}
