/* ************************************************************************
 * 
 * MOENGAGE CONFIDENTIAL
 * __________________
 * 
 *  [2014] - [2015] MoEngage Inc. 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moengage.core;

import android.Manifest;
import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moe.pushlibrary.exceptions.SDKNotInitializedException;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.MoERestClient.API_VERSION;
import com.moengage.core.MoERestClient.RequestMethod;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

/**
 * This class is responsible for all interactions with the MoE servers.
 *
 * @author MoEngage (abhishek@moengage.com)
 * @version 5.0
 * @since 5.0
 */
public final class APIManager {

  private APIManager() {
    // Constructor intentionally made private. Utility class cannot be
    // instantiated
  }

  /*
   * Makes a device add call to the backend
   *
   * @param con Instance of the Application {@link Context}
   * @return true if device add was successful false otherwise
   */
  public static boolean addDevice(Context con) {
    Logger.v("APIManager:Sending GCM Client ID to server");
    try {
      if (!ConfigurationProvider.getInstance(con).isAppEnabled()) return false;
      MoERestClient client =
          new MoERestClient(MoEUtils.getAPIRoute(con) + MoEConstants.API_ENDPOINT_REGISTER_GCM_V2,
              con, API_VERSION.V2);
      JSONObject deviceInfo = MoEUtils.deviceInfo(con);
      if (deviceInfo != null) {
        client.addBody(deviceInfo.toString());
      }
      client.execute(RequestMethod.POST);
      return MoEParser.parseRegistrationResponse(client.getResponseCode());
    } catch (UnsupportedEncodingException e) {
      Logger.f("APIManager:registerDevice", e);
    } catch (IOException e) {
      Logger.f("APIManager:registerDevice", e);
    } catch (SDKNotInitializedException e) {
      Logger.f("APIManager:registerDevice", e);
    } catch (Exception e) {
      Logger.f("APIManager:registerDevice", e);
    }
    return false;
  }

  /*
   * @param con Instance of the Application {@link Context}
   * @param interactionData The interaction data collected by the SDK
   * @return true if the report add was successful.
   * @throws APIFailedException
   */
  static boolean sendInteractionReport(Context con, String interactionData, String endpoint){
    Logger.v("APIManager:Sending interaction report ");
    try {
      if (!ConfigurationProvider.getInstance(con).isAppEnabled()) return false;
      MoERestClient client =
          new MoERestClient(MoEUtils.getAPIRoute(con) + endpoint, con, API_VERSION.V2);
      client.addBody(interactionData);
      client.execute(RequestMethod.POST);
      return MoEParser.parseReportAddResponse(client.getResponseCode());
    } catch (UnsupportedEncodingException e) {
      Logger.f("APIManager: sendInteractionReport: UnsupportedEncodingException", e);
    } catch (IOException e) {
      Logger.f("APIManager: sendInteractionReport: IOException", e);
    } catch (SDKNotInitializedException e) {
      Logger.f("APIManager: sendInteractionReport", e);
    } catch (Exception e) {
      Logger.f("APIManager: sendInteractionReport", e);
    }
    return false;
  }

  /*
   * @param con Instance of the Application {@link Context}
   * @param API API to trigger
   * @param paramsMap Body of API
   */
  @Nullable public static String getGeoFences(Context con, String API,
      HashMap<String, String> paramsMap) {
    Logger.v("APIManager: getGeoFences: Get geo fences");
    if ((MoEHelperUtils.hasPermission(con, Manifest.permission.ACCESS_FINE_LOCATION)
        || MoEHelperUtils.hasPermission(con, Manifest.permission.ACCESS_COARSE_LOCATION))) {
      try {
        if (!ConfigurationProvider.getInstance(con).isAppEnabled() || !ConfigurationProvider
            .getInstance(con).isGeoEnabled()) return null;
        MoERestClient client = new MoERestClient(API, con, MoERestClient.API_VERSION.V1);
        client.addParam(paramsMap);
        client.execute(MoERestClient.RequestMethod.GET);
        if (!MoEParser.isHttpStatusOk(client.getResponseCode())) {
          return null;
        }
        if (MoEParser.isValidAPIResponse(client.getResponse(), MoERestClient.API_VERSION.V1)) {
          return client.getResponse();
        }
      } catch (UnsupportedEncodingException e) {
        Logger.f("APIManager: getGeoFences", e);
      } catch (Exception e) {
        Logger.f("APIManager: getGeoFences", e);
      }
    }
    return null;
  }

  /*
   * @param con Instance of the Application {@link Context}
   */
  static void geoFenceHit(Context con, String API, HashMap<String, String> paramsMap) {
    Logger.v("APIManager:Registering a Geofence hit");
    try {
      if (!ConfigurationProvider.getInstance(con).isAppEnabled() || !ConfigurationProvider
          .getInstance(con).isGeoEnabled()) return;
      MoERestClient client = new MoERestClient(API, con, MoERestClient.API_VERSION.V1);
      client.addParam(paramsMap);
      client.execute(MoERestClient.RequestMethod.GET);
    } catch (UnsupportedEncodingException e) {
      Logger.f("APIManager: geoFenceHit", e);
    } catch (IOException e) {
      Logger.f("APIManager: geoFenceHit", e);
    } catch (SDKNotInitializedException e) {
      Logger.f("APIManager: geoFenceHit", e);
    } catch (Exception e) {
      Logger.f("APIManager: geoFenceHit", e);
    }
  }

  /*
   * @param con Instance of the Application {@link Context}
   * @param paramsMap The last updated time for the local inapp cache
   * @param API API to trigger
   * @param requestBody Request Body
   * @return true if the fetch was successful
   */
  @Nullable static String fetchInAppCampaigns(Context con, String API,
      HashMap<String, String> paramsMap, String requestBody) {
    try {
      if (!ConfigurationProvider.getInstance(con).isAppEnabled() || !ConfigurationProvider
          .getInstance(con).isInAppEnabled()) return null;
      MoERestClient client = new MoERestClient(API, con, API_VERSION.V2);
      client.addParam(paramsMap);
      client.addBody(requestBody);
      client.execute(RequestMethod.POST);
      Logger.v("APIManager: Processing InApp Response - will parse and save data");
      if (!MoEParser.isHttpStatusOk(client.getResponseCode())) {
        return null;
      }
      //update last updated time
      ConfigurationProvider.getInstance(con).setLastInappUpdateTime(System.currentTimeMillis());
      if (!TextUtils.isEmpty(client.getResponse())) {
        Logger.v("APIManager: fetchInAppCampaingn" + client.getResponse());
        return client.getResponse();
      }
    } catch (Exception e) {
      Logger.f("APIManager: fetchInAppCampaigns", e);
    }
    return null;
  }

  /*
   * @param con Instance of the Application {@link Context}
   * @return returns the InAppMessage which needs to be shown for this auto
   * trigger event. If no in app is received then returns null
   */
  @Nullable static String logASmartEvent(Context con, String API, HashMap<String, String> paramsMap,
      String requestBody) {
    try {
      if (!ConfigurationProvider.getInstance(con).isAppEnabled() || !ConfigurationProvider
          .getInstance(con).isInAppEnabled()) return null;
      MoERestClient client = new MoERestClient(API, con, API_VERSION.V2);
      client.addParam(paramsMap);
      client.addBody(requestBody);
      client.execute(RequestMethod.POST);
      Logger.v("APIManager: Processing Smart event response");
      if (!MoEParser.isHttpStatusOk(client.getResponseCode())) {
        return null;
      }
      return client.getResponse();
    } catch (UnsupportedEncodingException e) {
      Logger.f("APIManager: logASmartEvent", e);
    } catch (IOException e) {
      Logger.f("APIManager: logASmartEvent", e);
    } catch (SDKNotInitializedException e) {
      Logger.f("APIManager: logASmartEvent", e);
    } catch (Exception e) {
      Logger.f("APIManager: logASmartEvent", e);
    }
    return null;
  }

  @Nullable static String fetchSingleInApp(Context context, String API,
      HashMap<String, String> requestParams) {
    try {
      if (!ConfigurationProvider.getInstance(context).isAppEnabled() || !ConfigurationProvider
          .getInstance(context).isInAppEnabled()) return null;
      MoERestClient client = new MoERestClient(API, context, API_VERSION.V2);
      client.addParam(requestParams);
      client.execute(RequestMethod.POST);
      if (!MoEParser.isHttpStatusOk(client.getResponseCode())) {
        return null;
      }
      return client.getResponse();
    } catch (Exception e) {
      Logger.f("APIManager: fetchInAppCampaigns", e);
    }
    return null;
  }

  static boolean uploadLogsToLogEntries(Context context, String api, JSONObject jsonObject) {
    try {
      if (!ConfigurationProvider.getInstance(context).isAppEnabled() || !ConfigurationProvider
          .getInstance(context).isLogEntryEnabled()) return false;
      String request = jsonObject.toString();
      Logger.v("API Manager : uploadLogsToLogEntries : URI " + api);
      Logger.v("API Manager : uploadLogsToLogEntries : request " + request);
      if (TextUtils.isEmpty(request)) return false;
      URL url = new URL(api);
      HttpsURLConnection httpsURLConnection = (HttpsURLConnection) url.openConnection();
      httpsURLConnection.setDoOutput(true);
      httpsURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
      httpsURLConnection.setRequestProperty("Content-type", "application/json");
      OutputStream output = httpsURLConnection.getOutputStream();
      output.write(request.getBytes("UTF-8"));
      output.close();
      Logger.v(
          "API Manager : uploadLogsToLogEntries : response" + httpsURLConnection.getResponseCode());
      return httpsURLConnection.getResponseCode() == 204;
    } catch (Exception e) {
      //e.printStackTrace();
    }
    return false;
  }

  @Nullable static String syncConfig(Context context, String API, String postBody) {
    try {
      MoERestClient client = new MoERestClient(API, context, API_VERSION.V2);
      if (!TextUtils.isEmpty(postBody)) client.addBody(postBody);
      client.execute(RequestMethod.POST);
      if (!MoEParser.isHttpStatusOk(client.getResponseCode())) {
        return null;
      }
      ConfigurationProvider.getInstance(context).setLastConfigSyncTime(System.currentTimeMillis());
      return client.getResponse();
    } catch (Exception e) {
      Logger.f("API Manager : syncConfig exception", e);
    }
    return null;
  }

  @Nullable
  static String fetchMessages(Context context, String API, HashMap<String, String> paramsMap,
      String requestBody) {
    try {
      if (!ConfigurationProvider.getInstance(context).isAppEnabled() || !ConfigurationProvider
          .getInstance(context).isInboxEnabled()) return null;
      MoERestClient client = new MoERestClient(API, context, API_VERSION.V2);
      client.addParam(paramsMap);
      client.addBody(requestBody);
      client.execute(RequestMethod.GET);
      if (!MoEParser.isHttpStatusOk(client.getResponseCode())) return null;
      return client.getResponse();
    } catch (Exception e) {
      Logger.f("API Manager : fetchMessages exception", e);
    }
    return null;
  }

  static boolean registerUnregisterDeviceForIntegrationVerification(Context context, String API,
      HashMap<String, String> paramsMap) {
    try {
      if (!ConfigurationProvider.getInstance(context).isAppEnabled())return false;
      MoERestClient client = new MoERestClient(API, context, API_VERSION.V2);
      if (paramsMap != null) {
        client.addParam(paramsMap);
      }
      client.execute(RequestMethod.GET);
      return MoEParser.isHttpStatusOk(client.getResponseCode());
    } catch (Exception e) {
      Logger.f("APIManager : registerUnregisterDeviceForIntegrationVerification :", e);
    }
    return false;
  }
}
