/* ************************************************************************
 * 
 * MOENGAGE CONFIDENTIAL
 * __________________
 * 
 *  [2014] - [2015] MoEngage Inc. 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moe.pushlibrary.activities;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.NavUtils;
import android.support.v4.app.TaskStackBuilder;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.moengage.core.Logger;
import java.util.List;
import org.json.JSONObject;

/**
 * The Activity which helps show the rich landing page
 *
 * @author MoEngage (abhishek@moengage.com)
 * @version 5.0
 * @since 1.0
 */
public class MoEActivity extends MoEBaseActivity {
  final String EVENT_ACTION_WEB_ACTIVITY_CLICK = "EVENT_ACTION_WEB_ACTIVITY_CLICK";
  private WebView webview;

  @SuppressLint("SetJavaScriptEnabled") @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    Bundle newBundle = getIntent().getExtras();
    getWindow().requestFeature(Window.FEATURE_PROGRESS);
    webview = new WebView(this);
    LinearLayout ll = new LinearLayout(this);
    ll.setOrientation(LinearLayout.VERTICAL);
    final ProgressBar pb = new ProgressBar(this, null, android.R.attr.progressBarStyleHorizontal);
    pb.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT,
        LinearLayout.LayoutParams.WRAP_CONTENT));

    webview.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT,
        LinearLayout.LayoutParams.MATCH_PARENT));

    ll.addView(pb);
    ll.addView(webview);

    setContentView(ll);
    String url = null;

    if (newBundle != null && newBundle.containsKey("gcm_webUrl")) {
      url = newBundle.getString("gcm_webUrl");
    }

    if (TextUtils.isEmpty(url)) {
      //no point showing any page if url is not present
      finish();
      return;
    }

    webview.loadUrl(url);

    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
      setUp();
    }

    webview.getSettings().setJavaScriptEnabled(true);
    webview.getSettings().setBuiltInZoomControls(true);

    final Activity mCurrentContext = this;

    webview.setWebChromeClient(new WebChromeClient() {
      @Override public void onProgressChanged(WebView view, int progress) {
        if (progress < 100 && pb.getVisibility() == ProgressBar.GONE) {
          pb.setVisibility(ProgressBar.VISIBLE);
        }
        pb.setProgress(progress);
        if (progress == 100) {
          pb.setVisibility(ProgressBar.GONE);
        }
      }
    });

    webview.setWebViewClient(new WebViewClient() {
      @Override public boolean shouldOverrideUrlLoading(WebView view, String url) {

        JSONObject newJson = new JSONObject();
        try {
          newJson.put("url", url);
        } catch (Exception e1) {
          Logger.f("shouldOverrideUrlLoading", e1);
        }

        mHelper.trackEvent(EVENT_ACTION_WEB_ACTIVITY_CLICK, newJson);
        Uri uri = Uri.parse(url);
        if (uri.getScheme().equals("moengage")) {
          try {
            Intent redirectIntent = new Intent(mCurrentContext, Class.forName(uri.getHost()));
            Bundle newBundle = getParamsInBundle(url);
            if (newBundle != null) {
              redirectIntent.putExtras(newBundle);
            }
            startActivity(redirectIntent);
            return true;
          } catch (ClassNotFoundException e) {
            Logger.f("MoEActivity : activity not found ", e);
          } catch (Exception e) {
            Logger.f("MoEActivity : activity not found ", e);
          }
        } else {
          Intent intent = new Intent(Intent.ACTION_VIEW, uri);
          startActivity(intent);
          return true;
        }
        return false;
      }
    });
  }

  private Bundle getParamsInBundle(String link) {
    if (TextUtils.isEmpty(link)) return null;
    Bundle newBundle = new Bundle();
    UrlQuerySanitizer sanitizer = new UrlQuerySanitizer(link);
    List<UrlQuerySanitizer.ParameterValuePair> nvp = sanitizer.getParameterList();
    if (nvp.isEmpty()) return null;
    for (UrlQuerySanitizer.ParameterValuePair pair : nvp) {
      if (TextUtils.isDigitsOnly(pair.mValue)) {
        newBundle.putInt(pair.mParameter, Integer.parseInt(pair.mValue));
      } else {
        newBundle.putString(pair.mParameter, pair.mValue);
      }
    }
    return newBundle;
  }

  @TargetApi(Build.VERSION_CODES.HONEYCOMB) private void setUp() {
    if (getActionBar() != null) {
      getActionBar().setDisplayHomeAsUpEnabled(true);
    }
  }

  @Override public boolean onOptionsItemSelected(MenuItem item) {
    if (item.getItemId() == android.R.id.home) {
      if (NavUtils.getParentActivityName(this) == null) {
        onBackPressed();
      } else {
        Intent upIntent = NavUtils.getParentActivityIntent(this);

        // This activity is NOT part of this app's task, so create a new task
        // when navigating up, with a synthesized back stack.
        TaskStackBuilder.create(this)
            // Add all of this activity's parents to the back stack
            .addNextIntentWithParentStack(upIntent)
            // Navigate up to the closest parent
            .startActivities();

        return true;
      }
    }
    return super.onOptionsItemSelected(item);
  }

  @Override public boolean onKeyDown(int keyCode, KeyEvent event) {
    // Check if the key event was the Back button and if there's history
    if ((keyCode == KeyEvent.KEYCODE_BACK) && webview.canGoBack()) {
      webview.goBack();
      return true;
    }
    // If it wasn't the Back key or there's no web page history, bubble up to the default
    // system behavior (probably exit the activity)
    return super.onKeyDown(keyCode, event);
  }
}
