package com.moengage.core.executor;

import android.content.Context;

/**
 * @author Umang Chamaria on 11/17/15.
 */
public abstract class SDKTask implements ITask {

  public static final String TAG_CHECK_IN_APPS = "CHECK_IN_APPS";
  public static final String TAG_ACTIVITY_START = "START_ACTIVITY";
  public static final String TAG_SHOW_IN_APP_ON_CONFIG_CHANGE = "SHOW_IN_APP_ON_CONFIG_CHANGE";
  public static final String TAG_NOTIFICATION_CLICKED = "NOTIFICATION_CLICKED";
  public static final String TAG_TRACK_EVENT = "TRACK_EVENT";
  public static final String TAG_GEO_TASK = "GEO_TASK";
  public static final String TAG_LOG_IN_APP_CLICKED = "IN_APP_CLICKED";
  public static final String TAG_DEVICE_ADD = "DEVICE_ADD";
  public static final String TAG_SHOW_LINKED_IN_APP = "SHOW_LINKED_IN_APP";
  public static final String TAG_SEND_INTERACTION_DATA = "SEND_INTERACTION_DATA";
  public static final String TAG_ACTIVITY_STOP = "ACTIVITY_STOP";
  public static final String TAG_CHECK_AND_SHOW_NUDGE = "CHECK_AND_SHOW_NUDGE";
  public static final String TAG_INAPP_NETWORK_TASK = "INAPP_NETWORK_TASK";
  public static final String TAG_SHOW_SELF_HANDLED_INAPP = "SHOW_SELF_HANDLED_INAPP";
  public static final String TAG_SEND_LOG = "SEND_LOG";
  public static final String TAG_SYNC_CONFIG_API = "SYNC_CONFIG";
  public static final String TAG_FETCH_MESSAGES = "FETCH_MESSAGES";
  public static final String TAG_INTEGRATION_VERIFICATION_NETWORK_TASK =
      "INTEGRATION_VERIFICATION_NETWORK_TASK";
  public static final String TAG_SET_USER_ATTRIBUTES = "SET_USER_ATTRIBUTES";
  public static final String TAG_SET_ALIAS = "SET_ALIAS";
  public static final String TAG_SET_DEVICE_ATTRIBUTES = "SET_DEVICE_ATTRIBUTES";
  public static final String TAG_MOE_WORKER_TASK = "MOE_WORKER_TASK";
  public static final String TAG_MOE_PUSH_WORKER_TASK = "MOE_PUSH_WORKER_TASK";
  public static final String TAG_CREATE_DATA_BATCH = "CREATE_DATA_BATCH";



  protected Context mContext;
  protected TaskResult mTaskResult;

  public SDKTask(Context context) {
    mContext = context;
    mTaskResult = new TaskResult();
    mTaskResult.setIsSuccess(false);
  }

  @Override public void onPostExecute(TaskResult result) {

  }

  public TaskResult createTaskResult(Object payload, boolean taskState){
    mTaskResult.setPayload(payload);
    mTaskResult.setIsSuccess(taskState);
    return mTaskResult;
  }
}