package com.moengage.core;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import com.delight.pushlibrary.R;
import com.moe.pushlibrary.models.GeoLocation;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.HashMap;

/**
 * @author Umang Chamaria
 */

public class IntegrationVerificationNetworkCallTask extends SDKTask {
  private TASK_TYPE task_type;

  public static final String RESULT_EXTRA_MESSAGE = "message";
  public static final String RESULT_EXTRA_BUTTON_ID = "button_id";

  public IntegrationVerificationNetworkCallTask(Context context, TASK_TYPE task_type) {
    super(context);
    this.task_type = task_type;
  }

  @Override public TaskResult execute() {
    try {
      switch (task_type) {
        case REGISTER_DEVICE:
          registerDevice();
          break;
        case UNREGISTER_DEVICE:
          unregisterDevice();
          break;
        default:
          Logger.e("IntegrationVerificationNetworkCallTask: invalid case");
      }
    } catch (Exception e) {
      Logger.f("IntegrationVerificationNetworkCallTask: Exception ", e);
    }
    return mTaskResult;
  }

  private void unregisterDevice() {
    String API = MoEUtils.getAPIRoute(mContext)
        + MoEConstants.API_ENDPOINT_INTEGRATION_VERIFICATION_UNLINK_DEVICE;
    if (APIManager.registerUnregisterDeviceForIntegrationVerification(mContext, API, null)) {
      ConfigurationProvider.getInstance(mContext).setVerificationRegistration(false);
      createResult(true,
          "Device unregistered successfully. Click on the button to " + "re-register.",
          R.id.retryButton);
    } else {
      createResult(false, "Device could not be unregistered. Click on the button to retry.",
          R.id.unregisterButton);
    }
  }

  private void registerDevice() {
    String API = MoEUtils.getAPIRoute(mContext)
        + MoEConstants.API_ENDPOINT_INTEGRATION_VERIFICATION_DEVICE_REGISTRATION;
    GeoLocation geoLocation =
        ConfigurationProvider.getInstance(mContext).getLastKnownUserLocation();
    if (geoLocation == null) {
      geoLocation = new GeoLocation(0.0, 0.0);
    }
    HashMap<String, String> paramsMap = new HashMap<>();
    paramsMap.put("lat", String.valueOf(geoLocation.latitude));
    paramsMap.put("lng", String.valueOf(geoLocation.longitude));
    paramsMap.put("manufacturer", Build.MANUFACTURER);
    if (APIManager.registerUnregisterDeviceForIntegrationVerification(mContext, API, paramsMap)) {
      //save time in config provider
      //set flag to identify data is to be sent to integration verification server
      //set result as success
      ConfigurationProvider.getInstance(mContext)
          .setVerificationRegistrationTime(System.currentTimeMillis());
      ConfigurationProvider.getInstance(mContext).setVerificationRegistration(true);
      createResult(true, "Device registered successfully. Click on the button to " + "unregister.",
          R.id.unregisterButton);
    } else {
      createResult(false, "Device could not be registered. Click on the button to retry.",
          R.id.retryButton);
    }
  }

  @Override public String getTaskTag() {
    return TAG_INTEGRATION_VERIFICATION_NETWORK_TASK;
  }

  @Override public boolean isSynchronous() {
    return true;
  }

  public enum TASK_TYPE {
    REGISTER_DEVICE, UNREGISTER_DEVICE
  }

  private void createResult(boolean status, String message, int buttonId) {
    Bundle bundle = new Bundle();
    bundle.putString(RESULT_EXTRA_MESSAGE, message);
    bundle.putInt(RESULT_EXTRA_BUTTON_ID, buttonId);
    mTaskResult.setIsSuccess(status);
    mTaskResult.setPayload(bundle);
  }
}
