/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.push;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.PayloadBuilder;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.DeviceAddTask;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import java.util.Map;

public class PushManager {
    public static final String REQ_REGISTRATION = "MOE_REG_REQ";
    public static final String REQ_DELETE_TOKEN = "MOE_DEL_TOK";
    public static final String REQ_REFRESH = "MOE_REG_REFRESH";
    private final String ATTR_PUSH_TOKEN = "push_token";
    private final String ATTR_REGISTRATION_BY = "registered_by";
    private final String TOKEN_EVENT = "TOKEN_EVENT";
    public static final String TOKEN_BY_MOE = "MoE";
    public static final String REG_ON_APP_OPEN = "REG_ON_APP_OPEN";
    private boolean isBaiduEnabled = false;
    public static final String SHOW_NOTIFICATION = "SHOW_NOTIFICATION";
    private final Object lock = new Object();
    private static PushManager _INSTANCE = null;
    private static final String ID_PREFIX = "|ID|";
    private PushHandler pushHandler;
    private boolean backStackBuilderOptoutFlag = false;
    private OnTokenReceivedListener tokenListener;
    private boolean optOutOfMoEngageExtras = false;

    private PushManager() {
        this.loadPushHandler();
    }

    private void loadPushHandler() {
        try {
            if (!this.isBaiduEnabled) {
                try {
                    Class<?> handler = Class.forName("com.moengage.firebase.PushHandlerImpl");
                    this.pushHandler = (PushHandler)handler.newInstance();
                    Logger.v("PushManager:loadPushHandler FCM Enabled");
                }
                catch (Exception e) {
                    Class<?> handler = Class.forName("com.moengage.push.gcm.PushHandlerImpl");
                    this.pushHandler = (PushHandler)handler.newInstance();
                    Logger.v("PushManager:loadPushHandler GCM Enabled");
                }
            } else {
                Class<?> handler = Class.forName("com.moengage.baidu.PushHandlerImpl");
                this.pushHandler = (PushHandler)handler.newInstance();
                Logger.v("PushManager:loadPushHandler Baidu Enabled");
            }
        }
        catch (Exception e) {
            Logger.e("PushManager : loadPushHandler : did not find supported module: " + e.getMessage());
        }
    }

    public static PushManager getInstance() {
        if (null == _INSTANCE) {
            _INSTANCE = new PushManager();
        }
        return _INSTANCE;
    }

    public void setMessageListener(Object messageListener) {
        if (this.pushHandler != null) {
            this.pushHandler.setMessageListener(messageListener);
        }
    }

    public void refreshToken(Context context, String token) {
        this.refreshTokenInternal(context, token, "App");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTokenInternal(Context context, String token, String pushRegisteredBy) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            return;
        }
        Logger.v("PushManager:refreshToken");
        Object object = this.lock;
        synchronized (object) {
            Logger.v("PushManager:refreshToken before ripping: = " + token);
            token = this.ripMultiplexingExtras(token);
            if (this.tokenListener != null) {
                this.tokenListener.onTokenReceived(token);
            }
            String oldRegId = ConfigurationProvider.getInstance(context).getGCMToken();
            boolean update = this.tokenRefreshRequired(context, token);
            if (update || !ConfigurationProvider.getInstance(context).isDeviceRegistered()) {
                ConfigurationProvider.getInstance(context).setGCMToken(token);
                MoEDispatcher.getInstance(context).addTaskToQueue(new DeviceAddTask(context));
                PayloadBuilder payloadBuilder = new PayloadBuilder();
                payloadBuilder.putAttrString("push_token", token);
                payloadBuilder.putAttrString("registered_by", pushRegisteredBy);
                MoEHelper.getInstance(context).trackEvent("TOKEN_EVENT", payloadBuilder.build());
            }
            Logger.v("PushManager:refreshToken oldId: = " + oldRegId + " token = " + token + " --updating[true/false]: " + update);
        }
    }

    private String ripMultiplexingExtras(String token) {
        return !TextUtils.isEmpty((CharSequence)token) && token.startsWith(ID_PREFIX) ? token.substring(7) : token;
    }

    public boolean tokenRefreshRequired(Context context, String newToken) {
        if (!TextUtils.isEmpty((CharSequence)newToken)) {
            String oldToken = ConfigurationProvider.getInstance(context).getGCMToken();
            return TextUtils.isEmpty((CharSequence)oldToken) || !newToken.equals(oldToken);
        }
        return false;
    }

    public PushHandler getPushHandler() {
        return this.pushHandler;
    }

    public final void optoutBackStackBuilder(Boolean value) {
        this.backStackBuilderOptoutFlag = value;
    }

    public final boolean isBackStackBuilderOptedOut(Context context) {
        return this.backStackBuilderOptoutFlag;
    }

    public void enableBaiduPush() {
        this.isBaiduEnabled = true;
        this.loadPushHandler();
    }

    public boolean isIsBaiduEnabled() {
        return this.isBaiduEnabled;
    }

    public void setTokenObserver(OnTokenReceivedListener tokenObserver) {
        this.tokenListener = tokenObserver;
    }

    public final void optOutMoEngageExtras(boolean value) {
        this.optOutOfMoEngageExtras = value;
    }

    public final boolean isMoEngageExtrasOptedOut() {
        return this.optOutOfMoEngageExtras;
    }

    public static interface OnTokenReceivedListener {
        public void onTokenReceived(String var1);
    }

    public static interface PushHandler {
        @WorkerThread
        public String registerForPushToken(Context var1);

        public void handlePushPayload(Context var1, Bundle var2);

        @Deprecated
        public void handlePushPayload(Context var1, Intent var2);

        @WorkerThread
        public void deleteToken(Context var1, String var2);

        public void offLoadToWorker(Context var1, String var2);

        public void logNotificationClicked(Context var1, Intent var2);

        public void setMessageListener(Object var1);

        public void setPushRegistrationFallback(Context var1);

        public Object getMessageListener();

        public void handlePushPayload(Context var1, Map<String, String> var2);

        @Nullable
        @WorkerThread
        public String getPushToken(Context var1);

        public void handlePushPayload(Context var1, String var2);
    }
}

