/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.WorkerThread;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.Logger;
import java.util.HashMap;
import org.json.JSONObject;

public class InAppController {
    private InAppHandler inAppHandler;
    private int mActivityOrientation = -1;
    private String mActivityName = null;
    private static InAppController _INSTANCE;

    private InAppController() {
        this.loadInAppHandler();
    }

    private void loadInAppHandler() {
        try {
            Class<?> handler = Class.forName("com.moengage.inapp.InAppHandlerImpl");
            this.inAppHandler = (InAppHandler)handler.newInstance();
            Logger.v("InAppController:loadInAppHandler InApp Module present");
        }
        catch (Exception e) {
            Logger.e("InAppController : loadInAppHandler : InApp Module not present " + e.getMessage());
        }
    }

    public InAppHandler getInAppHandler() {
        return this.inAppHandler;
    }

    public static InAppController getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new InAppController();
        }
        return _INSTANCE;
    }

    public String getActivityName() {
        return this.mActivityName;
    }

    public void setActivityName(String activityName) {
        this.mActivityName = activityName;
    }

    public int getActivityOrientation() {
        return this.mActivityOrientation;
    }

    public void setActivityOrientation(int activityOrientation) {
        this.mActivityOrientation = activityOrientation;
    }

    public static interface InAppHandler {
        public void showInAppIfPossible(Context var1);

        public void showInAppOnConfigurationChange(Context var1);

        public void syncOrShowInApps(Context var1);

        @WorkerThread
        public void tryShowAutoTriggerInApp(Context var1, JSONObject var2);

        public void parseAndSaveInApps(JSONObject var1, Context var2);

        public void registerAutoTriggerEvent(Context var1, Event var2);

        public void registerInAppManager(Activity var1);

        public void unregisterInAppManager(Activity var1);

        public void setInappsSynced(boolean var1);

        public void fetchLinkedInApp(Context var1, String var2);

        public void showLinkedInApp(Context var1, JSONObject var2, HashMap<String, String> var3);

        public void showTestInAppErrorDialog(String var1);
    }

    public static enum NETWORK_CALL_TYPE {
        AUTO_TRIGGER_EVENT,
        SYNC_IN_APPS,
        SINGLE_FETCH;

    }
}

