/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.moengage.core.APIManager;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEEventManager;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class SyncConfigAPITask
extends SDKTask {
    private Context mContext;
    private ConfigurationProvider provider;

    SyncConfigAPITask(Context context) {
        super(context);
        this.mContext = context;
        this.provider = ConfigurationProvider.getInstance(this.mContext);
    }

    @Override
    public TaskResult execute() {
        Logger.v("SyncConfigAPITask : executing Task");
        try {
            String response = APIManager.syncConfig(this.mContext, MoEUtils.getAPIRouteV3(this.mContext) + "/v3/getConfig", this.createPostBody());
            if (!TextUtils.isEmpty((CharSequence)response)) {
                JSONObject responseJSON = new JSONObject(response);
                if (responseJSON.has("le_s")) {
                    this.provider.setLogEntryEnable(this.getStateFromResponse(responseJSON, "le_s"));
                }
                if (responseJSON.has("le_tkn")) {
                    this.provider.setLogEntryKey(responseJSON.getString("le_tkn"));
                }
                if (responseJSON.has("m_s_t")) {
                    int delayTime = responseJSON.getInt("m_s_t");
                    this.provider.setMessageFetchDelayDuration(delayTime * 1000);
                }
                if (responseJSON.has("b_e")) {
                    JSONArray blackListEventsArray = responseJSON.getJSONArray("b_e");
                    String eventLists = MoEUtils.convertJSONArrayToString(blackListEventsArray);
                    this.provider.saveBlackListEventList(eventLists);
                    MoEEventManager.getInstance(this.mContext).getBlackListedEvents();
                }
                if (responseJSON.has("a_s")) {
                    this.provider.saveAppState(this.getStateFromResponse(responseJSON, "a_s"));
                }
                if (responseJSON.has("i_s")) {
                    this.provider.saveInAppState(this.getStateFromResponse(responseJSON, "i_s"));
                }
                if (responseJSON.has("g_s")) {
                    this.provider.saveGeoState(this.getStateFromResponse(responseJSON, "g_s"));
                }
                if (responseJSON.has("in_s")) {
                    this.provider.saveInboxState(this.getStateFromResponse(responseJSON, "in_s"));
                }
                if (responseJSON.has("e_b_c")) {
                    this.provider.saveEventBatchCount(responseJSON.getInt("e_b_c"));
                }
                if (responseJSON.has("d_s_r_i")) {
                    this.provider.setRetrySyncTime(responseJSON.getLong("d_s_r_i"));
                }
                if (responseJSON.has("f_e")) {
                    String flushEvents = MoEUtils.convertJSONArrayToString(responseJSON.getJSONArray("f_e"));
                    this.provider.saveFlushEventList(flushEvents);
                    MoEEventManager.getInstance(this.mContext).getFlushEvents();
                }
                if (responseJSON.has("p_f_s")) {
                    this.provider.savePeriodicFlushState(responseJSON.getBoolean("p_f_s"));
                }
                if (responseJSON.has("p_f_t")) {
                    this.provider.savePeriodicFlushTime(responseJSON.getLong("p_f_t"));
                }
                if (responseJSON.has("cid_ex")) {
                    this.provider.saveCampaignIdTTL(responseJSON.getLong("cid_ex"));
                }
            }
        }
        catch (Exception e) {
            Logger.f("SyncConfigAPITask : execute", e);
        }
        Logger.v("SyncConfigAPITask : execution completed");
        return null;
    }

    private String createPostBody() {
        try {
            JSONObject postBody = new JSONObject();
            postBody.put("a_s", (Object)this.getStateFromBoolean(this.provider.isAppEnabled()));
            postBody.put("i_s", (Object)this.getStateFromBoolean(this.provider.isInAppEnabled()));
            postBody.put("in_s", (Object)this.getStateFromBoolean(this.provider.isInboxEnabled()));
            postBody.put("g_s", (Object)this.getStateFromBoolean(this.provider.isGeoEnabled()));
            postBody.put("le_s", (Object)this.getStateFromBoolean(this.provider.isLogEntryEnabled()));
            postBody.put("event_list", this.provider.getEventBatchCount());
            postBody.put("b_e", (Object)MoEUtils.convertStringToJSONArray(this.provider.getBlackListEvents()));
            postBody.put("m_s_t", this.provider.getMessageFetchDelayDuration() / 1000L);
            postBody.put("d_s_r_i", this.provider.getPeriodicFlushTime());
            postBody.put("p_f_s", this.provider.isPeriodicFlushEnabled());
            postBody.put("f_e", (Object)MoEUtils.convertStringToJSONArray(this.provider.getFlushEvents()));
            postBody.put("cid_ex", this.provider.getCampaignIdTTL());
            return postBody.toString();
        }
        catch (Exception e) {
            Logger.f("SyncConfigAPITask: createPostBody: ", e);
            return null;
        }
    }

    @Override
    public String getTaskTag() {
        return "SYNC_CONFIG";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    private boolean getStateFromResponse(@NonNull JSONObject responseJSON, @NonNull String responseAttr) {
        try {
            String state;
            switch (state = responseJSON.getString(responseAttr)) {
                case "blocked": {
                    return false;
                }
                case "allowed": {
                    return true;
                }
            }
        }
        catch (JSONException e) {
            Logger.f("SyncConfigAPITask: getStateFromResponse ", e);
        }
        return true;
    }

    private String getStateFromBoolean(boolean status) {
        return status ? "allowed" : "blocked";
    }
}

