/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import com.delight.pushlibrary.R;
import com.moe.pushlibrary.models.GeoLocation;
import com.moengage.core.APIManager;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.HashMap;

public class IntegrationVerificationNetworkCallTask
extends SDKTask {
    private TASK_TYPE task_type;
    public static final String RESULT_EXTRA_MESSAGE = "message";
    public static final String RESULT_EXTRA_BUTTON_ID = "button_id";

    public IntegrationVerificationNetworkCallTask(Context context, TASK_TYPE task_type) {
        super(context);
        this.task_type = task_type;
    }

    @Override
    public TaskResult execute() {
        try {
            switch (this.task_type) {
                case REGISTER_DEVICE: {
                    this.registerDevice();
                    break;
                }
                case UNREGISTER_DEVICE: {
                    this.unregisterDevice();
                    break;
                }
                default: {
                    Logger.e("IntegrationVerificationNetworkCallTask: invalid case");
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.f("IntegrationVerificationNetworkCallTask: Exception ", e);
        }
        return this.mTaskResult;
    }

    private void unregisterDevice() {
        String API = MoEUtils.getAPIRoute(this.mContext) + "/integration/unregister_device";
        if (APIManager.registerUnregisterDeviceForIntegrationVerification(this.mContext, API, null)) {
            ConfigurationProvider.getInstance(this.mContext).setVerificationRegistration(false);
            this.createResult(true, "Device unregistered successfully. Click on the button to re-register.", R.id.retryButton);
        } else {
            this.createResult(false, "Device could not be unregistered. Click on the button to retry.", R.id.unregisterButton);
        }
    }

    private void registerDevice() {
        String API = MoEUtils.getAPIRoute(this.mContext) + "/integration/register_device";
        GeoLocation geoLocation = ConfigurationProvider.getInstance(this.mContext).getLastKnownUserLocation();
        if (geoLocation == null) {
            geoLocation = new GeoLocation(0.0, 0.0);
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("lat", String.valueOf(geoLocation.latitude));
        paramsMap.put("lng", String.valueOf(geoLocation.longitude));
        paramsMap.put("manufacturer", Build.MANUFACTURER);
        if (APIManager.registerUnregisterDeviceForIntegrationVerification(this.mContext, API, paramsMap)) {
            ConfigurationProvider.getInstance(this.mContext).setVerificationRegistrationTime(System.currentTimeMillis());
            ConfigurationProvider.getInstance(this.mContext).setVerificationRegistration(true);
            this.createResult(true, "Device registered successfully. Click on the button to unregister.", R.id.unregisterButton);
        } else {
            this.createResult(false, "Device could not be registered. Click on the button to retry.", R.id.retryButton);
        }
    }

    @Override
    public String getTaskTag() {
        return "INTEGRATION_VERIFICATION_NETWORK_TASK";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    private void createResult(boolean status, String message, int buttonId) {
        Bundle bundle = new Bundle();
        bundle.putString(RESULT_EXTRA_MESSAGE, message);
        bundle.putInt(RESULT_EXTRA_BUTTON_ID, buttonId);
        this.mTaskResult.setIsSuccess(status);
        this.mTaskResult.setPayload(bundle);
    }

    public static enum TASK_TYPE {
        REGISTER_DEVICE,
        UNREGISTER_DEVICE;

    }
}

