/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.text.TextUtils;
import com.moengage.core.APIManager;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.location.GeoManager;
import java.util.HashMap;

public class GeoTask
extends SDKTask {
    String API;
    HashMap<String, String> paramsMap;
    GeoManager.TASK_TYPE geoTask;

    public GeoTask(Context context, String API, HashMap<String, String> paramsMap, GeoManager.TASK_TYPE geoTask) {
        super(context);
        this.API = API;
        this.paramsMap = paramsMap;
        this.geoTask = geoTask;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("GeoTask : executing task " + (Object)((Object)this.geoTask));
            if (!ConfigurationProvider.getInstance(this.mContext).isAppEnabled() || !ConfigurationProvider.getInstance(this.mContext).isGeoEnabled()) {
                return null;
            }
            switch (this.geoTask) {
                case GEOFENCE_HIT: {
                    APIManager.geoFenceHit(this.mContext, this.API, this.paramsMap);
                    break;
                }
                case GET_GEOFENCE: {
                    GeoManager.LocationHandler locationHandler;
                    String response = APIManager.getGeoFences(this.mContext, this.API, this.paramsMap);
                    if (TextUtils.isEmpty((CharSequence)response) || (locationHandler = GeoManager.getInstance().getHandler(this.mContext)) == null) break;
                    locationHandler.setGeoFences(this.mContext, response);
                    break;
                }
                default: {
                    Logger.e("GeoTask : Unknown Task " + (Object)((Object)this.geoTask));
                }
            }
            Logger.v("GeoTask : completed execution " + (Object)((Object)this.geoTask));
        }
        catch (Exception e) {
            Logger.f("GeoTask: execute() ", e);
        }
        return null;
    }

    @Override
    public String getTaskTag() {
        return "GEO_TASK";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }
}

