/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.AdvertisingIdClient;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.List;

class ActivityStartTask
extends SDKTask {
    String mCurrentActivityName;
    boolean mNeedToCheckForGAIDChange;

    public ActivityStartTask(Context context, String currentActivityName, boolean needToCheckForGAIDChange) {
        super(context);
        this.mContext = context;
        this.mCurrentActivityName = currentActivityName;
        this.mNeedToCheckForGAIDChange = needToCheckForGAIDChange;
    }

    @Override
    public TaskResult execute() {
        Logger.v("ActivityStartTask : started execution");
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentActivityName)) {
            Logger.v("ActivityLifecycleStart : " + this.mCurrentActivityName + " started");
            if (MoEHelper.getActivityCounter() == 1 && this.mNeedToCheckForGAIDChange) {
                MoEUtils.trackActivityStates("EVENT_ACTION_ACTIVITY_START", this.mCurrentActivityName, this.mContext);
            } else if (!this.isActivityTracked()) {
                MoEUtils.trackActivityStates("EVENT_ACTION_ACTIVITY_START", this.mCurrentActivityName, this.mContext);
                ConfigurationProvider.getInstance(this.mContext).addScreenToSentList(this.mCurrentActivityName);
            }
        }
        if (this.mNeedToCheckForGAIDChange) {
            MoEDAO.getInstance(this.mContext).removeExpiredData();
            this.checkGoogleAdvertisementIDAndUpdate();
            String referrer = MoEHelperUtils.getInstallReferrer(this.mContext);
            if (!TextUtils.isEmpty((CharSequence)referrer)) {
                MoEUtils.setUserAttributeInternal(this.mContext, "INSTALL_REFERRER_MOE", referrer);
                MoEHelperUtils.removeInstallReferrer(this.mContext);
            }
        } else {
            Logger.v("ActivityStartTask : No Need to check GAID");
        }
        this.mTaskResult.setIsSuccess(true);
        this.mTaskResult.setPayload(this.mNeedToCheckForGAIDChange);
        Logger.v("ActivityStartTask : completed execution");
        return this.mTaskResult;
    }

    @Override
    public String getTaskTag() {
        return "START_ACTIVITY";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }

    private void checkGoogleAdvertisementIDAndUpdate() {
        this.mNeedToCheckForGAIDChange = false;
        ConfigurationProvider provider = ConfigurationProvider.getInstance(this.mContext);
        if (provider.isAdIdCollectionProhibitted()) {
            Logger.f("ActivityStartTask : Opted out of GAID Collection");
            return;
        }
        String storedGAID = provider.getStoredGAID();
        int storedISLAT = provider.getStoredISLAT();
        AdvertisingIdClient.AdInfo adInfo = MoEUtils.getAdvertisementInfo(this.mContext);
        if (null != adInfo) {
            if (!(TextUtils.isEmpty((CharSequence)adInfo.getId()) || !TextUtils.isEmpty((CharSequence)storedGAID) && adInfo.getId().equals(storedGAID))) {
                MoEUtils.setUserAttributeInternal(this.mContext, "MOE_GAID", adInfo.getId());
                provider.storeGAID(adInfo.getId());
            } else {
                this.mNeedToCheckForGAIDChange = true;
            }
            if (adInfo.isLimitAdTrackingEnabled() != storedISLAT) {
                MoEUtils.setUserAttributeInternal(this.mContext, "MOE_ISLAT", Integer.toString(adInfo.isLimitAdTrackingEnabled()));
                provider.storeISLAT(adInfo.isLimitAdTrackingEnabled());
            } else {
                this.mNeedToCheckForGAIDChange = true;
            }
        } else {
            this.mNeedToCheckForGAIDChange = true;
        }
    }

    boolean isActivityTracked() {
        try {
            List<String> trackedScreen = ConfigurationProvider.getInstance(this.mContext).getSentScreenList();
            return trackedScreen != null && trackedScreen.contains(this.mCurrentActivityName);
        }
        catch (Exception e) {
            Logger.f("ActivityStartTask: isActivityTracked : ", e);
            return false;
        }
    }
}

