/* ************************************************************************
 *
 * MOENGAGE CONFIDENTIAL
 * __________________
 *
 *  [2014] - [2015] MoEngage Inc.
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moengage.core;

/**
 * @author MoEngage (abhishek@moengage.com)
 * @version 1.0
 * @since 5.0
 */
public final class MoEConstants {

  private MoEConstants() {
    // Utility class cannot be instantiated
  }
  /**
   * The default expiry date associated with a messages. Its value is 19th
   * November 2020
   */
  static final long DEFAULT_EXPIRY_DATE_FOR_MESSAGES = 16057696211000L;
  // Associated with only v2 API RESPONSE
  /**
   * Attribute key for the status of the response received from a v2 API
   */
  static final String RESULT_ATTR_STATUS = "status";
  /**
   * Attribute value associated with {@link #RESULT_ATTR_STATUS} when it is a
   * successful response
   */
  static final String RESULT_ATTR_VALUE_SUCCESS = "success";
  /**
   * The value associated with the {@link #RESPONSE_ATTR_RESULT} which
   * indicates a successful API response. This is applicable for all version 1
   * APIs only
   */
  static final String RESULT_OK = "OK";
  /* ***************************** EVENT TRACKING STRINGS ************************************ */
  /**
   * Associated with Event Tracking. The Key for the JSON Object which holds
   * the value for the activity which is currently changing states
   * (start/stop). Associated to {@link #EVENT_ACTION_ACTIVITY_START} &
   * {@link #EVENT_ACTION_ACTIVITY_STOP}
   */
  static final String EVENT_ACTIVITY_NAME = "ACTIVITY_NAME";
  /**
   * Associated with Event Tracking. The key for the JSONObject which holds
   * the value associated with the Fragment name of the Fragment which is
   * currently changing states (start/stop)
   */
  static final String EVENT_FRAGMENT_NAME = "FRAGMENT_NAME";
	/* ***************************** PREFERNCE KEYS ************************************ */

  /**
   * The Intent extra which tells the system when the notification was
   * received from the server
   */
  static final String EXTRA_MSG_RECEIVED_TIME = "MOE_MSG_RECEIVED_TIME";

  public static final String ATTR_MOE_GAID = "MOE_GAID";

  static final String ATTR_IS_LAT = "MOE_ISLAT";
  /**
   *
   */
  static final String PREF_SHOW_CHAT_NOTIFICATION = "pref_show_chat_notification";
  /**
   *
   */
  static final String PREF_KEY_INSTALL_LOGGED = "pref_installed";
  /**
   * <b>Event Tracking</b>. Denotes that the activity is being started.
   */
  public static final String EVENT_ACTION_ACTIVITY_START = "EVENT_ACTION_ACTIVITY_START";
  /**
   * <b>Event Tracking</b>. Denotes that activity is being stopped
   */
  static final String EVENT_ACTION_ACTIVITY_STOP = "EVENT_ACTION_ACTIVITY_STOP";
  /**
   * <b>Event Tracking</b>. Denotes that a fragment is being started
   */
  static final String EVENT_ACTION_FRAGMENT_START = "EVENT_ACTION_FRAGMENT_START";
  /**
   * <b>Event Tracking</b>. Denotes that a fragment is being stopped.
   */
  static final String EVENT_ACTION_FRAGMENT_STOP = "EVENT_ACTION_FRAGMENT_STOP";
  /**
   * <b>Event Tracking</b>. Denotes that the event being logged is an user
   * attribute
   */
  static final String EVENT_ACTION_USER_ATTRIBUTE = "EVENT_ACTION_USER_ATTRIBUTE";
  /**
   * <b>DEVICE ATTR Tracking</b>. Denotes that the event being logged is an user
   * attribute
   */
  static final String EVENT_ACTION_DEVICE_ATTRIBUTE = "EVENT_ACTION_DEVICE_ATTRIBUTE";
  /**
   * <b>Event Tracking</b>. Denotes that a coupon code was clicked
   */
  static final String EVENT_ACTION_COUPON_CODE_COPY = "EVENT_ACTION_COUPON_CODE_COPY";
  /**
   * <b>API response ATTRIBUTE</b>. The key associated with the response
   * result value. Associated with V1 API only
   */
  static final String RESPONSE_ATTR_RESULT = "result";

  /**
   * The URL associated with the version 2 of MoEngage General API
   */
  static final String API_GENERAL_V2 = "https://apiv2.moengage.com";

  /**
   * This is the GCM registration endpoint associated with the v1 API. This is
   * to be used with {@link #API_GENERAL_V2}
   */
  static final String API_ENDPOINT_REGISTER_GCM_V2 = "/v2/device/add";
  /**
   * API end point which needs to be used for sending interaction report. This
   * is to be used with {@link #API_GENERAL_V2}
   */
  static final String API_ENDPOINT_STORE_REPORTS_V2 = "/v2/report/add";

  static final String PARAM_VALUE_INSTALL = "INSTALL";
  /**
   * <b>API response ATTRIBUTE</b> which holds the events info
   */
  public static final String RESPONSE_ATTR_EVENTS_INFO = "event_list";
  /**
   * <b>API Param</b>. stating the last updated time stamp
   */
  public static final String PARAM_LAST_UPDATED = "last_updated";

  // GENERIC params which are associated to all api requests for api v1
  public static final String GENERIC_PARAM_V1_KEY_GCM_ID = "gcmId";
  public static final String GENERIC_PARAM_V1_KEY_APP_ID = "appId";
  public static final String GENERIC_PARAM_V1_KEY_UID = "uid";
  public static final String GENERIC_PARAM_V1_KEY_OS = "os_value";
  public static final String GENERIC_PARAM_V1_VALUE_ANDROID = "ANDROID";
  public static final String GENERIC_PARAM_V1_KEY_APP_VERSION = "version";
  public static final String GENERIC_PARAM_V1_KEY_LIB_VERSION = "libVersion";
  public static final String GENERIC_PARAM_KEY_NW_TYPE = "networkType";

  // API V2 generic params
  public static final String GENERIC_PARAM_V2_KEY_OS = "os";
  public static final String GENERIC_PARAM_V2_KEY_GCM_ID = "push_id";
  public static final String GENERIC_PARAM_V2_KEY_APP_ID = "app_id";
  public static final String GENERIC_PARAM_V2_KEY_UID = "account_id";
  public static final String GENERIC_PARAM_V2_KEY_UUID = "unique_id";
  public static final String GENERIC_PARAM_V2_KEY_ANDROID_ID = "android_id";
  public static final String GENERIC_PARAM_V2_KEY_APP_VERSION = "app_ver";
  public static final String GENERIC_PARAM_V2_KEY_OS_VERSION = "os_ver";
  public static final String GENERIC_PARAM_V2_KEY_LIBVERSION = "sdk_ver";
  public static final String GENERIC_PARAM_V2_KEY_TIMESTAMP = "device_ts";
  public static final String GENERIC_PARAM_V2_KEY_TIMEZONE = "device_tz";
  public static final String GENERIC_PARAM_V2_KEY_TIMEZONE_OFFSET = "device_tz_offset";
  public static final String GENERIC_PARAM_V2_KEY_MODEL = "model";
  public static final String GENERIC_PARAM_V2_KEY_APP_VERSION_NAME = "app_version_name";
  public static final String GENERIC_PARAM_V2_KEY_GAID = "moe_gaid";
  public static final String GENERIC_PARAM_V2_KEY_PUSH_SERVER = "moe_push_ser";
  public static final String GENERIC_PARAM_V2_KEY_INTEGRATION_TYPE = "integration_type";

  //generic params values
  public static final String GENERIC_PARAM_V2_VALUE_OS = "ANDROID";
  public static final String GENERIC_PARAM_V2_VALUE_PUSH_SERVER_ANDROID = "android";
  public static final String GENERIC_PARAM_V2_VALUE_PUSH_SERVER_BAIDU = "baidu";
  /**
   * Use attribute associated with the user location
   */
  static final String USER_ATTRIBUTE_USER_LOCATION = "USER_ATTRIBUTE_USER_LOCATION";
  /**
   * Attribute stating the count of number of interaction points
   */
  static final String ATTR_INTEACTION_VIEWS_COUNT = "viewsCount";
  /**
   * Attribute which holds all the interaction points
   */
  static final String ATTR_INTEACTION_VIEWS_INFO = "viewsInfo";
  /**
   * The exponential counter for exponential back off
   */
  static final String EXPONENTIAL_CONSTANT_MOE = "PREF_EXPONENTIAL_BACK_OFF";

  static final String PREF_KEY_DEVICE_ADD_SCHEDULED = "PREF_DEVICE_ADD_SCHEDULED";

  /**
   * Delimiter for events in the { SMART_ACTIONS} list.
   */
  public static final String EVENT_SEPERATOR = ";";
  /**
   * Post request array property name which has the list of all local campaigns
   */
  public static final String REQ_ATTR_CAMPAIGN_LIST = "campaign_ids";
  /**
   * Post request for fetching campaign details for a campaign
   */
  static final String REQ_ATTR_CAMPAIGN_ID = "campaign_id";

  public static boolean dbUpdateRequired = true;

  static final String API_ENDPOINT_CONFIG_API = "/v3/getConfig";

  static final String RESPONSE_ATTR_LOG_ENTRY_TOKEN = "le_tkn";

  static final String RESPONSE_ATTR_LOG_ENTRY_STATUS = "le_s";

  static final String API_V2_INDIA = "https://apiv2mumbai.moengage.com";

  static final String RESPONSE_ATTR_MESSAGE_SYNC = "m_s_t";

  static final String API_ENDPOINT_INTEGRATION_VERIFICATION_DEVICE_REGISTRATION =
      "/integration/register_device";

  static final String API_ENDPOINT_INTEGRATION_VERIFICATION_REPORT_ADD =
      "/integration/send_report_add_call";

  static final String API_ENDPOINT_INTEGRATION_VERIFICATION_UNLINK_DEVICE =
      "/integration/unregister_device";

  static final String LOGOUT_EVENT =  "MOE_LOGOUT";

  static final String RESPONSE_ATTR_BLACKLIST_EVENT = "b_e";

  static final String RESPONSE_ATTR_APP_STATE = "a_s";

  static final String RESPONSE_ATTR_IN_APP_STATE = "i_s";

  static final String RESPONSE_ATTR_GEO_STATE = "g_s";

  static final String RESPONSE_ATTR_INBOX_STATE = "in_s";

  static final String RESPONSE_ATTR_EVENT_SYNC_COUNT = "e_b_c";

  static final String RESPONSE_ATTR_DATA_SYNC_RETRY_INTERVAL = "d_s_r_i";

  static final String API_GENERAL_V3 = "https://apiv3.moengage.com";

  static final String API_V3_INDIA = "https://apiv3india.moengage.com";

  static final String ATTR_SDK_IDENTIFIERS = "identifiers";

  static final String ATTR_MOE_USER_ID = "moe_user_id";

  static final String ATTR_SEGMENT_ID = "segment_id";

  static final String API_V2_EU = "https://apiv2eu.moengage.com";

  static final String API_V3_EU = "https://apiv3eu.moengage.com";

  static final String SERVICE_TYPE_LOGOUT = "LOGOUT";

  public static final String SERVICE_TYPE_APP_UPDATE = "APP_UPDATE";

  static final String SERVICE_LOGOUT_TYPE = "IS_FORCE_LOGOUT";

  static final String RESPONSE_ATTR_FLUSH_EVENTS = "f_e";

  static final String RESPONSE_ATTR_PERIODIC_FLUSH_TIME = "p_f_t";

  static final String RESPONSE_ATTR_PERIODIC_FLUSH_STATE = "p_f_s";

  static final String RESPONSE_ATTR_CAMPAIGN_ID_EXPIRY =  "cid_ex";

  static final String ATTR_BATCH_ID = "bid";

  static final String ATTR_SDK_META = "meta";
}
