/* ************************************************************************
 * 
 * MOENGAGE CONFIDENTIAL
 * __________________
 * 
 *  [2014] - [2015] MoEngage Inc. 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moe.pushlibrary.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.moengage.core.Logger;
import org.json.JSONObject;

/**
 * @author MoEngage (abhishek@moenegage.com)
 * @version 5.0
 * @since 5.0
 */
public class PromotionalMessage implements Parcelable {

	public long _id;
	public JSONObject msg_details;
	public boolean isClicked;
	public long ttl;
	public long gtime;

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.os.Parcelable#describeContents()
	 */
	@Override
	public int describeContents() {
		return 0;
	}

	public static final Parcelable.Creator<PromotionalMessage> CREATOR = new Parcelable.Creator<PromotionalMessage>() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see
		 * android.os.Parcelable.Creator#createFromParcel(android.os.Parcel)
		 */
		@Override
		public PromotionalMessage createFromParcel(Parcel source) {
			return new PromotionalMessage(source);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see android.os.Parcelable.Creator#newArray(int)
		 */
		@Override
		public PromotionalMessage[] newArray(int size) {
			return new PromotionalMessage[size];
		}

	};

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.os.Parcelable#writeToParcel(android.os.Parcel, int)
	 */
	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeLong(_id);
		if (null != msg_details) {
			dest.writeString(msg_details.toString());
		} else {
			dest.writeString("");
		}
		dest.writeInt((isClicked ? 1 : 0));
		dest.writeLong(ttl);
		dest.writeLong(gtime);
	}
	public PromotionalMessage() {	}

	public PromotionalMessage(Parcel source) {
		readFromParcel(source);
	}

	public void readFromParcel(Parcel in) {
		_id = in.readLong();
		String details = in.readString();
		if (!TextUtils.isEmpty(details)) {
			try {
				msg_details = new JSONObject(details);
			} catch (Exception e) {
				Logger.f("PromotionalMessage : readFromParcel", e);
			}
		}
		int clicked = in.readInt();
		isClicked = clicked == 0 ? false : true;
		ttl = in.readLong();
		gtime = in.readLong();
	}

}
