/* ************************************************************************
 * 
 * MOENGAGE CONFIDENTIAL
 * __________________
 * 
 *  [2014] - [2015] MoEngage Inc. 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moengage.core;

import android.text.TextUtils;
import com.moe.pushlibrary.exceptions.APIFailedException;
import com.moengage.core.MoERestClient.API_VERSION;
import org.json.JSONException;
import org.json.JSONObject;


/**
 * This class has utility methods for parsing JSON string
 *
 * @author MoEngage (abhishek@moengage.com)
 * @version 5.0
 * @since 5.0
 */
final class MoEParser {

  private MoEParser() {
    // Intentionally made private
  }
  /* *****************Generic methods*************** */

  /**
   * Check if HTTP call was successful
   *
   * @param responseCode The HTTP response code
   * @return true if http status code is 200
   */
  static boolean isHttpStatusOk(int responseCode) {
    return 200 == responseCode;
  }

  /**
   * Checks to see if the API returns a valid response
   * @throws JSONException
   */
  static boolean isValidAPIResponse(String response, API_VERSION appVersion)
      throws JSONException {
    if (TextUtils.isEmpty(response)) return false;
    JSONObject jsonResponse = new JSONObject(response);
    if (appVersion == API_VERSION.V1) {
      String result = jsonResponse.getString(MoEConstants.RESPONSE_ATTR_RESULT);
      if (MoEConstants.RESULT_OK.equals(result)) {
        return true;
      }
    } else {
      String result = jsonResponse.getString(MoEConstants.RESULT_ATTR_STATUS);
      if (MoEConstants.RESULT_ATTR_VALUE_SUCCESS.equals(result)) {
        return true;
      }
    }
    return false;
  }

	/* ***************** API specific methods*************** */

  /**
   * Parse the Device/ADD API response
   *
   * @param responseCode API response code
   * @return true if the API response is successful
   */
  static boolean parseRegistrationResponse(int responseCode) {
    return isHttpStatusOk(responseCode);
  }

  /**
   * Parse Report Add response
   * @throws APIFailedException
   */
  static boolean parseReportAddResponse(int responseCode) throws APIFailedException {
    if (!isHttpStatusOk(responseCode)) {
      throw new APIFailedException("Getting : " + responseCode);
    }
    return true;
  }
}
