package com.moengage.core;

import android.content.Context;
import android.text.TextUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.push.MoEMessagingManager;
import java.util.HashMap;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */

public class FetchMessagesFromServerTask extends SDKTask {
  private String API;
  private HashMap<String, String> paramsMap;
  private String requestBody;

  public FetchMessagesFromServerTask(Context context, String API, HashMap<String, String> paramsMap,
      String requestBody) {
    super(context);
    this.API = API;
    this.paramsMap = paramsMap;
    this.requestBody = requestBody;
  }

  @Override public TaskResult execute() {
    String response = null;
    try {
      if (!ConfigurationProvider.getInstance(mContext).isInboxEnabled()
          || !ConfigurationProvider.getInstance(mContext).isAppEnabled())
        return null;
       response = APIManager.fetchMessages(mContext, API, paramsMap, requestBody);
      if (!TextUtils.isEmpty(response)) {
        JSONObject responseJSON = new JSONObject(response);
        if (responseJSON != null) {
          ConfigurationProvider.getInstance(mContext)
              .setLastMessageFetchTime(System.currentTimeMillis());
          MoEMessagingManager.MessagingHandler messageHandler =
              MoEMessagingManager.getInstance().getMessagingHandler();
          if (messageHandler != null) {
            messageHandler.parsePayloadAndShowPush(mContext, responseJSON);
          }
        }
      }
    } catch (Exception e) {
      Logger.f("FetchMessagesFromServerTask : response : " + response + "execute ", e);
    }
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_FETCH_MESSAGES;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
