/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.models.UserAttribute;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.APIManager;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.DataSyncJob;
import com.moengage.core.Logger;
import com.moengage.core.MoEAlarmReceiver;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

class SendInteractionDataTask
extends SDKTask {
    SendInteractionDataTask(Context context) {
        super(context);
    }

    @Override
    public TaskResult execute() {
        try {
            if (!ConfigurationProvider.getInstance(this.mContext).isAppEnabled()) {
                return null;
            }
            Logger.v("SendInteractionDataTask : executing task");
            String referrer = MoEHelperUtils.getInstallReferrer(this.mContext);
            if (!TextUtils.isEmpty((CharSequence)referrer)) {
                JSONObject userJson = new JSONObject();
                try {
                    userJson.put("INSTALL_REFERRER_MOE", (Object)referrer);
                    MoEUtils.trackEventInternal("EVENT_ACTION_USER_ATTRIBUTE", userJson, this.mContext);
                }
                catch (Exception e) {
                    Logger.f("SendInteractionDataTask:setUserAttribute", e);
                }
                MoEHelperUtils.removeInstallReferrer(this.mContext);
            }
            this.mTaskResult.setIsSuccess(this.sendInteractionData());
            if (Build.VERSION.SDK_INT >= 21) {
                this.scheduleRetryDataSyncJob();
            } else {
                this.scheduleRetryDataSyncAlarm();
            }
            Logger.v("SendInteractionDataTask : completed task");
            return this.mTaskResult;
        }
        catch (Exception e) {
            Logger.f("SendInteractionData: execute() ", e);
            return null;
        }
    }

    @Override
    public String getTaskTag() {
        return "SEND_INTERACTION_DATA";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    private boolean sendInteractionData() {
        boolean result = false;
        ArrayList<Event> batchedData = null;
        while (true) {
            batchedData = MoEDAO.getInstance(this.mContext).getBatchedInteactionData(100);
            Logger.d("SendInteractionDataTask : sendInteractionData:Fetching interaction data in batches");
            if (null == batchedData || batchedData.isEmpty()) {
                Logger.d("SendInteractionDataTask : sendInteractionData: Found Nothing to send");
                return result;
            }
            String interactionData = this.convertEventsToJSON(batchedData);
            if (interactionData == null) {
                return true;
            }
            Logger.v("SendInteractionDataTask : sendInteractionData " + interactionData);
            try {
                String endpoint = "/v2/report/add";
                if (this.shouldSendDataToTestServer()) {
                    endpoint = "/integration/send_report_add_call";
                }
                result = APIManager.sendInteractionReport(this.mContext, interactionData, endpoint);
            }
            catch (Exception e) {
                Logger.f("SendInteractionDataTask : API failed", e);
                return false;
            }
            if (!result) {
                int retryCount = ConfigurationProvider.getInstance(this.mContext).getImmediateRetryCount();
                switch (retryCount) {
                    case 0: {
                        this.scheduleImmediateRetry(1);
                        ConfigurationProvider.getInstance(this.mContext).setImmediateRetryCount(++retryCount);
                        break;
                    }
                    case 1: {
                        this.scheduleImmediateRetry(3);
                        ConfigurationProvider.getInstance(this.mContext).setImmediateRetryCount(++retryCount);
                        break;
                    }
                    default: {
                        ConfigurationProvider.getInstance(this.mContext).setImmediateRetryCount(0);
                        break;
                    }
                }
                break;
            }
            MoEDAO.getInstance(this.mContext).deleteBatchedInteractionData(batchedData, this.mContext);
            Logger.d("SendInteractionDataTask : Deleting interaction data in batches");
            batchedData.clear();
        }
        return result;
    }

    private boolean shouldSendDataToTestServer() {
        boolean isDeviceRegisteredForVerification = ConfigurationProvider.getInstance(this.mContext).isDeviceRegisteredForVerification();
        long registrationTime = ConfigurationProvider.getInstance(this.mContext).getVerificationRegistrationTime();
        return isDeviceRegisteredForVerification && registrationTime + 3600000L > System.currentTimeMillis();
    }

    @Nullable
    private String convertEventsToJSON(ArrayList<Event> eventList) {
        if (null == eventList || eventList.isEmpty()) {
            return null;
        }
        JSONArray jsonInteractions = new JSONArray();
        for (Event event : eventList) {
            try {
                jsonInteractions.put((Object)new JSONObject(event.details));
            }
            catch (Exception e) {
                Logger.f("MoEUtils:convertEventsToJSON", e);
            }
        }
        if (jsonInteractions.length() == 0) {
            return null;
        }
        JSONObject jsonInteractionsObject = new JSONObject();
        try {
            jsonInteractionsObject.put("viewsCount", jsonInteractions.length());
            jsonInteractionsObject.put("viewsInfo", (Object)jsonInteractions);
            JSONObject sdkIdentifiers = this.getIdentifiersJSON();
            if (sdkIdentifiers != null) {
                jsonInteractionsObject.put("identifiers", (Object)sdkIdentifiers);
            }
        }
        catch (Exception e) {
            Logger.f("MoEUtils:convertEventsToJSON", e);
            return null;
        }
        return jsonInteractionsObject.toString();
    }

    @Nullable
    private JSONObject getIdentifiersJSON() {
        try {
            String segmentAnonymousId;
            JSONObject identifierJSON = new JSONObject();
            UserAttribute userAttributeUniqueId = MoEDAO.getInstance(this.mContext).getUserAttributesForKey("USER_ATTRIBUTE_UNIQUE_ID");
            if (userAttributeUniqueId != null) {
                identifierJSON.put("moe_user_id", (Object)userAttributeUniqueId.userAttributeValue);
            }
            if (!TextUtils.isEmpty((CharSequence)(segmentAnonymousId = ConfigurationProvider.getInstance(this.mContext).getSegmentAnonymousId()))) {
                identifierJSON.put("segment_id", (Object)segmentAnonymousId);
            }
            if (identifierJSON.length() != 0) {
                return identifierJSON;
            }
        }
        catch (Exception e) {
            Logger.f("SendInteractionDataTask: getIdentifiersJSON() ", e);
        }
        return null;
    }

    private void scheduleRetryDataSyncAlarm() {
        Logger.v("Scheduling data sync retry");
        Intent alarmIntent = new Intent(this.mContext, MoEAlarmReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)88888, (Intent)alarmIntent, (int)0x8000000);
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        alarmManager.setInexactRepeating(0, System.currentTimeMillis() + ConfigurationProvider.getInstance(this.mContext).getRetrySyncTime(), ConfigurationProvider.getInstance(this.mContext).getRetrySyncTime(), pendingIntent);
    }

    @TargetApi(value=21)
    private void scheduleRetryDataSyncJob() {
        Logger.v("Scheduling retry data sync job");
        ComponentName serviceComponent = new ComponentName(this.mContext, DataSyncJob.class);
        JobInfo.Builder builder = new JobInfo.Builder(77777, serviceComponent);
        builder.setRequiredNetworkType(1);
        builder.setOverrideDeadline(System.currentTimeMillis() + ConfigurationProvider.getInstance(this.mContext).getRetrySyncTime() * 2L);
        builder.setMinimumLatency(ConfigurationProvider.getInstance(this.mContext).getRetrySyncTime());
        JobScheduler jobScheduler = (JobScheduler)this.mContext.getSystemService("jobscheduler");
        jobScheduler.schedule(builder.build());
    }

    @TargetApi(value=21)
    private void scheduleImmediateRetrySyncJob(int minutes) {
        Logger.v("Scheduling immediate retry data sync job");
        ComponentName serviceComponent = new ComponentName(this.mContext, DataSyncJob.class);
        JobInfo.Builder builder = new JobInfo.Builder(666666, serviceComponent);
        builder.setRequiredNetworkType(1);
        builder.setOverrideDeadline(System.currentTimeMillis() + (long)(minutes * 2 * 60 * 1000));
        builder.setMinimumLatency((long)(minutes * 60 * 1000));
        JobScheduler jobScheduler = (JobScheduler)this.mContext.getSystemService("jobscheduler");
        jobScheduler.schedule(builder.build());
    }

    private void scheduleImmediateRetryAlarm(int minutes) {
        Intent alarmIntent = new Intent(this.mContext, MoEAlarmReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)55555, (Intent)alarmIntent, (int)0x8000000);
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        alarmManager.set(0, System.currentTimeMillis() + (long)(minutes * 60 * 1000), pendingIntent);
    }

    private void scheduleImmediateRetry(int minutes) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.scheduleImmediateRetrySyncJob(minutes);
        } else {
            this.scheduleImmediateRetryAlarm(minutes);
        }
    }
}

