/*
 * Decompiled with CFR 0.152.
 */
package com.moe.pushlibrary.providers;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.moe.pushlibrary.providers.MoEDataContract;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;

public class MoEProvider
extends ContentProvider {
    private static final int MESSAGES = 1;
    private static final int MESSAGE_ID = 2;
    private static final int DATAPOINTS = 3;
    private static final int DATAPOINT_ID = 4;
    private static final int INAPPS = 5;
    private static final int INAPP_ID = 6;
    private static final int USER_ATTRIBUTES = 9;
    private static final int USER_ATTRIBUTES_ID = 10;
    private static final int CAMPAIGN_IDS = 11;
    private static final int CAMPAIGN_ID = 12;
    private static UriMatcher sUriMatcher;
    private static HashMap<String, String> sMessageProjectionMap;
    private static HashMap<String, String> sEventProjectionMap;
    private static HashMap<String, String> sInAppProjectionMap;
    private static HashMap<String, String> sUserAttributeProjectionMap;
    private static HashMap<String, String> sCampaignListProjectionMap;
    private DatabaseHelper mOpenHelper = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDatapoints(SQLiteDatabase db) {
        if (null == db) {
            return;
        }
        try {
            Logger.d("Started porting DATA - FOR DATAPOINTS");
            db.beginTransaction();
            String QUERY_GET_EVENTS = "SELECT _id, action, attrs, gtime, ltime FROM EVENTS";
            Cursor cursor = db.rawQuery(QUERY_GET_EVENTS, null);
            if (null != cursor && cursor.moveToFirst()) {
                do {
                    ContentValues values = new ContentValues();
                    JSONObject details = MoEHelperUtils.getDatapointJSON(cursor.getString(1), new JSONObject(cursor.getString(2)), Long.toString(cursor.getLong(3)), cursor.getString(4));
                    if (null == details) continue;
                    values.put("details", details.toString());
                    values.put("gtime", Long.valueOf(cursor.getLong(3)));
                    long row = db.insert("DATAPOINTS", null, values);
                    Logger.v("MoEProvider:onUpgrade: Porting event data: " + row);
                } while (cursor.moveToNext());
                cursor.close();
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            Logger.f("MoEProvider: populateDatapoints", e);
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void portDataFromv2(SQLiteDatabase db) {
        try {
            db.beginTransaction();
            String QUERY_GET_MSGS = "SELECT * FROM moemsgs";
            Cursor cursor = db.rawQuery(QUERY_GET_MSGS, null);
            if (null != cursor && cursor.moveToFirst()) {
                do {
                    ContentValues values = new ContentValues();
                    values.put("msg", cursor.getString(1));
                    values.put("msgclicked", Integer.valueOf(cursor.getInt(2)));
                    values.put("msgttl", Long.valueOf(Long.parseLong(cursor.getString(3))));
                    values.put("gtime", Long.valueOf(Long.parseLong(cursor.getString(4))));
                    long row = db.insert("MESSAGES", null, values);
                    Logger.v("MoEProvider:onUpgrade: Porting message data: " + row);
                } while (cursor.moveToNext());
                cursor.close();
                cursor = null;
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            Logger.f("MoEProvider: portDatafromv2", e);
        }
        finally {
            if (null != db) {
                db.endTransaction();
            }
        }
    }

    public boolean onCreate() {
        this.mOpenHelper = new DatabaseHelper(this.getContext());
        this.initializeUriMatcher();
        Logger.d("MoEProvider: Provider created");
        return true;
    }

    private void initializeUriMatcher() {
        sUriMatcher = new UriMatcher(-1);
        Context context = this.getContext();
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "messages", 1);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "messages/#", 2);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "datapoints", 3);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "datapoints/#", 4);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "inapps", 5);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "inapps/#", 6);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "userattributes/", 9);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "userattributes/#", 10);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "campaignlist/", 11);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "campaignlist/#", 12);
    }

    public String getType(@NonNull Uri uri) {
        switch (sUriMatcher.match(uri)) {
            case 1: {
                return "vnd.android.cursor.dir/vnd.moe.message";
            }
            case 2: {
                return "vnd.android.cursor.item/vnd.moe.message";
            }
            case 3: {
                return "vnd.android.cursor.dir/vnd.moe.datapoints";
            }
            case 4: {
                return "vnd.android.cursor.item/vnd.moe.datapoint";
            }
            case 5: {
                return "vnd.android.cursor.dir/vnd.moe.inapps";
            }
            case 6: {
                return "vnd.android.cursor.item/vnd.moe.inapp";
            }
            case 9: {
                return "vnd.android.cursor.dir/vnd.moe.userattributes";
            }
            case 10: {
                return "vnd.android.cursor.item/vnd.moe.userattributes";
            }
            case 11: {
                return "vnd.android.cursor.dir/vnd.moe.campaignlist";
            }
            case 12: {
                return "vnd.android.cursor.item/vnd.moe.campaignlist";
            }
        }
        Logger.f("No Matching URI found");
        return null;
    }

    public Cursor query(@NonNull Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        this.updateIfRequired(db);
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        String orderBy = sortOrder;
        String limit = uri.getQueryParameter("LIMIT");
        switch (sUriMatcher.match(uri)) {
            case 2: {
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
            }
            case 1: {
                qb.setProjectionMap(sMessageProjectionMap);
                qb.setTables("MESSAGES");
                if (!TextUtils.isEmpty((CharSequence)sortOrder)) break;
                orderBy = "gtime DESC";
                break;
            }
            case 4: {
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
            }
            case 3: {
                qb.setProjectionMap(sEventProjectionMap);
                qb.setTables("DATAPOINTS");
                break;
            }
            case 6: {
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
            }
            case 5: {
                qb.setProjectionMap(sInAppProjectionMap);
                qb.setTables("INAPPMSG");
                if (!TextUtils.isEmpty((CharSequence)sortOrder)) break;
                orderBy = "priority DESC, gtime DESC";
                break;
            }
            case 9: {
                qb.setProjectionMap(sUserAttributeProjectionMap);
                qb.setTables("USERATTRIBUTES");
                break;
            }
            case 11: {
                qb.setProjectionMap(sCampaignListProjectionMap);
                qb.setTables("CAMPAIGNLIST");
                break;
            }
            default: {
                Logger.f("Unknown URI " + uri);
            }
        }
        Cursor c = null;
        try {
            c = qb.query(db, projection, selection, selectionArgs, null, null, orderBy, limit);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }

    public Uri insert(Uri uri, ContentValues values) {
        if (null == values) {
            return null;
        }
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        this.updateIfRequired(db);
        long rowId = 0L;
        Uri newUri = null;
        switch (sUriMatcher.match(uri)) {
            case 1: {
                rowId = db.insert("MESSAGES", null, values);
                if (rowId <= 0L) break;
                newUri = ContentUris.withAppendedId((Uri)MoEDataContract.MessageEntity.getContentUri(this.getContext()), (long)rowId);
                break;
            }
            case 3: {
                rowId = db.insert("DATAPOINTS", null, values);
                if (rowId <= 0L) break;
                newUri = ContentUris.withAppendedId((Uri)MoEDataContract.DatapointEntity.getContentUri(this.getContext()), (long)rowId);
                break;
            }
            case 5: {
                rowId = db.insert("INAPPMSG", null, values);
                if (rowId <= 0L) break;
                newUri = ContentUris.withAppendedId((Uri)MoEDataContract.InAppMessageEntity.getContentUri(this.getContext()), (long)rowId);
                break;
            }
            case 9: {
                rowId = db.insert("USERATTRIBUTES", null, values);
                if (rowId <= 0L) break;
                newUri = ContentUris.withAppendedId((Uri)MoEDataContract.UserAttributeEntity.getContentUri(this.getContext()), (long)rowId);
                break;
            }
            case 11: {
                rowId = db.insert("CAMPAIGNLIST", null, values);
                if (rowId <= 0L) break;
                newUri = ContentUris.withAppendedId((Uri)MoEDataContract.UserAttributeEntity.getContentUri(this.getContext()), (long)rowId);
                break;
            }
            default: {
                Logger.f("Unknown URI " + uri);
            }
        }
        if (null != newUri) {
            Logger.v("MoEProvider: Added new record : " + newUri.toString());
            this.getContext().getContentResolver().notifyChange(uri, null);
        } else {
            Logger.f("MoEProvider: Failed to add new record");
        }
        return newUri;
    }

    public void updateIfRequired(SQLiteDatabase db) {
        if (MoEConstants.dbUpdateRequired) {
            this.mOpenHelper.addMSGTagIfRequiredInbox(db);
            this.mOpenHelper.addUserAttributesTableIfRequired(db);
            this.mOpenHelper.addCampaignListTableIfRequired(db);
            MoEConstants.dbUpdateRequired = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ContentProviderResult[] applyBatch(@NonNull ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        ContentProviderResult[] result = new ContentProviderResult[operations.size()];
        int i = 0;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        this.updateIfRequired(db);
        db.beginTransaction();
        try {
            for (ContentProviderOperation operation : operations) {
                result[i++] = operation.apply((ContentProvider)this, result, i);
            }
            db.setTransactionSuccessful();
        }
        catch (OperationApplicationException e) {
            Logger.f("MoEProvider : batch failed: ", e);
        }
        catch (Exception e) {
            Logger.f("MoEProvider : batch failed: ", e);
        }
        finally {
            db.endTransaction();
        }
        return result;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        if (null == uri) {
            return 0;
        }
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        this.updateIfRequired(db);
        int count = 0;
        switch (sUriMatcher.match(uri)) {
            case 1: {
                count = db.delete("MESSAGES", selection, selectionArgs);
                break;
            }
            case 2: {
                String noteId = (String)uri.getPathSegments().get(1);
                count = db.delete("MESSAGES", "_id=" + noteId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                break;
            }
            case 3: {
                count = db.delete("DATAPOINTS", selection, selectionArgs);
                break;
            }
            case 4: {
                String eventId = (String)uri.getPathSegments().get(1);
                count = db.delete("DATAPOINTS", "_id = " + eventId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                break;
            }
            case 5: {
                count = db.delete("INAPPMSG", selection, selectionArgs);
                break;
            }
            case 6: {
                String inappId = (String)uri.getPathSegments().get(1);
                count = db.delete("INAPPMSG", "_id=" + inappId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                break;
            }
            case 9: {
                count = db.delete("USERATTRIBUTES", selection, selectionArgs);
                break;
            }
            case 10: {
                String attributeId = (String)uri.getPathSegments().get(1);
                count = db.delete("USERATTRIBUTES", "_id=" + attributeId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                break;
            }
            case 11: {
                count = db.delete("CAMPAIGNLIST", selection, selectionArgs);
                break;
            }
            case 12: {
                String campaignId = (String)uri.getPathSegments().get(1);
                count = db.delete("CAMPAIGNLIST", "_id=" + campaignId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                break;
            }
            default: {
                Logger.f("Unknown URI " + uri);
            }
        }
        this.getContext().getContentResolver().notifyChange(uri, null);
        Logger.v("MoEProvider: Deleted " + count + " record(s) for URI: " + uri.toString());
        return count;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        this.updateIfRequired(db);
        int count = 0;
        switch (sUriMatcher.match(uri)) {
            case 1: {
                count = db.update("MESSAGES", values, selection, selectionArgs);
                break;
            }
            case 2: {
                String msgId = (String)uri.getPathSegments().get(1);
                count = db.update("MESSAGES", values, "_id=" + msgId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                break;
            }
            case 3: {
                count = db.update("DATAPOINTS", values, selection, selectionArgs);
                break;
            }
            case 4: {
                String eventId = (String)uri.getPathSegments().get(1);
                count = db.update("DATAPOINTS", values, "_id=" + eventId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                break;
            }
            case 5: {
                count = db.update("INAPPMSG", values, selection, selectionArgs);
                break;
            }
            case 6: {
                String inAppId = (String)uri.getPathSegments().get(1);
                count = db.update("INAPPMSG", values, "_id=" + inAppId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                break;
            }
            case 9: {
                count = db.update("USERATTRIBUTES", values, selection, selectionArgs);
                break;
            }
            case 10: {
                String attributeId = (String)uri.getPathSegments().get(1);
                count = db.update("USERATTRIBUTES", values, "_id=" + attributeId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                break;
            }
            case 11: {
                count = db.update("CAMPAIGNLIST", values, selection, selectionArgs);
                break;
            }
            case 12: {
                String campaignId = (String)uri.getPathSegments().get(1);
                count = db.update("CAMPAIGNLIST", values, "_id=" + campaignId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                break;
            }
            default: {
                Logger.f("Unknown URI " + uri);
            }
        }
        this.getContext().getContentResolver().notifyChange(uri, null);
        Logger.v("MoEProvider: Updated " + count + " record(s)");
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFieldExist(String tableName, String fieldName, SQLiteDatabase db) {
        boolean isExist = false;
        ArrayList<String> columnNameList = new ArrayList<String>();
        try (Cursor res = db.rawQuery("PRAGMA table_info(" + tableName + ")", null);){
            if (res != null && res.moveToFirst()) {
                do {
                    String columnName = res.getString(res.getColumnIndex("name"));
                    columnNameList.add(columnName);
                } while (res.moveToNext());
            }
        }
        if (columnNameList.contains(fieldName)) {
            isExist = true;
        }
        return isExist;
    }

    public boolean isTableExists(SQLiteDatabase db, String tableName) {
        int count = 0;
        try {
            if (tableName == null || db == null || !db.isOpen()) {
                return false;
            }
            Cursor cursor = db.rawQuery("SELECT COUNT(*) FROM sqlite_master WHERE type = ? AND name = ?", new String[]{"table", tableName});
            if (!cursor.moveToFirst()) {
                return false;
            }
            count = cursor.getInt(0);
            cursor.close();
        }
        catch (Exception e) {
            Logger.f("MoEProvider: isTableExists Exception " + e.toString());
        }
        return count > 0;
    }

    static {
        sMessageProjectionMap = new HashMap();
        sMessageProjectionMap.put("_id", "_id");
        sMessageProjectionMap.put("gtime", "gtime");
        sMessageProjectionMap.put("msg", "msg");
        sMessageProjectionMap.put("msgclicked", "msgclicked");
        sMessageProjectionMap.put("msgttl", "msgttl");
        sMessageProjectionMap.put("msg_tag", "msg_tag");
        sEventProjectionMap = new HashMap();
        sEventProjectionMap.put("_id", "_id");
        sEventProjectionMap.put("gtime", "gtime");
        sEventProjectionMap.put("details", "details");
        sInAppProjectionMap = new HashMap();
        sInAppProjectionMap.put("_id", "_id");
        sInAppProjectionMap.put("gtime", "gtime");
        sInAppProjectionMap.put("campaign_id", "campaign_id");
        sInAppProjectionMap.put("align_type", "align_type");
        sInAppProjectionMap.put("inapp_type", "inapp_type");
        sInAppProjectionMap.put("ttl", "ttl");
        sInAppProjectionMap.put("min_delay", "min_delay");
        sInAppProjectionMap.put("max_times", "max_times");
        sInAppProjectionMap.put("shown_count", "shown_count");
        sInAppProjectionMap.put("persistent", "persistent");
        sInAppProjectionMap.put("priority", "priority");
        sInAppProjectionMap.put("context", "context");
        sInAppProjectionMap.put("last_shown", "last_shown");
        sInAppProjectionMap.put("is_clicked", "is_clicked");
        sInAppProjectionMap.put("has_errors", "has_errors");
        sInAppProjectionMap.put("auto_dismiss", "auto_dismiss");
        sInAppProjectionMap.put("cancelable", "cancelable");
        sInAppProjectionMap.put("content", "content");
        sInAppProjectionMap.put("show_only_in", "show_only_in");
        sInAppProjectionMap.put("status", "status");
        sInAppProjectionMap.put("dim_style", "dim_style");
        sUserAttributeProjectionMap = new HashMap();
        sUserAttributeProjectionMap.put("_id", "_id");
        sUserAttributeProjectionMap.put("gtime", "gtime");
        sUserAttributeProjectionMap.put("attribute_name", "attribute_name");
        sUserAttributeProjectionMap.put("attribute_value", "attribute_value");
        sCampaignListProjectionMap = new HashMap();
        sCampaignListProjectionMap.put("_id", "_id");
        sCampaignListProjectionMap.put("campaign_id", "campaign_id");
        sCampaignListProjectionMap.put("ttl", "ttl");
    }

    class DatabaseHelper
    extends SQLiteOpenHelper {
        private static final String DATABASE_NAME = "MOEInteractions";
        static final int DATABASE_VERSION = 11;
        static final String TABLE_NAME_UINBOX = "UINBOX";
        static final String TABLE_NAME_MSGS = "MESSAGES";
        static final String TABLE_NAME_DATAPOINTS = "DATAPOINTS";
        static final String TABLE_NAME_INAPPS = "INAPPMSG";
        static final String TABLE_NAME_OLD_INAPPS = "INAPPS";
        static final String TABLE_NAME_USER_ATTRIBUTES = "USERATTRIBUTES";
        static final String TABLE_NAME_CAMPAIGN_LIST = "CAMPAIGNLIST";

        public DatabaseHelper(Context context) {
            super(context, DATABASE_NAME, null, 11);
        }

        public void onCreate(SQLiteDatabase db) {
            String DDL_DATAPOINTS = "CREATE TABLE IF NOT EXISTS DATAPOINTS ( _id INTEGER PRIMARY KEY, gtime INTEGER, details TEXT ); ";
            String DDL_MSGS = "CREATE TABLE IF NOT EXISTS MESSAGES ( _id INTEGER PRIMARY KEY, msg TEXT, msgclicked INTEGER DEFAULT 0, msgttl INTEGER, gtime INTEGER, msg_tag TEXT); ";
            this.createInAppTable(db);
            this.createUserAttributeTable(db);
            this.createCampaignListTable(db);
            db.execSQL(DDL_MSGS);
            db.execSQL(DDL_DATAPOINTS);
            Logger.i("MoEProvider: Database created");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean tableExists(SQLiteDatabase db, String tableName) {
            Cursor cursor = null;
            try {
                cursor = db.rawQuery("select DISTINCT tbl_name from sqlite_master where tbl_name = '" + tableName + "'", null);
                boolean bl = cursor != null && cursor.getCount() > 0;
                return bl;
            }
            finally {
                if (null != cursor) {
                    cursor.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            Logger.v("MoEProvider: Provider upgrading DB ");
            block36: for (int upgradeTo = oldVersion + 1; upgradeTo <= newVersion; ++upgradeTo) {
                switch (upgradeTo) {
                    case 3: {
                        db.beginTransaction();
                        try {
                            this.createDataPointsTable(db);
                            this.createMessagesTable(db);
                            this.createInAppTable(db);
                            MoEProvider.this.portDataFromv2(db);
                            db.execSQL("DROP TABLE IF EXISTS moeints");
                            db.execSQL("DROP TABLE IF EXISTS moemsgs");
                            db.execSQL("DROP TABLE IF EXISTS moeinappmsgs");
                            db.setTransactionSuccessful();
                            continue block36;
                        }
                        catch (Exception e) {
                            Logger.f("MoEProvider: failed to port data. FROM V2.", e);
                            continue block36;
                        }
                        finally {
                            db.endTransaction();
                        }
                    }
                    case 4: {
                        continue block36;
                    }
                    case 5: {
                        db.beginTransaction();
                        try {
                            db.execSQL("DROP TABLE IF EXISTS CHATS");
                            db.setTransactionSuccessful();
                            continue block36;
                        }
                        catch (Exception e) {
                            Logger.f("MoEProvider: failed to port data.. FOR UBOX", e);
                            continue block36;
                        }
                        finally {
                            db.endTransaction();
                        }
                    }
                    case 6: {
                        db.beginTransaction();
                        try {
                            if (MoEProvider.this.isTableExists(db, TABLE_NAME_OLD_INAPPS)) {
                                String ALTER_INAPP = " ALTER TABLE INAPPS ADD COLUMN TYPE INTEGER";
                                db.execSQL(ALTER_INAPP);
                            }
                            db.setTransactionSuccessful();
                            continue block36;
                        }
                        catch (Exception e) {
                            Logger.f("MoEProvider: failed to add column INAPPS", e);
                            continue block36;
                        }
                        finally {
                            db.endTransaction();
                        }
                    }
                    case 7: {
                        db.beginTransaction();
                        try {
                            this.createDataPointsTable(db);
                            MoEProvider.this.populateDatapoints(db);
                            db.execSQL("DROP TABLE IF EXISTS EVENTS");
                            db.setTransactionSuccessful();
                            continue block36;
                        }
                        catch (Exception e) {
                            Logger.f("MoEProvider: failed to populate Datapoints ", e);
                            continue block36;
                        }
                        finally {
                            db.endTransaction();
                        }
                    }
                    case 8: {
                        String ALTER_INBOX;
                        db.beginTransaction();
                        try {
                            if (!MoEProvider.this.isFieldExist(TABLE_NAME_MSGS, "msg_tag", db)) {
                                ALTER_INBOX = " ALTER TABLE MESSAGES ADD COLUMN msg_tag TEXT";
                                db.execSQL(ALTER_INBOX);
                            }
                            db.setTransactionSuccessful();
                            continue block36;
                        }
                        catch (Exception e) {
                            Logger.f("MoEProvider: failed to add columns to UINBOX / MESSAGES", e);
                            continue block36;
                        }
                        finally {
                            db.endTransaction();
                        }
                    }
                    case 9: {
                        db.execSQL("DROP TABLE IF EXISTS INAPPS");
                        this.createInAppTable(db);
                        if (MoEProvider.this.isFieldExist(TABLE_NAME_MSGS, "msg_tag", db)) continue block36;
                        String ALTER_INBOX = " ALTER TABLE MESSAGES ADD COLUMN msg_tag TEXT";
                        db.execSQL(ALTER_INBOX);
                        continue block36;
                    }
                    case 10: {
                        this.createUserAttributeTable(db);
                        continue block36;
                    }
                    case 11: {
                        this.createCampaignListTable(db);
                        continue block36;
                    }
                    default: {
                        Logger.v("Failed to upgrade from DB version" + oldVersion + "to DB version" + newVersion);
                    }
                }
            }
            ConfigurationProvider.getInstance(MoEProvider.this.getContext()).setNewDBVersion(11);
            Logger.v("MoEProvider: Database Upgraded");
        }

        private void createDataPointsTable(SQLiteDatabase db) {
            String DDL_DATAPOINTS = "CREATE TABLE IF NOT EXISTS DATAPOINTS ( _id INTEGER PRIMARY KEY, gtime INTEGER, details TEXT ); ";
            db.execSQL(DDL_DATAPOINTS);
        }

        private void createMessagesTable(SQLiteDatabase db) {
            String DDL_MSGS = "CREATE TABLE IF NOT EXISTS MESSAGES ( _id INTEGER PRIMARY KEY, msg TEXT, msgclicked INTEGER DEFAULT 0, msgttl INTEGER, gtime INTEGER )";
            db.execSQL(DDL_MSGS);
        }

        private void createInAppTable(SQLiteDatabase db) {
            String DDL_INAPP = "CREATE TABLE IF NOT EXISTS INAPPMSG ( _id INTEGER PRIMARY KEY, gtime INTEGER, campaign_id TEXT, align_type TEXT, inapp_type TEXT, ttl INTEGER DEFAULT 0, min_delay INTEGER DEFAULT 0, max_times INTEGER DEFAULT 0, shown_count INTEGER DEFAULT 0, persistent INTEGER DEFAULT 0, priority INTEGER DEFAULT 0, context TEXT, last_shown INTEGER DEFAULT 0, is_clicked INTEGER DEFAULT 0, has_errors INTEGER DEFAULT 0, auto_dismiss INTEGER DEFAULT 0, cancelable INTEGER DEFAULT 0, content TEXT, show_only_in TEXT, status TEXT, dim_style TEXT );";
            db.execSQL(DDL_INAPP);
        }

        public void addMSGTagIfRequiredInbox(SQLiteDatabase db) {
            if (!MoEProvider.this.isFieldExist(TABLE_NAME_MSGS, "msg_tag", db)) {
                Logger.v("MoEProvider : addMSGTagIfRequiredInbox : updating inbox table");
                String ALTER_UBOX = " ALTER TABLE MESSAGES ADD COLUMN msg_tag TEXT";
                db.execSQL(ALTER_UBOX);
            }
        }

        public void addUserAttributesTableIfRequired(SQLiteDatabase db) {
            if (!this.tableExists(db, TABLE_NAME_USER_ATTRIBUTES)) {
                Logger.v("MoEProvider : DatabaseHelper : addUserAttributesTableIfRequired creating missing  user attribute table");
                this.createUserAttributeTable(db);
            } else {
                Logger.v("MoEProvider : DatabaseHelper : addUserAttributesTableIfRequired user attribute table already present");
            }
        }

        public void addCampaignListTableIfRequired(SQLiteDatabase db) {
            if (!this.tableExists(db, TABLE_NAME_CAMPAIGN_LIST)) {
                Logger.v("MoEProvider : DatabaseHelper : addCampaignListTableIfRequired creating missing  campaign list table");
                this.createUserAttributeTable(db);
            } else {
                Logger.v("MoEProvider : DatabaseHelper : addCampaignListTableIfRequired campaign list table already present");
            }
        }

        private void createUserAttributeTable(SQLiteDatabase db) {
            String DDL_USER_ATTRIBUTES = "CREATE TABLE IF NOT EXISTS USERATTRIBUTES ( _id INTEGER PRIMARY KEY, attribute_name TEXT, attribute_value TEXT ); ";
            db.execSQL(DDL_USER_ATTRIBUTES);
        }

        private void createCampaignListTable(SQLiteDatabase db) {
            String DDL_CAMPAIGN_LIST = "CREATE TABLE IF NOT EXISTS CAMPAIGNLIST ( _id INTEGER PRIMARY KEY, campaign_id TEXT, ttl INTEGER );";
            db.execSQL(DDL_CAMPAIGN_LIST);
        }
    }
}

