/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mipush.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.text.TextUtils;
import com.xiaomi.clientreport.data.Config;
import com.xiaomi.clientreport.manager.ClientReportClient;
import com.xiaomi.mipush.sdk.Constants;
import com.xiaomi.mipush.sdk.Logger;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.MiTinyDataClient;
import com.xiaomi.mipush.sdk.PushConfiguration;
import com.xiaomi.mipush.sdk.PushMessageHandler;
import com.xiaomi.mipush.sdk.PushMessageHelper;
import com.xiaomi.mipush.sdk.a;
import com.xiaomi.mipush.sdk.ab;
import com.xiaomi.mipush.sdk.ag;
import com.xiaomi.mipush.sdk.ah;
import com.xiaomi.mipush.sdk.ai;
import com.xiaomi.mipush.sdk.aj;
import com.xiaomi.mipush.sdk.ak;
import com.xiaomi.mipush.sdk.ao;
import com.xiaomi.mipush.sdk.ap;
import com.xiaomi.mipush.sdk.az;
import com.xiaomi.mipush.sdk.b;
import com.xiaomi.mipush.sdk.be;
import com.xiaomi.mipush.sdk.bf;
import com.xiaomi.mipush.sdk.bh;
import com.xiaomi.mipush.sdk.d;
import com.xiaomi.mipush.sdk.f;
import com.xiaomi.mipush.sdk.g;
import com.xiaomi.mipush.sdk.i;
import com.xiaomi.mipush.sdk.q;
import com.xiaomi.mipush.sdk.r;
import com.xiaomi.mipush.sdk.u;
import com.xiaomi.mipush.sdk.w;
import com.xiaomi.mipush.sdk.z;
import com.xiaomi.push.ay;
import com.xiaomi.push.dt;
import com.xiaomi.push.fi;
import com.xiaomi.push.fj;
import com.xiaomi.push.fk;
import com.xiaomi.push.fq;
import com.xiaomi.push.hw;
import com.xiaomi.push.ic;
import com.xiaomi.push.in;
import com.xiaomi.push.iq;
import com.xiaomi.push.is;
import com.xiaomi.push.iz;
import com.xiaomi.push.je;
import com.xiaomi.push.jf;
import com.xiaomi.push.jj;
import com.xiaomi.push.jl;
import com.xiaomi.push.jn;
import com.xiaomi.push.n;
import com.xiaomi.push.o;
import com.xiaomi.push.p;
import com.xiaomi.push.service.ar;
import com.xiaomi.push.service.j;
import com.xiaomi.push.service.receivers.NetworkStatusReceiver;
import com.xiaomi.push.t;
import com.xiaomi.push.v;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MiPushClient {
    public static final String COMMAND_REGISTER = "register";
    public static final String COMMAND_UNREGISTER = "unregister";
    public static final String COMMAND_SET_ALIAS = "set-alias";
    public static final String COMMAND_UNSET_ALIAS = "unset-alias";
    public static final String COMMAND_SET_ACCOUNT = "set-account";
    public static final String COMMAND_UNSET_ACCOUNT = "unset-account";
    public static final String COMMAND_SUBSCRIBE_TOPIC = "subscribe-topic";
    public static final String COMMAND_UNSUBSCRIBE_TOPIC = "unsubscibe-topic";
    public static final String COMMAND_SET_ACCEPT_TIME = "accept-time";
    public static final String PREF_EXTRA = "mipush_extra";
    private static boolean isCrashHandlerSuggested = false;
    private static Context sContext;
    private static long sCurMsgId;
    private static bh mSyncMIIDHelper;

    public static boolean shouldUseMIUIPush(Context context) {
        return az.a(context).a();
    }

    public static void registerPush(Context context, String string, String string2) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration());
    }

    public static void registerPush(Context context, String string, String string2, PushConfiguration pushConfiguration) {
        MiPushClient.checkNotNull(context, "context");
        MiPushClient.checkNotNull(string, "appID");
        MiPushClient.checkNotNull(string2, "appToken");
        sContext = context.getApplicationContext();
        if (sContext == null) {
            sContext = context;
        }
        context = sContext;
        if (!NetworkStatusReceiver.a()) {
            MiPushClient.registerNetworkReceiver(sContext);
        }
        g.a(sContext).a(pushConfiguration);
        MiPushClient.enableGeo(sContext, pushConfiguration.getGeoEnable());
        b.a();
        com.xiaomi.push.ai.a(context).a(new ag(string, string2));
    }

    private static boolean checkPermission(Context context) {
        String string;
        String[] stringArray;
        boolean bl2 = false;
        if (context != null) {
            if (n.a() || "com.xiaomi.xmsf".equals(context.getPackageName())) {
                bl2 = true;
            } else if (!TextUtils.isEmpty((CharSequence)com.xiaomi.push.j.b(context))) {
                bl2 = true;
            } else {
                int n2 = context.getApplicationInfo().targetSdkVersion;
                if (n2 >= 23 && Build.VERSION.SDK_INT >= 23) {
                    if (o.a(context, "android.permission.READ_PHONE_STATE") || o.a(context, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                        bl2 = true;
                    }
                } else {
                    stringArray = com.xiaomi.push.j.f(context);
                    string = com.xiaomi.push.j.a();
                    if (!TextUtils.isEmpty((CharSequence)stringArray) || !TextUtils.isEmpty((CharSequence)string)) {
                        bl2 = true;
                    }
                }
            }
        }
        if (!bl2) {
            com.xiaomi.channel.commonutils.logger.b.d("Because of lack of necessary information, mi push can't be initialized");
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!o.a(context, "android.permission.READ_PHONE_STATE")) {
                arrayList.add("android.permission.READ_PHONE_STATE");
            }
            if (!o.a(context, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                arrayList.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
            if (!arrayList.isEmpty()) {
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                string = new Intent();
                string.setAction("com.xiaomi.mipush.ERROR");
                string.setPackage(context.getPackageName());
                string.putExtra("message_type", 5);
                string.putExtra("error_type", "error_lack_of_permission");
                string.putExtra("error_message", stringArray);
                context.sendBroadcast((Intent)string);
            }
        }
        return bl2;
    }

    private static void registerNetworkReceiver(Context context) {
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            intentFilter.addCategory("android.intent.category.DEFAULT");
            Context context2 = context.getApplicationContext();
            context2.registerReceiver((BroadcastReceiver)new NetworkStatusReceiver(null), intentFilter);
        }
        catch (Throwable throwable) {
            com.xiaomi.channel.commonutils.logger.b.a(throwable);
        }
    }

    @Deprecated
    private static void initialize(Context context, String string, String string2, MiPushClientCallback miPushClientCallback) {
        try {
            Object object;
            boolean bl2;
            if (miPushClientCallback != null) {
                PushMessageHandler.a(miPushClientCallback);
            }
            if (v.a(sContext)) {
                ab.a(sContext);
            }
            if (!d.a(sContext).a(string, string2) && !MiPushClient.checkPermission(sContext)) {
                return;
            }
            boolean bl3 = bl2 = d.a(sContext).a() != Constants.a();
            if (!bl2 && !MiPushClient.shouldSendRegRequest(sContext)) {
                az.a(sContext).a();
                com.xiaomi.channel.commonutils.logger.b.a("Could not send  register message within 5s repeatly .");
                return;
            }
            if (!bl2 && d.a(sContext).a(string, string2) && !d.a(sContext).e()) {
                Object object2;
                if (1 == PushMessageHelper.getPushMode(sContext)) {
                    MiPushClient.checkNotNull(miPushClientCallback, "callback");
                    miPushClientCallback.onInitializeResult(0L, null, d.a(sContext).c());
                } else {
                    object = new ArrayList();
                    object.add(d.a(sContext).c());
                    object2 = PushMessageHelper.generateCommandMessage(fq.a.a, (List<String>)object, 0L, null, null);
                    PushMessageHelper.sendCommandMessageBroadcast(sContext, (MiPushCommandMessage)object2);
                }
                az.a(sContext).a();
                if (d.a(sContext).a()) {
                    object = new je();
                    ((je)object).b(d.a(sContext).a());
                    ((je)object).c("client_info_update");
                    ((je)object).a(ar.a());
                    ((je)object).a = new HashMap();
                    ((je)object).a.put("app_version", com.xiaomi.push.g.a(sContext, sContext.getPackageName()));
                    ((je)object).a.put("app_version_code", Integer.toString(com.xiaomi.push.g.a(sContext, sContext.getPackageName())));
                    ((je)object).a.put("push_sdk_vn", "3_6_12");
                    ((je)object).a.put("push_sdk_vc", Integer.toString(30612));
                    object2 = d.a(sContext).e();
                    if (!TextUtils.isEmpty((CharSequence)object2)) {
                        ((je)object).a.put("deviceid", object2);
                    }
                    az.a(sContext).a(object, hw.i, false, null);
                    b.a(sContext);
                }
                if (!p.a(sContext, "update_devId", false)) {
                    MiPushClient.updateIMEI();
                    p.a(sContext, "update_devId", true);
                }
                if (!TextUtils.isEmpty((CharSequence)(object = com.xiaomi.push.j.d(sContext)))) {
                    object2 = new iz();
                    ((iz)object2).a(ar.a());
                    ((iz)object2).b(string);
                    ((iz)object2).c(fq.j.a);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(com.xiaomi.push.j.c(sContext));
                    arrayList.add((String)object);
                    arrayList.add(Build.MODEL != null ? Build.MODEL : "");
                    arrayList.add(Build.BOARD != null ? Build.BOARD : "");
                    ((iz)object2).a(arrayList);
                    az.a(sContext).a(object2, hw.j, false, null);
                }
                if (MiPushClient.shouldUseMIUIPush(sContext) && MiPushClient.shouldPullNotification(sContext)) {
                    object2 = new je();
                    ((je)object2).b(d.a(sContext).a());
                    ((je)object2).c(in.j.a);
                    ((je)object2).a(ar.a());
                    ((je)object2).a(false);
                    az.a(sContext).a(object2, hw.i, false, null, false);
                    MiPushClient.addPullNotificationTime(sContext);
                }
            } else {
                object = ay.a(6);
                d.a(sContext).a();
                d.a(sContext).a(Constants.a());
                d.a(sContext).a(string, string2, (String)object);
                MiTinyDataClient.a.a().b("com.xiaomi.xmpushsdk.tinydataPending.appId");
                MiPushClient.clearExtras(sContext);
                jf jf2 = new jf();
                jf2.a(ar.a());
                jf2.b(string);
                jf2.e(string2);
                jf2.d(sContext.getPackageName());
                jf2.f((String)object);
                jf2.c(com.xiaomi.push.g.a(sContext, sContext.getPackageName()));
                jf2.b(com.xiaomi.push.g.a(sContext, sContext.getPackageName()));
                jf2.g("3_6_12");
                jf2.a(30612);
                jf2.h(com.xiaomi.push.j.e(sContext));
                jf2.a(is.c);
                if (!n.d()) {
                    String string3 = com.xiaomi.push.j.g(sContext);
                    String string4 = com.xiaomi.push.j.i(sContext);
                    if (!TextUtils.isEmpty((CharSequence)string3)) {
                        if (n.b()) {
                            if (!TextUtils.isEmpty((CharSequence)string4)) {
                                string3 = string3 + "," + string4;
                            }
                            jf2.i(string3);
                        }
                        jf2.k(ay.a(string3) + "," + com.xiaomi.push.j.j(sContext));
                    }
                }
                jf2.j(com.xiaomi.push.j.a());
                int n2 = com.xiaomi.push.j.a();
                if (n2 >= 0) {
                    jf2.c(n2);
                }
                az.a(sContext).a(jf2, bl2);
                b.a(sContext);
                sContext.getSharedPreferences(PREF_EXTRA, 4).getBoolean("mipush_registed", true);
            }
            MiPushClient.addRegRequestTime(sContext);
            MiPushClient.scheduleOcVersionCheckJob();
            MiPushClient.scheduleGeoFenceLocUploadJobs();
            MiPushClient.scheduleDataCollectionJobs(sContext);
            MiPushClient.initEventPerfLogic(sContext);
            bf.a(sContext);
            MiPushClient.forceHandleCrash();
            if (!sContext.getPackageName().equals("com.xiaomi.xmsf")) {
                Logger.setLogger(sContext, Logger.getUserLogger());
                com.xiaomi.channel.commonutils.logger.b.a(2);
            }
            try {
                if (mSyncMIIDHelper == null) {
                    mSyncMIIDHelper = new bh(sContext);
                }
                mSyncMIIDHelper.a(sContext);
            }
            catch (Exception exception) {
                com.xiaomi.channel.commonutils.logger.b.d(exception.toString());
            }
            if ("syncing".equals(ap.a(sContext).a(be.a))) {
                MiPushClient.disablePush(sContext);
            }
            if ("syncing".equals(ap.a(sContext).a(be.b))) {
                MiPushClient.enablePush(sContext);
            }
            if ("syncing".equals(ap.a(sContext).a(be.c))) {
                MiPushClient.syncAssemblePushToken(sContext);
            }
            if ("syncing".equals(ap.a(sContext).a(be.d))) {
                MiPushClient.syncAssembleFCMPushToken(sContext);
            }
            if ("syncing".equals(ap.a(context).a(be.e))) {
                MiPushClient.syncAssembleCOSPushToken(sContext);
            }
        }
        catch (Throwable throwable) {
            com.xiaomi.channel.commonutils.logger.b.a(throwable);
        }
    }

    private static void scheduleOcVersionCheckJob() {
        int n2 = com.xiaomi.push.service.ao.a(sContext).a(ic.A.a(), 86400);
        com.xiaomi.push.ai.a(sContext).a(new ao(sContext), n2, 5);
    }

    private static void scheduleGeoFenceLocUploadJobs() {
        if (!j.e(sContext)) {
            return;
        }
        if (TextUtils.equals((CharSequence)"com.xiaomi.xmsf", (CharSequence)sContext.getPackageName())) {
            return;
        }
        if (!com.xiaomi.push.service.ao.a(sContext).a(ic.ac.a(), true)) {
            return;
        }
        if (v.b()) {
            return;
        }
        u.a(sContext, true);
        int n2 = com.xiaomi.push.service.ao.a(sContext).a(ic.O.a(), 900);
        n2 = Math.max(60, n2);
        com.xiaomi.push.ai.a(sContext).a(new u(sContext, n2), n2, n2);
    }

    private static void scheduleDataCollectionJobs(Context context) {
        int n2 = ic.z.a();
        if (com.xiaomi.push.service.ao.a(sContext).a(n2, MiPushClient.getDefaultSwitch())) {
            dt.a().a(new q(context));
            com.xiaomi.push.ai.a(sContext).a(new ah(), 10);
        }
    }

    private static boolean getDefaultSwitch() {
        return n.b();
    }

    private static void updateIMEI() {
        new Thread(new ai()).start();
    }

    public static void awakeApps(Context context, String[] stringArray) {
        com.xiaomi.push.ai.a(context).a(new aj(stringArray, context));
    }

    private static void awakePushServiceByPackageInfo(Context context, PackageInfo packageInfo) {
        ServiceInfo[] serviceInfoArray = packageInfo.services;
        if (serviceInfoArray != null) {
            for (ServiceInfo serviceInfo : serviceInfoArray) {
                if (!serviceInfo.exported || !serviceInfo.enabled || !"com.xiaomi.mipush.sdk.PushMessageHandler".equals(serviceInfo.name) || context.getPackageName().equals(serviceInfo.packageName)) continue;
                try {
                    Thread.sleep((long)(Math.random() * 2.0 + 1.0) * 1000L);
                    Intent intent = new Intent();
                    intent.setClassName(serviceInfo.packageName, serviceInfo.name);
                    intent.setAction("com.xiaomi.mipush.sdk.WAKEUP");
                    intent.putExtra("waker_pkgname", context.getPackageName());
                    PushMessageHandler.a(context, intent);
                }
                catch (Throwable throwable) {}
                break;
            }
        }
    }

    public static List<String> getAllAlias(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("alias_")) continue;
            arrayList.add(string.substring("alias_".length()));
        }
        return arrayList;
    }

    public static List<String> getAllTopic(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("topic_") || string.contains("**ALL**")) continue;
            arrayList.add(string.substring("topic_".length()));
        }
        return arrayList;
    }

    public static List<String> getAllUserAccount(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("account_")) continue;
            arrayList.add(string.substring("account_".length()));
        }
        return arrayList;
    }

    protected static void clearExtras(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        editor.commit();
    }

    static void reInitialize(Context context, is is2) {
        if (!d.a(context).c()) {
            return;
        }
        String string = ay.a(6);
        String string2 = d.a(context).a();
        String string3 = d.a(context).b();
        d.a(context).a();
        d.a(context).a(Constants.a());
        d.a(context).a(string2, string3, string);
        jf jf2 = new jf();
        jf2.a(ar.a());
        jf2.b(string2);
        jf2.e(string3);
        jf2.f(string);
        jf2.d(context.getPackageName());
        jf2.c(com.xiaomi.push.g.a(context, context.getPackageName()));
        jf2.a(is2);
        az.a(context).a(jf2, false);
    }

    @Deprecated
    public static void reportMessageClicked(Context context, String string) {
        MiPushClient.reportMessageClicked(context, string, null, null);
    }

    public static void reportMessageClicked(Context context, MiPushMessage miPushMessage) {
        iq iq2 = new iq();
        iq2.a(miPushMessage.getMessageId());
        iq2.b(miPushMessage.getTopic());
        iq2.d(miPushMessage.getDescription());
        iq2.c(miPushMessage.getTitle());
        iq2.c(miPushMessage.getNotifyId());
        iq2.a(miPushMessage.getNotifyType());
        iq2.b(miPushMessage.getPassThrough());
        iq2.a(miPushMessage.getExtra());
        MiPushClient.reportMessageClicked(context, miPushMessage.getMessageId(), iq2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    static void reportMessageClicked(Context context, String string, iq iq2, String string2) {
        je je2 = new je();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            if (!d.a(context).b()) {
                com.xiaomi.channel.commonutils.logger.b.d("do not report clicked message");
                return;
            }
            je2.b(d.a(context).a());
        } else {
            je2.b(string2);
        }
        je2.c("bar:click");
        je2.a(string);
        je2.a(false);
        az.a(context).a(je2, hw.i, false, iq2);
    }

    static void reportIgnoreRegMessageClicked(Context context, String string, iq iq2, String string2, String string3) {
        je je2 = new je();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            com.xiaomi.channel.commonutils.logger.b.d("do not report clicked message");
            return;
        }
        je2.b(string3);
        je2.c("bar:click");
        je2.a(string);
        je2.a(false);
        az.a(context).a(je2, hw.i, false, true, iq2, true, string2, string3);
    }

    public static void setLocalNotificationType(Context context, int n2) {
        int n3 = n2 & 0xFFFFFFFF;
        az.a(context).b(n3);
    }

    public static void clearLocalNotificationType(Context context) {
        az.a(context).e();
    }

    public static void unregisterPush(Context context) {
        i.c(context);
        if (!d.a(context).b()) {
            return;
        }
        jl jl2 = new jl();
        jl2.a(ar.a());
        jl2.b(d.a(context).a());
        jl2.c(d.a(context).c());
        jl2.e(d.a(context).b());
        jl2.d(context.getPackageName());
        az.a(context).a(jl2);
        PushMessageHandler.a();
        d.a(context).b();
        MiPushClient.clearLocalNotificationType(context);
        MiPushClient.clearNotification(context);
        if (mSyncMIIDHelper != null) {
            com.xiaomi.push.service.o.a(context).b(mSyncMIIDHelper);
        }
        MiPushClient.clearExtras(context);
    }

    public static void disablePush(Context context) {
        az.a(context).a(true);
    }

    public static void enablePush(Context context) {
        az.a(context).a(false);
    }

    public static void syncAssemblePushToken(Context context) {
        az.a(context).a(null, be.c, f.a);
    }

    public static void syncAssembleFCMPushToken(Context context) {
        az.a(context).a(null, be.d, f.b);
    }

    public static void syncAssembleCOSPushToken(Context context) {
        az.a(context).a(null, be.e, f.c);
    }

    public static void setAlias(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            MiPushClient.setCommand(context, fq.c.a, string, string2);
        }
    }

    public static void unsetAlias(Context context, String string, String string2) {
        MiPushClient.setCommand(context, fq.d.a, string, string2);
    }

    public static void setUserAccount(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            MiPushClient.setCommand(context, fq.e.a, string, string2);
        }
    }

    public static void unsetUserAccount(Context context, String string, String string2) {
        MiPushClient.setCommand(context, fq.f.a, string, string2);
    }

    public static void subscribe(Context context, String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)d.a(context).a()) || TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (Math.abs(System.currentTimeMillis() - MiPushClient.topicSubscribedTime(context, string)) > 86400000L) {
            jj jj2 = new jj();
            jj2.a(ar.a());
            jj2.b(d.a(context).a());
            jj2.c(string);
            jj2.d(context.getPackageName());
            jj2.e(string2);
            az.a(context).a(jj2, hw.c, null);
        } else if (1 == PushMessageHelper.getPushMode(context)) {
            PushMessageHandler.a(context, string2, 0L, null, string);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(fq.g.a, arrayList, 0L, null, null);
            PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
        }
    }

    public static void unsubscribe(Context context, String string, String string2) {
        if (!d.a(context).b()) {
            return;
        }
        if (MiPushClient.topicSubscribedTime(context, string) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel subscribe for " + string + " is unsubscribed");
            return;
        }
        jn jn2 = new jn();
        jn2.a(ar.a());
        jn2.b(d.a(context).a());
        jn2.c(string);
        jn2.d(context.getPackageName());
        jn2.e(string2);
        az.a(context).a(jn2, hw.d, null);
    }

    public static void pausePush(Context context, String string) {
        MiPushClient.setAcceptTime(context, 0, 0, 0, 0, string);
    }

    public static void resumePush(Context context, String string) {
        MiPushClient.setAcceptTime(context, 0, 0, 23, 59, string);
    }

    public static void clearNotification(Context context, int n2) {
        az.a(context).a(n2);
    }

    public static void clearNotification(Context context, String string, String string2) {
        az.a(context).a(string, string2);
    }

    public static void clearNotification(Context context) {
        az.a(context).a(-1);
    }

    public static void reportAppRunInBackground(Context context, boolean bl2) {
        if (!d.a(context).b()) {
            return;
        }
        in in2 = bl2 ? in.Z : in.Y;
        je je2 = new je();
        je2.b(d.a(context).a());
        je2.c(in2.a);
        je2.d(context.getPackageName());
        je2.a(ar.a());
        je2.a(false);
        az.a(context).a(je2, hw.i, false, null, false);
    }

    public static String getRegId(Context context) {
        if (d.a(context).c()) {
            return d.a(context).c();
        }
        return null;
    }

    public static String getAppRegion(Context context) {
        if (d.a(context).c()) {
            return d.a(context).f();
        }
        return null;
    }

    protected static void setCommand(Context context, String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
        }
        if (fq.c.a.equalsIgnoreCase(string) && Math.abs(System.currentTimeMillis() - MiPushClient.aliasSetTime(context, string2)) < 3600000L) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string3, string, 0L, null, arrayList);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(fq.c.a, arrayList, 0L, null, string3);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else if (fq.d.a.equalsIgnoreCase(string) && MiPushClient.aliasSetTime(context, string2) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel alias for " + ay.a(arrayList.toString(), 3) + " is unseted");
        } else if (fq.e.a.equalsIgnoreCase(string) && Math.abs(System.currentTimeMillis() - MiPushClient.accountSetTime(context, string2)) < 3600000L) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string3, string, 0L, null, arrayList);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(fq.e.a, arrayList, 0L, null, string3);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else if (fq.f.a.equalsIgnoreCase(string) && MiPushClient.accountSetTime(context, string2) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel account for " + ay.a(arrayList.toString(), 3) + " is unseted");
        } else {
            MiPushClient.setCommand(context, string, arrayList, string3);
        }
    }

    protected static void setCommand(Context context, String string, ArrayList<String> arrayList, String string2) {
        if (TextUtils.isEmpty((CharSequence)d.a(context).a())) {
            return;
        }
        iz iz2 = new iz();
        iz2.a(ar.a());
        iz2.b(d.a(context).a());
        iz2.c(string);
        for (String string3 : arrayList) {
            iz2.a(string3);
        }
        iz2.e(string2);
        iz2.d(context.getPackageName());
        az.a(context).a(iz2, hw.j, null);
    }

    public static void setAcceptTime(Context context, int n2, int n3, int n4, int n5, String string) {
        if (n2 < 0 || n2 >= 24 || n4 < 0 || n4 >= 24 || n3 < 0 || n3 >= 60 || n5 < 0 || n5 >= 60) {
            throw new IllegalArgumentException("the input parameter is not valid.");
        }
        TimeZone timeZone = TimeZone.getTimeZone("GMT+08");
        TimeZone timeZone2 = TimeZone.getDefault();
        long l2 = 1440L;
        long l3 = (timeZone.getRawOffset() - timeZone2.getRawOffset()) / 1000 / 60;
        long l4 = ((long)(n2 * 60 + n3) + l3 + l2) % l2;
        long l5 = ((long)(n4 * 60 + n5) + l3 + l2) % l2;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.format("%1$02d:%2$02d", l4 / 60L, l4 % 60L));
        arrayList.add(String.format("%1$02d:%2$02d", l5 / 60L, l5 % 60L));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(String.format("%1$02d:%2$02d", n2, n3));
        arrayList2.add(String.format("%1$02d:%2$02d", n4, n5));
        if (MiPushClient.acceptTimeSet(context, (String)arrayList.get(0), (String)arrayList.get(1))) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string, fq.i.a, 0L, null, arrayList2);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(fq.i.a, arrayList2, 0L, null, null);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else {
            MiPushClient.setCommand(context, fq.i.a, arrayList, string);
        }
    }

    protected static boolean getOpenHmsPush() {
        return g.a(sContext).b(f.a);
    }

    protected static boolean getOpenFCMPush() {
        return g.a(sContext).b(f.b);
    }

    protected static boolean getOpenOPPOPush() {
        return g.a(sContext).b(f.c);
    }

    private static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("param " + string + " is not nullable");
        }
    }

    static synchronized void addAlias(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("alias_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeAlias(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("alias_" + string).commit();
    }

    static synchronized void removeAllAliases(Context context) {
        List<String> list = MiPushClient.getAllAlias(context);
        for (String string : list) {
            MiPushClient.removeAlias(context, string);
        }
    }

    static synchronized void addAccount(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("account_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeAccount(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("account_" + string).commit();
    }

    static synchronized void removeAllAccounts(Context context) {
        List<String> list = MiPushClient.getAllUserAccount(context);
        for (String string : list) {
            MiPushClient.removeAccount(context, string);
        }
    }

    static synchronized void addTopic(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("topic_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeTopic(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("topic_" + string).commit();
    }

    static synchronized void removeAllTopics(Context context) {
        List<String> list = MiPushClient.getAllTopic(context);
        for (String string : list) {
            MiPushClient.removeTopic(context, string);
        }
    }

    static synchronized void addAcceptTime(Context context, String string, String string2) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("accept_time", string + "," + string2);
        t.a(editor);
    }

    static synchronized void removeAcceptTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove("accept_time");
        t.a(editor);
    }

    public static long topicSubscribedTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("topic_" + string, -1L);
    }

    public static long accountSetTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("account_" + string, -1L);
    }

    public static long aliasSetTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("alias_" + string, -1L);
    }

    private static boolean acceptTimeSet(Context context, String string, String string2) {
        String string3 = MiPushClient.getAcceptTime(context);
        return TextUtils.equals((CharSequence)string3, (CharSequence)(string + "," + string2));
    }

    protected static String getAcceptTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getString("accept_time", "00:00-23:59");
    }

    private static void addPullNotificationTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_pull_notification", System.currentTimeMillis());
        t.a(editor);
    }

    private static boolean shouldPullNotification(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return Math.abs(System.currentTimeMillis() - sharedPreferences.getLong("last_pull_notification", -1L)) > 300000L;
    }

    private static void addRegRequestTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_reg_request", System.currentTimeMillis());
        t.a(editor);
    }

    private static boolean shouldSendRegRequest(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return Math.abs(System.currentTimeMillis() - sharedPreferences.getLong("last_reg_request", -1L)) > 5000L;
    }

    static synchronized void setGeoEnableTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("geo_" + string, System.currentTimeMillis());
        t.a(editor);
    }

    private static long getGeoEnableTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("geo_" + string, -1L);
    }

    private static void enableGeo(Context context, boolean bl2) {
        if (Math.abs(System.currentTimeMillis() - MiPushClient.getGeoEnableTime(context, String.valueOf(bl2))) > 60000L) {
            j.a(context, bl2);
            w.a(context, bl2);
            MiPushClient.setGeoEnableTime(context, String.valueOf(bl2));
        }
    }

    private static void initEventPerfLogic(Context context) {
        fk.a(new ak());
        Config config = fk.a(context);
        ClientReportClient.init(context, config, new fi(context), new fj(context));
        a.a(context);
        r.a(context, config);
    }

    public static void registerCrashHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        Thread.setDefaultUncaughtExceptionHandler(new z(sContext, uncaughtExceptionHandler));
        isCrashHandlerSuggested = true;
    }

    private static void forceHandleCrash() {
        boolean bl2 = com.xiaomi.push.service.ao.a(sContext).a(ic.av.a(), false);
        if (!isCrashHandlerSuggested && bl2) {
            Thread.setDefaultUncaughtExceptionHandler(new z(sContext));
        }
    }

    static /* synthetic */ Context access$000() {
        return sContext;
    }

    static /* synthetic */ void access$100(Context context, String string, String string2, MiPushClientCallback miPushClientCallback) {
        MiPushClient.initialize(context, string, string2, miPushClientCallback);
    }

    static /* synthetic */ void access$200(Context context, PackageInfo packageInfo) {
        MiPushClient.awakePushServiceByPackageInfo(context, packageInfo);
    }

    static {
        sCurMsgId = System.currentTimeMillis();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static abstract class MiPushClientCallback {
        private String category;

        protected String getCategory() {
            return this.category;
        }

        protected void setCategory(String string) {
            this.category = string;
        }

        public void onReceiveMessage(String string, String string2, String string3, boolean bl2) {
        }

        public void onReceiveMessage(MiPushMessage miPushMessage) {
        }

        public void onInitializeResult(long l2, String string, String string2) {
        }

        public void onSubscribeResult(long l2, String string, String string2) {
        }

        public void onUnsubscribeResult(long l2, String string, String string2) {
        }

        public void onCommandResult(String string, long l2, String string2, List<String> list) {
        }
    }
}

