/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.mi;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.ITask;
import com.moengage.mi.MiPushController;
import com.moengage.mi.WriteMessageToInbox;
import com.moengage.push.PushManager;
import com.moengage.pushbase.activities.PushTracker;
import com.moengage.pushbase.push.MoEngageNotificationUtils;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushMessageReceiver;
import java.util.List;
import org.json.JSONObject;

public class MoEMiPushReceiver
extends PushMessageReceiver {
    private static final String TAG = "MoEMiPushReceiver";

    public void onReceivePassThroughMessage(Context context, MiPushMessage miPushMessage) {
        try {
            Logger.v((String)"MoEMiPushReceiver onReceivePassThroughMessage() : Will try to process and show pass through message.");
            if (miPushMessage == null) {
                Logger.e((String)"MoEMiPushReceiver onReceivePassThroughMessage() : MiPushMessage object is null");
                return;
            }
            String messageContent = miPushMessage.getContent();
            if (TextUtils.isEmpty((CharSequence)messageContent)) {
                Logger.e((String)"MoEMiPushReceiver onReceivePassThroughMessage() : Cannot show message, content is empty.");
                return;
            }
            Bundle pushPayload = MoEUtils.jsonToBundle((JSONObject)new JSONObject(messageContent));
            PushManager.PushHandler pushHandler = PushManager.getInstance().getPushHandler();
            if (pushPayload != null && pushHandler != null) {
                pushHandler.handlePushPayload(context, pushPayload);
            }
        }
        catch (Exception e) {
            Logger.f((String)"MoEMiPushReceiver onReceivePassThroughMessage() : ");
        }
    }

    public void onNotificationMessageClicked(Context context, MiPushMessage miPushMessage) {
        Intent redirectIntent = MoEHelperUtils.getLauncherActivityIntent((Context)context);
        redirectIntent.setFlags(0x10000000);
        try {
            Logger.d((String)"MoEMiPushReceiver onNotificationMessageClicked() : Will try to process notification click");
            if (miPushMessage == null) {
                Logger.e((String)"MoEMiPushReceiver onNotificationMessageClicked() : MiPushMessage object is null");
                return;
            }
            Logger.v((String)("MoEMiPushReceiver onNotificationMessageClicked() : Notification clicked Payload: " + miPushMessage.toString()));
            String messageContent = miPushMessage.getContent();
            if (TextUtils.isEmpty((CharSequence)messageContent)) {
                Logger.e((String)"MoEMiPushReceiver onNotificationMessageClicked() : Cannot show message, content is empty.");
                return;
            }
            Bundle pushPayload = MoEUtils.jsonToBundle((JSONObject)new JSONObject(miPushMessage.getContent()));
            if (pushPayload != null) {
                Logger.v((String)"MoEMiPushReceiver onNotificationMessageClicked() : Will try to process notification click.");
                pushPayload.putLong("MOE_MSG_RECEIVED_TIME", MoEUtils.currentTime());
                MoEHelperUtils.dumpIntentExtras((Bundle)pushPayload);
                MoEDispatcher.getInstance((Context)context).addTaskToQueue((ITask)new WriteMessageToInbox(context, pushPayload));
                redirectIntent = new Intent(context, PushTracker.class);
                redirectIntent.setAction("" + MoEUtils.currentTime());
                redirectIntent.setFlags(0x10000000);
                pushPayload.putAll(MoEngageNotificationUtils.getMoEngageExtras((Bundle)pushPayload));
                redirectIntent.putExtras(pushPayload);
            }
        }
        catch (Exception e) {
            Logger.f((String)"MoEMiPushReceiver onNotificationMessageClicked() : Exception: ", (Throwable)e);
        }
        context.startActivity(redirectIntent);
    }

    public void onReceiveRegisterResult(Context context, MiPushCommandMessage miPushCommandMessage) {
        try {
            String commandArg1;
            Logger.v((String)("MoEMiPushReceiver onReceiveRegisterResult() : Message: " + miPushCommandMessage));
            String command = miPushCommandMessage.getCommand();
            if (!"register".equals(command)) {
                Logger.e((String)"MoEMiPushReceiver onReceiveRegisterResult() : Received command is not register command.");
                return;
            }
            if (miPushCommandMessage.getResultCode() != 0L) {
                Logger.e((String)"MoEMiPushReceiver onReceiveRegisterResult() : Registration failed.");
                return;
            }
            List arguments = miPushCommandMessage.getCommandArguments();
            String string = commandArg1 = arguments != null && arguments.size() > 0 ? (String)arguments.get(0) : null;
            if (TextUtils.isEmpty(commandArg1)) {
                Logger.e((String)"MoEMiPushReceiver onReceiveRegisterResult() : Token is null or empty");
                return;
            }
            MiPushController.getInstance().processPushToken(context, commandArg1);
        }
        catch (Exception e) {
            Logger.f((String)"MoEMiPushReceiver onReceiveRegisterResult() : Exception: ", (Throwable)e);
        }
    }

    public void onRequirePermissions(Context context, String[] strings) {
        try {
            Logger.e((String)("MoEMiPushReceiver onRequirePermissions() : " + strings.toString()));
        }
        catch (Exception e) {
            Logger.e((String)"MoEMiPushReceiver onRequirePermissions() : Exception: ", (Throwable)e);
        }
    }

    public void onNotificationMessageArrived(Context context, MiPushMessage miPushMessage) {
    }
}

