/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.mi;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.mi.MiPushEvaluator;
import com.moengage.mi.MiPushRepository;
import com.xiaomi.mipush.sdk.MiPushClient;
import java.util.List;

class MiPushController {
    private static final String TAG = "MiPushController";
    private MiPushEvaluator evaluator = new MiPushEvaluator();
    private MiPushRepository repository = new MiPushRepository();
    private static MiPushController instance;

    private MiPushController() {
    }

    static MiPushController getInstance() {
        if (instance == null) {
            instance = new MiPushController();
        }
        return instance;
    }

    void initialiseMiPush(Application application) {
        try {
            if (!this.evaluator.shouldInitialiseMiPush(this.repository.isMiPushEnabled(), this.repository.getDeviceManufacturer())) {
                Logger.e((String)"MiPushController initialiseMiPush() : Either it is not a Xiaomi device or Mi Push is disabled.");
                return;
            }
            if (this.repository.isPushNotificationOptedOut(application.getApplicationContext())) {
                Logger.e((String)"MiPushController initialiseMiPush() : Push notification disabled will not register for push token.");
                return;
            }
            String miAppId = this.repository.getMiAppId();
            String miAppKey = this.repository.getMiAppKey();
            if (TextUtils.isEmpty((CharSequence)miAppId)) {
                Logger.e((String)"MiPushController initialiseMiPush() : Mi App Id is empty cannot register for Mi Push");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)miAppKey)) {
                Logger.e((String)"MiPushController initialiseMiPush() : Mi App Key is empty cannot register for Mi Push");
                return;
            }
            if (!this.shouldInit(application.getApplicationContext())) {
                Logger.v((String)"MiPushController initialiseMiPush() : Mi Push service already running need to re-initialise");
                return;
            }
            MiPushClient.registerPush((Context)application, (String)miAppId, (String)miAppKey);
        }
        catch (Exception e) {
            Logger.f((String)"MiPushController initialiseMiPush() : Exception: ", (Throwable)e);
        }
    }

    private boolean shouldInit(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        if (am == null) {
            return false;
        }
        List processInfos = am.getRunningAppProcesses();
        String mainProcessName = context.getPackageName();
        int myPid = Process.myPid();
        for (ActivityManager.RunningAppProcessInfo info : processInfos) {
            if (info.pid != myPid || !mainProcessName.equals(info.processName)) continue;
            return true;
        }
        return false;
    }

    void processPushToken(Context context, String pushToken) {
        Logger.v((String)("MiPushController processPushToken() : Token: " + pushToken));
        if (TextUtils.isEmpty((CharSequence)pushToken)) {
            Logger.e((String)"MiPushController processPushToken() : Passed push token is empty no processing required.");
            return;
        }
        if (this.evaluator.shouldSendTokenToServer(this.repository.getSavedToken(context), pushToken, this.repository.hasSentMiPushTokenToServer(context))) {
            Logger.v((String)("MiPushController processPushToken() : Will try to send token to server. Token: " + pushToken));
            MoEDispatcher.getInstance((Context)context).getDeviceAddManager().registerMiToken(context);
        } else {
            Logger.v((String)"MiPushController processPushToken() : Token already sent to server. Need not resend again.");
        }
        this.repository.savePushToken(context, pushToken);
    }
}

