package com.moengage.mi;

import android.content.Context;
import android.os.Bundle;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.pushbase.push.MoEngageNotificationUtils;

/**
 * Write Push payload to storage.
 * @author Umang Chamaria
 */
public class WriteMessageToInbox extends SDKTask {

  private static final String TAG = "WriteMessageToInbox";
  private Bundle pushPayload;

  WriteMessageToInbox(Context context, Bundle pushPayload) {
    super(context);
    this.pushPayload = pushPayload;
  }

  @Override public TaskResult execute() {
    try {
      Logger.v(TAG + " execute() : Will try to write message to inbox");
      MoEngageNotificationUtils.addNotificationToInboxIfRequired(mContext, pushPayload);
      MoEngageNotificationUtils.updateClickToInbox(mContext, pushPayload);
    } catch (Exception e) {
      Logger.e( TAG + " execute() : Exception: ", e);
    }
    return null;
  }

  @Override public String getTaskTag() {
    return MiPushConstants.WRITE_TO_INBOX_TASK_TAG;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
