package com.moengage.mi;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.push.PushManager;
import com.moengage.push.PushManager.PushHandler;
import com.moengage.pushbase.activities.PushTracker;
import com.moengage.pushbase.push.MoEngageNotificationUtils;
import com.xiaomi.mipush.sdk.ErrorCode;
import com.xiaomi.mipush.sdk.MiPushClient;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushMessageReceiver;
import java.util.List;
import org.json.JSONObject;

import static com.moe.pushlibrary.utils.MoEHelperConstants.EXTRA_MSG_RECEIVED_TIME;

/**
 * Push Receiver for Mi Push.
 *
 * @author Umang Chamaria
 */
public class MoEMiPushReceiver extends PushMessageReceiver {
  private static final String TAG = "MoEMiPushReceiver";

  @Override public void onReceivePassThroughMessage(Context context, MiPushMessage miPushMessage) {
    try {
      Logger.v(TAG
          + " onReceivePassThroughMessage() : Will try to process and show pass through "
          + "message.");
      if (miPushMessage == null) {
        Logger.e(TAG + " onReceivePassThroughMessage() : MiPushMessage object is null");
        return;
      }
      String messageContent = miPushMessage.getContent();
      if (TextUtils.isEmpty(messageContent)) {
        Logger.e(TAG + " onReceivePassThroughMessage() : Cannot show message, content is empty.");
        return;
      }
      Bundle pushPayload = MoEUtils.jsonToBundle(new JSONObject(messageContent));
      PushHandler pushHandler = PushManager.getInstance().getPushHandler();
      if (pushPayload != null && pushHandler != null) {
        pushHandler.handlePushPayload(context, pushPayload);
      }
    } catch (Exception e) {
      Logger.f(TAG + " onReceivePassThroughMessage() : ");
    }
  }

  @Override public void onNotificationMessageClicked(Context context, MiPushMessage miPushMessage) {
    // process notification click
    // 1. track click
    // 2. redirect user
    Intent redirectIntent = MoEHelperUtils.getLauncherActivityIntent(context);
    redirectIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
    try {
      Logger.d(TAG + " onNotificationMessageClicked() : Will try to process notification click");
      if (miPushMessage == null) {
        Logger.e(TAG + " onNotificationMessageClicked() : MiPushMessage object is null");
        return;
      }
      Logger.v(TAG
          + " onNotificationMessageClicked() : Notification clicked Payload: "
          + miPushMessage.toString());
      String messageContent = miPushMessage.getContent();
      if (TextUtils.isEmpty(messageContent)) {
        Logger.e(TAG + " onNotificationMessageClicked() : Cannot show message, content is empty.");
        return;
      }
      Bundle pushPayload = MoEUtils.jsonToBundle(new JSONObject(miPushMessage.getContent()));
      if (pushPayload != null) {
        Logger.v(TAG + " onNotificationMessageClicked() : Will try to process notification click.");
        pushPayload.putLong(EXTRA_MSG_RECEIVED_TIME, MoEUtils.currentTime());
        MoEHelperUtils.dumpIntentExtras(pushPayload);
        MoEDispatcher.getInstance(context)
            .addTaskToQueue(new WriteMessageToInbox(context, pushPayload));
        redirectIntent = new Intent(context, PushTracker.class);
        redirectIntent.setAction("" + MoEUtils.currentTime());
        redirectIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        pushPayload.putAll(MoEngageNotificationUtils.getMoEngageExtras(pushPayload));
        redirectIntent.putExtras(pushPayload);
      }
    } catch (Exception e) {
      Logger.f(TAG + " onNotificationMessageClicked() : Exception: ", e);
    }
    context.startActivity(redirectIntent);
  }

  @Override
  public void onReceiveRegisterResult(Context context, MiPushCommandMessage miPushCommandMessage) {
    // save push token
    try {
      Logger.v(TAG + " onReceiveRegisterResult() : Message: " + miPushCommandMessage);
      String command = miPushCommandMessage.getCommand();
      if (!MiPushClient.COMMAND_REGISTER.equals(command)) {
        Logger.e(TAG + " onReceiveRegisterResult() : Received command is not register command.");
        return;
      }
      if (miPushCommandMessage.getResultCode() != ErrorCode.SUCCESS) {
        Logger.e(TAG + " onReceiveRegisterResult() : Registration failed.");
        return;
      }
      List<String> arguments = miPushCommandMessage.getCommandArguments();
      String commandArg1 = ((arguments != null && arguments.size() > 0) ? arguments.get(0) : null);
      if (TextUtils.isEmpty(commandArg1)) {
        Logger.e(TAG + " onReceiveRegisterResult() : Token is null or empty");
        return;
      }
      MiPushController.getInstance().processPushToken(context, commandArg1);
    } catch (Exception e) {
      Logger.f(TAG + " onReceiveRegisterResult() : Exception: ", e);
    }
  }

  @Override public void onRequirePermissions(Context context, String[] strings) {
    try {
      Logger.e(TAG + " onRequirePermissions() : " + strings.toString());
    } catch (Exception e) {
      Logger.e(TAG + " onRequirePermissions() : Exception: ", e);
    }
  }

  @Override public void onNotificationMessageArrived(Context context, MiPushMessage miPushMessage) {
    // see if tracking a custom event is required for analysis and debugging purpose
  }
}
