package com.moengage.mi;

import com.moengage.core.MoEUtils;

/**
 * @author Umang Chamaria
 */
class MiPushEvaluator {
  /**
   * Checks whether Mi Push service should be initialised or not.
   *
   * @param isMiPushEnabled true if Mi Push is enabled by the client, else false.
   * @param manufacturer Device Manufacturer.
   * @return true if Mi Push service should be initialised else false.
   */
  boolean shouldInitialiseMiPush(boolean isMiPushEnabled, String manufacturer){
    return isMiPushEnabled
        && MoEUtils.isXiaomiDevice(manufacturer);
  }

  boolean shouldSendTokenToServer(String savedToken, String currentToken, boolean
      hasSentTokenToServer){
    if (savedToken == null || !hasSentTokenToServer) return true;
    return !(savedToken.equals(currentToken));
  }
}
