/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.firebase.internal;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.Properties;
import com.moengage.firebase.MoEFireBaseHelper;
import com.moengage.firebase.internal.Injection;
import com.moengage.firebase.internal.repository.FirebaseRepository;
import com.moengage.firebase.listener.FirebaseEventListener;
import com.moengage.push.PushManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/moengage/firebase/internal/TokenHandler;", "", "()V", "ATTR_REGISTRATION_BY", "", "ID_PREFIX", "lock", "tag", "notifyListeners", "", "token", "processToken", "context", "Landroid/content/Context;", "pushToken", "pushRegisteredBy", "ripMultiplexingExtras", "tokenRefreshRequired", "", "newToken", "oldToken", "trackDeviceAttributeForRegistration", "trackTokenGeneration", "moe-push-firebase_release"})
public final class TokenHandler {
    private static final String tag = "FCM_4.1.04_TokenHandler";
    private static final String ATTR_REGISTRATION_BY = "registered_by";
    private static final Object lock;
    private static final String ID_PREFIX = "|ID|";
    public static final TokenHandler INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processToken(@NotNull Context context, @Nullable String pushToken, @NotNull String pushRegisteredBy) {
        boolean bl;
        Object object;
        block11: {
            block10: {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)pushRegisteredBy, (String)"pushRegisteredBy");
                if (pushToken == null) break block10;
                object = pushToken;
                bl = false;
                object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
                bl = false;
                if (!(object.length() == 0)) break block11;
            }
            return;
        }
        Logger.v((String)("FCM_4.1.04_TokenHandler processToken() : Will try to process push token. Token: " + pushToken + " registered by: " + pushRegisteredBy));
        try {
            object = lock;
            bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                String token = INSTANCE.ripMultiplexingExtras(pushToken);
                INSTANCE.notifyListeners(pushToken);
                FirebaseRepository repository = Injection.INSTANCE.getRepository(context);
                String oldRegId = repository.getPushToken();
                boolean update = INSTANCE.tokenRefreshRequired(token, oldRegId);
                if (update) {
                    repository.savePushToken(token);
                    MoEDispatcher moEDispatcher = MoEDispatcher.getInstance((Context)context);
                    Intrinsics.checkExpressionValueIsNotNull((Object)moEDispatcher, (String)"MoEDispatcher.getInstance(context)");
                    moEDispatcher.getDeviceAddManager().registerFcmToken(context);
                    INSTANCE.trackTokenGeneration(pushRegisteredBy, context);
                }
                Logger.v((String)("FCM_4.1.04_TokenHandler processToken() oldId: = " + oldRegId + " token = " + token + ' ' + "--updating[true/false]: " + update));
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            Logger.e((String)"FCM_4.1.04_TokenHandler processToken() : Exception ", (Throwable)e);
        }
    }

    private final void trackTokenGeneration(String pushRegisteredBy, Context context) {
        Properties properties = new Properties();
        properties.addAttribute(ATTR_REGISTRATION_BY, (Object)pushRegisteredBy);
        properties.setNonInteractive();
        MoEHelper.getInstance((Context)context).trackEvent("TOKEN_EVENT", properties);
        this.trackDeviceAttributeForRegistration(context, pushRegisteredBy);
    }

    private final void notifyListeners(String token) {
        PushManager.getInstance().notifyTokenChange(token);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(token){
            final /* synthetic */ String $token;

            public final void run() {
                try {
                    FirebaseEventListener firebaseEventListener = MoEFireBaseHelper.Companion.getInstance().getEventListener$moe_push_firebase_release();
                    if (firebaseEventListener != null) {
                        firebaseEventListener.onTokenAvailable(this.$token);
                    }
                }
                catch (Exception ex) {
                    Logger.e((String)"FCM_4.1.04_TokenHandler notifyListeners: Exception: ", (Throwable)ex);
                }
            }
            {
                this.$token = string;
            }
        });
    }

    private final String ripMultiplexingExtras(String token) {
        String string;
        if (!MoEUtils.isEmptyString((String)token) && StringsKt.startsWith$default((String)token, (String)ID_PREFIX, (boolean)false, (int)2, null)) {
            String string2 = token;
            int n = 7;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = token;
        }
        return string;
    }

    private final boolean tokenRefreshRequired(String newToken, String oldToken) {
        return !MoEUtils.isEmptyString((String)newToken) ? MoEUtils.isEmptyString((String)oldToken) || !newToken.equals(oldToken) : false;
    }

    private final void trackDeviceAttributeForRegistration(Context context, String pushRegisteredBy) {
        try {
            JSONObject attribute = new JSONObject();
            attribute.put("moe_p_reg", (Object)pushRegisteredBy);
            MoEDispatcher.getInstance((Context)context).setDeviceAttribute(attribute);
        }
        catch (Exception e) {
            Logger.e((String)"FCM_4.1.04_TokenHandler trackDeviceAttributeForRegistration() : ", (Throwable)e);
        }
    }

    private TokenHandler() {
    }

    static {
        TokenHandler tokenHandler;
        INSTANCE = tokenHandler = new TokenHandler();
        lock = new Object();
    }
}

