/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.firebase.internal;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.WorkerThread;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.messaging.RemoteMessage;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.MoECallbacks;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEUtils;
import com.moengage.core.SdkConfig;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.listeners.AppBackgroundListener;
import com.moengage.firebase.MoEFireBaseHelper;
import com.moengage.firebase.internal.Injection;
import com.moengage.firebase.internal.TokenHandler;
import com.moengage.firebase.listener.FirebaseEventListener;
import com.moengage.firebase.listener.OnNonMoEngagePushReceivedListener;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001f\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u000eJ\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/moengage/firebase/internal/FcmController;", "Lcom/moengage/core/listeners/AppBackgroundListener;", "()V", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "tag", "", "getPushToken", "", "context", "Landroid/content/Context;", "onAppBackground", "onNewToken", "token", "onNewToken$moe_push_firebase_release", "onNonMoEngagePushReceived", "message", "Lcom/google/firebase/messaging/RemoteMessage;", "processPushTokenForSenderId", "scheduleTokenRegistrationRetry", "shouldRegisterForPush", "", "Companion", "moe-push-firebase_release"})
public final class FcmController
implements AppBackgroundListener {
    private final String tag = "FCM_4.1.04_FcmController";
    private ScheduledExecutorService scheduler;
    private static FcmController instance;
    public static final Companion Companion;

    public final void getPushToken(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            Logger.v((String)(this.tag + " getPushToken() : Will try to register for push."));
            if (!this.shouldRegisterForPush(context)) {
                return;
            }
            if (!MoEUtils.isEmptyString((String)SdkConfig.getConfig().pushConfig.fcm.getSenderId())) {
                Logger.v((String)(this.tag + " getPushToken() : Sender-id is set by the client, will use it for push token registration."));
                TaskManager.getInstance().execute(new com.moengage.core.executor.Task(this, context){
                    final /* synthetic */ FcmController this$0;
                    final /* synthetic */ Context $context;

                    public final void execute() {
                        FcmController.access$processPushTokenForSenderId(this.this$0, this.$context);
                    }
                    {
                        this.this$0 = fcmController;
                        this.$context = context;
                    }
                });
                return;
            }
            Logger.v((String)(this.tag + " getPushToken() : Regular app registration."));
            FirebaseInstanceId firebaseInstanceId = FirebaseInstanceId.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)firebaseInstanceId, (String)"FirebaseInstanceId.getInstance()");
            firebaseInstanceId.getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(this, context){
                final /* synthetic */ FcmController this$0;
                final /* synthetic */ Context $context;

                public final void onComplete(@NotNull Task<InstanceIdResult> task) {
                    Intrinsics.checkParameterIsNotNull(task, (String)"task");
                    try {
                        String token;
                        if (!task.isSuccessful()) {
                            Logger.e((String)(FcmController.access$getTag$p(this.this$0) + " onComplete() : Task<InstanceIdResult> failed. "), (Throwable)task.getException());
                            FcmController.access$scheduleTokenRegistrationRetry(this.this$0, this.$context);
                            return;
                        }
                        InstanceIdResult instanceIdResult = (InstanceIdResult)task.getResult();
                        String string = token = instanceIdResult != null ? instanceIdResult.getToken() : null;
                        if (MoEUtils.isEmptyString((String)token)) {
                            FcmController.access$scheduleTokenRegistrationRetry(this.this$0, this.$context);
                            return;
                        }
                        String string2 = MoEConstants.ATTRIBUTE_TOKEN_REGISTERED_MOE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"MoEConstants.ATTRIBUTE_TOKEN_REGISTERED_MOE");
                        TokenHandler.INSTANCE.processToken(this.$context, token, string2);
                    }
                    catch (Exception e) {
                        Logger.e((String)(FcmController.access$getTag$p(this.this$0) + " onComplete() : "), (Throwable)e);
                        FcmController.access$scheduleTokenRegistrationRetry(this.this$0, this.$context);
                    }
                }
                {
                    this.this$0 = fcmController;
                    this.$context = context;
                }
            });
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getPushToken() : "), (Throwable)e);
        }
    }

    @WorkerThread
    private final void processPushTokenForSenderId(Context context) throws IOException {
        try {
            String token;
            String string;
            String string2 = SdkConfig.getConfig().pushConfig.fcm.getSenderId();
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String senderId = string3;
                boolean bl3 = false;
                string = FirebaseInstanceId.getInstance().getToken(senderId, "FCM");
            } else {
                string = token = null;
            }
            if (MoEUtils.isEmptyString(token)) {
                Logger.v((String)(this.tag + " processPushTokenForSenderId() : Empty token returned. Scheduling a" + " retry."));
                this.scheduleTokenRegistrationRetry(context);
                return;
            }
            Logger.v((String)(this.tag + " processPushTokenForSenderId() : Token: " + token));
            String string4 = MoEConstants.ATTRIBUTE_TOKEN_REGISTERED_MOE;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"MoEConstants.ATTRIBUTE_TOKEN_REGISTERED_MOE");
            TokenHandler.INSTANCE.processToken(context, token, string4);
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " processPushTokenForSenderId() : "), (Throwable)e);
            this.scheduleTokenRegistrationRetry(context);
        }
    }

    private final void scheduleTokenRegistrationRetry(Context context) {
        block4: {
            block3: {
                block2: {
                    if (MoEHelper.isAppInBackground()) {
                        return;
                    }
                    Logger.v((String)(this.tag + " scheduleTokenRegistrationRetry() : Will schedule token registration retry."));
                    if (this.scheduler == null) break block2;
                    ScheduledExecutorService scheduledExecutorService = this.scheduler;
                    if (scheduledExecutorService == null) break block3;
                    if (!scheduledExecutorService.isShutdown()) break block3;
                }
                this.scheduler = Executors.newScheduledThreadPool(1);
            }
            Runnable runnable2 = new Runnable(this, context){
                final /* synthetic */ FcmController this$0;
                final /* synthetic */ Context $context;

                public final void run() {
                    Logger.v((String)(FcmController.access$getTag$p(this.this$0) + " run() : Will try attempt to register for token."));
                    this.this$0.getPushToken(this.$context);
                }
                {
                    this.this$0 = fcmController;
                    this.$context = context;
                }
            };
            ScheduledExecutorService scheduledExecutorService = this.scheduler;
            if (scheduledExecutorService == null) break block4;
            scheduledExecutorService.schedule(runnable2, SdkConfig.getConfig().pushConfig.tokenRetryInterval, TimeUnit.SECONDS);
        }
    }

    public void onAppBackground(@NotNull Context context) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            try {
                Logger.v((String)(this.tag + " goingToBackground() : Will shutdown scheduler."));
                if (this.scheduler == null) break block3;
                ScheduledExecutorService scheduledExecutorService = this.scheduler;
                if (scheduledExecutorService == null) break block3;
                if (scheduledExecutorService.isShutdown()) break block3;
                ScheduledExecutorService scheduledExecutorService2 = this.scheduler;
                if (scheduledExecutorService2 != null) {
                    scheduledExecutorService2.shutdownNow();
                }
            }
            catch (Exception e) {
                Logger.e((String)(this.tag + " goingToBackground() : "), (Throwable)e);
            }
        }
    }

    public final void onNonMoEngagePushReceived(@NotNull Context context, @NotNull RemoteMessage message) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(this, message){
                final /* synthetic */ FcmController this$0;
                final /* synthetic */ RemoteMessage $message;

                public final void run() {
                    try {
                        FirebaseEventListener firebaseEventListener = MoEFireBaseHelper.Companion.getInstance().getEventListener$moe_push_firebase_release();
                        if (firebaseEventListener != null) {
                            firebaseEventListener.onNonMoEngageMessageReceived(this.$message);
                        }
                    }
                    catch (Exception e) {
                        Logger.e((String)(FcmController.access$getTag$p(this.this$0) + " notifyListeners: Exception: "), (Throwable)e);
                    }
                }
                {
                    this.this$0 = fcmController;
                    this.$message = remoteMessage;
                }
            });
            OnNonMoEngagePushReceivedListener onNonMoEngagePushReceivedListener = MoEFireBaseHelper.Companion.getInstance().getNonMoEngagePushReceivedListener$moe_push_firebase_release();
            if (onNonMoEngagePushReceivedListener == null) break block0;
            onNonMoEngagePushReceivedListener.onPushReceived(context, message);
        }
    }

    public final void onNewToken$moe_push_firebase_release(@NotNull Context context, @Nullable String token) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            if (!this.shouldRegisterForPush(context)) {
                Logger.v((String)(this.tag + " onNewToken() : Ignoring token as MoEngage is not registering for " + "push"));
                return;
            }
            CharSequence charSequence = token;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                Logger.v((String)(this.tag + " onNewToken() : Generated token is empty, returning"));
                return;
            }
            String string = MoEConstants.ATTRIBUTE_TOKEN_REGISTERED_MOE;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MoEConstants.ATTRIBUTE_TOKEN_REGISTERED_MOE");
            TokenHandler.INSTANCE.processToken(context, token, string);
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " onNewToken() : "), (Throwable)e);
        }
    }

    private final boolean shouldRegisterForPush(Context context) {
        return SdkConfig.getConfig().pushConfig.fcm.isRegistrationEnabled() && !Injection.INSTANCE.getRepository(context).isPushNotificationOptedOut();
    }

    private FcmController() {
        MoECallbacks.getInstance().addAppBackgroundListener((AppBackgroundListener)this);
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ void access$processPushTokenForSenderId(FcmController $this, Context context) {
        $this.processPushTokenForSenderId(context);
    }

    public static final /* synthetic */ String access$getTag$p(FcmController $this) {
        return $this.tag;
    }

    public static final /* synthetic */ void access$scheduleTokenRegistrationRetry(FcmController $this, Context context) {
        $this.scheduleTokenRegistrationRetry(context);
    }

    public /* synthetic */ FcmController(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/moengage/firebase/internal/FcmController$Companion;", "", "()V", "instance", "Lcom/moengage/firebase/internal/FcmController;", "getInstance", "moe-push-firebase_release"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final FcmController getInstance() {
            if (instance == null) {
                Class<FcmController> clazz = FcmController.class;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (clazz) {
                    boolean bl3 = false;
                    if (instance == null) {
                        instance = new FcmController(null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            FcmController fcmController = instance;
            if (fcmController == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.moengage.firebase.internal.FcmController");
            }
            return fcmController;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

