/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.firebase;

import android.content.Context;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.moengage.core.Logger;
import com.moengage.firebase.MoEFireBaseHelper;
import com.moengage.firebase.internal.FcmController;
import com.moengage.pushbase.MoEPushHelper;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/moengage/firebase/MoEFireBaseMessagingService;", "Lcom/google/firebase/messaging/FirebaseMessagingService;", "()V", "tag", "", "onMessageReceived", "", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "onNewToken", "token", "moe-push-firebase_release"})
public final class MoEFireBaseMessagingService
extends FirebaseMessagingService {
    private final String tag = "FCM_4.1.04_MoEFireBaseMessagingService";

    public void onMessageReceived(@NotNull RemoteMessage remoteMessage) {
        Intrinsics.checkParameterIsNotNull((Object)remoteMessage, (String)"remoteMessage");
        try {
            Map map = remoteMessage.getData();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"remoteMessage.data");
            Map pushPayload = map;
            if (MoEPushHelper.getInstance().isFromMoEngagePlatform(pushPayload)) {
                Logger.v((String)(this.tag + " onMessageReceived() : MoEngage Push Received, Will try to " + "show notification."));
                MoEFireBaseHelper moEFireBaseHelper = MoEFireBaseHelper.Companion.getInstance();
                Context context = this.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
                moEFireBaseHelper.passPushPayload(context, pushPayload);
            } else {
                Logger.v((String)(this.tag + " onMessageReceived() : Not a MoEngage Payload, will try to " + "trigger the callback if required."));
                FcmController fcmController = FcmController.Companion.getInstance();
                Context context = this.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
                fcmController.onNonMoEngagePushReceived(context, remoteMessage);
            }
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " : onMessageReceived() : Exception "), (Throwable)e);
        }
    }

    public void onNewToken(@NotNull String token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        try {
            Logger.v((String)("MoEFireBaseMessagingService: onNewToken() : Push Token " + token));
            FcmController fcmController = FcmController.Companion.getInstance();
            Context context = this.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
            fcmController.onNewToken$moe_push_firebase_release(context, token);
        }
        catch (Exception e) {
            Logger.e((String)"MoEFireBaseMessagingService: onNewToken() : Exception ", (Throwable)e);
        }
    }
}

