/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.firebase.listener

import androidx.annotation.MainThread
import com.google.firebase.messaging.RemoteMessage
import com.moengage.core.Logger
import com.moengage.firebase.internal.MODULE_TAG

/**
 * Class definition for callbacks related to Firebase events.
 *
 * Extend the class when MoEngage SDK handles the Firebase push registration and message
 * receiving and set the event listener to receive callbacks
 *
 * @sample [com.moengage.firebase.MoEFireBaseHelper.getInstance().setEventListener()]
 *
 * @author Arshiya Khanum
 * Date: 2020/07/16
 * @since 10.3.00
 */
open class FirebaseEventListener {
    private val tag = "${MODULE_TAG}FirebaseEventListener"

    /**
     * Callback triggered when push message received isn't from MoEngage Platform
     *
     * @param remoteMessage instance of [com.google.firebase.messaging.RemoteMessage]
     * @since 10.3.00
     */
    @MainThread
    open fun onNonMoEngageMessageReceived(remoteMessage: RemoteMessage) {
        Logger.v("$tag onNonMoEngageMessageReceived() : remoteMessage: $remoteMessage")
    }

    /**
     * Callback invoked on token received
     *
     * @param token instance of [String]
     * @since 10.3.00
     */
    @MainThread
    open fun onTokenAvailable(token: String) {
        Logger.v("$tag onTokenAvailable() : token: $token")
    }
}