/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.firebase

import android.content.Context
import android.os.Bundle
import androidx.annotation.Keep
import com.moengage.core.Logger
import com.moengage.core.MoEConstants
import com.moengage.firebase.internal.FcmController
import com.moengage.firebase.internal.MODULE_TAG
import com.moengage.firebase.internal.TokenHandler
import com.moengage.push.PushHandler
import com.moengage.pushbase.MoEPushHelper

/**
 * @author Umang Chamaria
 */
@Keep
class PushHandlerImpl : PushHandler {

    private val tag = "{${MODULE_TAG}PushHandlerImpl"

    override fun registerForPushToken(context: Context) {
        FcmController.getInstance().getPushToken(context)
    }

    @Suppress("SENSELESS_COMPARISON")
    override fun handlePushPayload(context: Context, extras: Bundle) {
        try {
            MoEPushHelper.getInstance().handlePushPayload(context, extras)
        } catch (e: Exception) {
            Logger.e("$tag handlePushPayload() ", e)
        }
    }

    override fun handlePushPayload(context: Context, pushPayload: Map<String, String>) {
        MoEPushHelper.getInstance().handlePushPayload(context, pushPayload)
    }

    override fun passPushToken(context: Context, pushToken: String) {
        TokenHandler.processToken(context, pushToken, MoEConstants.ATTRIBUTE_TOKEN_REGISTERED_APP)
    }

}