/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.moengage.firebase

import com.google.firebase.messaging.FirebaseMessagingService
import com.google.firebase.messaging.RemoteMessage
import com.moengage.core.Logger
import com.moengage.firebase.internal.FcmController
import com.moengage.firebase.internal.MODULE_TAG
import com.moengage.pushbase.MoEPushHelper

/**
 * Class for receiving Firebase Cloud Messaging.
 *
 * @author Umang Chamaria
 */
class MoEFireBaseMessagingService : FirebaseMessagingService() {

    private val tag = "${MODULE_TAG}MoEFireBaseMessagingService"

    @Suppress("SENSELESS_COMPARISON")
    override fun onMessageReceived(remoteMessage: RemoteMessage) {
        try {
            if (remoteMessage == null) {
                Logger.e("$tag :onMessageReceived : RemoteMessage Null")
                return
            }
            val pushPayload = remoteMessage.data
            if (MoEPushHelper.getInstance().isFromMoEngagePlatform(pushPayload)) {
                Logger.v(
                    "$tag onMessageReceived() : MoEngage Push Received, Will try to " +
                            "show notification."
                )
                MoEFireBaseHelper.getInstance().passPushPayload(applicationContext, pushPayload)
            } else {
                Logger.v("$tag onMessageReceived() : Not a MoEngage Payload, will try to " +
                        "trigger the callback if required."
                )

                FcmController.getInstance().onNonMoEngagePushReceived(applicationContext,
                    remoteMessage)
            }
        } catch (e: Exception) {
            Logger.e("$tag : onMessageReceived() : Exception ", e)
        }
    }

    override fun onNewToken(token: String) {
        try {
            Logger.v("MoEFireBaseMessagingService: onNewToken() : Push Token $token")
            FcmController.getInstance()
                .onNewToken(applicationContext, token)
        } catch (e: Exception) {
            Logger.e("MoEFireBaseMessagingService: onNewToken() : Exception ", e)
        }
    }
}