/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.firebase;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.ITask;
import com.moengage.push.PushManager;
import com.moengage.pushbase.PushUtils;
import com.moengage.pushbase.push.MoEPushWorkerTask;
import com.moengage.pushbase.push.PushMessageListener;
import java.util.Map;

public class PushHandlerImpl
implements PushManager.PushHandler {
    private PushMessageListener pushMessageListener;
    private static PushHandlerImpl _INSTANCE;
    private static String TAG;

    public PushHandlerImpl() {
        _INSTANCE = this;
    }

    public static PushHandlerImpl getInstance() {
        if (_INSTANCE == null) {
            new PushHandlerImpl();
        }
        return _INSTANCE;
    }

    public String registerForPushToken(Context context) {
        ConfigurationProvider.getInstance((Context)context).setDeviceRegistered(false);
        String token = this.getPushToken(context);
        if (token != null) {
            return token;
        }
        return null;
    }

    @Nullable
    public String getPushToken(final Context context) {
        try {
            if (!PushUtils.shouldRegisterForPush((Context)context)) {
                return null;
            }
            final String[] token = new String[]{null};
            FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){

                public void onComplete(@NonNull Task<InstanceIdResult> task) {
                    try {
                        if (task.isSuccessful()) {
                            token[0] = ((InstanceIdResult)task.getResult()).getToken();
                            if (!TextUtils.isEmpty((CharSequence)token[0])) {
                                PushManager.getInstance().refreshTokenInternal(context, token[0], "MoE");
                            } else {
                                Logger.e((String)(TAG + " onComplete() : getToken() API returned an empty token"));
                            }
                        } else {
                            Logger.e((String)(TAG + " onComplete() : Task<InstanceIdResult> failed. "));
                            PushUtils.scheduleDeviceRegistrationCall((Context)context);
                        }
                    }
                    catch (Exception e) {
                        Logger.e((String)(TAG + " onComplete() : "), (Throwable)e);
                    }
                }
            });
            return token[0];
        }
        catch (Exception e) {
            PushUtils.scheduleDeviceRegistrationCall((Context)context);
            Logger.e((String)"PushHandlerImpl(firebase):registerForPush ", (Throwable)e);
            MoEHelper.getInstance((Context)context).getDelegate().logPushFailureEvent(context, e.getMessage());
            return null;
        }
    }

    public void handlePushPayload(Context context, String pushPayload) {
        Logger.e((String)"PushHandlerImpl(firebase):This method should only be called from the baidu module");
    }

    public void handlePushPayload(Context context, Bundle extras) {
        try {
            if (null == extras) {
                return;
            }
            if (Looper.myLooper() == Looper.getMainLooper()) {
                MoEDispatcher.getInstance((Context)context).addTaskToQueueBeginning((ITask)new MoEPushWorkerTask(context, "SHOW_NOTIFICATION", extras));
            } else {
                this.getMessageListener().onMessagereceived(context, extras);
            }
        }
        catch (Exception e) {
            Logger.f((String)"PushHandlerImpl(firebase): handlePushPayload() ", (Throwable)e);
        }
    }

    public void handlePushPayload(Context context, Intent intent) {
    }

    public void deleteToken(Context context, String senderId) {
    }

    public void offLoadToWorker(Context context, String extra) {
        PushUtils.offLoadTaskToWorker((Context)context, (String)extra);
    }

    public void logNotificationClicked(Context context, Intent intent) {
        this.getMessageListener().logNotificationClicked(context, intent);
    }

    public void setMessageListener(Object messageListener) {
        if (!(messageListener instanceof PushMessageListener)) {
            Logger.e((String)"PushHandlerImpl(firebase):Custom Listener does not extend PushMessageListener");
            return;
        }
        this.pushMessageListener = (PushMessageListener)messageListener;
    }

    public void setPushRegistrationFallback(Context context) {
        ConfigurationProvider provider = ConfigurationProvider.getInstance((Context)context);
        if (PushUtils.shouldRegisterForPush((Context)context) && TextUtils.isEmpty((CharSequence)provider.getGCMToken())) {
            PushUtils.schedulePushRegistration((Context)context, (int)2, (String)"PUSH_REG_FALLBACK");
        }
    }

    public PushMessageListener getMessageListener() {
        if (this.pushMessageListener == null) {
            this.pushMessageListener = new PushMessageListener();
        }
        return this.pushMessageListener;
    }

    public void handlePushPayload(Context context, Map<String, String> pushPayload) {
        Bundle bundle = MoEUtils.convertMapToBundle(pushPayload);
        if (bundle != null) {
            this.handlePushPayload(context, bundle);
        }
    }

    void onNewToken(Context context, String token) {
        if (!PushUtils.shouldRegisterForPush((Context)context)) {
            Logger.e((String)(TAG + " onNewToken() : Ignoring token as MoEngage is not registering for push"));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)token)) {
            Logger.e((String)(TAG + " onNewToken() : Generated token is empty, returning"));
            return;
        }
        PushManager.getInstance().refreshTokenInternal(context, token, "MoE");
    }

    static {
        TAG = "PushHandlerImpl(firebase)";
    }
}

