package com.moengage.firebase;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.push.PushManager;
import com.moengage.push.PushManager.PushHandler;
import com.moengage.pushbase.PushUtils;
import com.moengage.pushbase.push.MoEPushWorker;
import com.moengage.pushbase.push.MoEPushWorkerTask;
import com.moengage.pushbase.push.PushMessageListener;
import java.util.Map;

/**
 * @author Umang Chamaria
 */

public class PushHandlerImpl implements PushHandler {

  private PushMessageListener pushMessageListener;
  private static PushHandlerImpl _INSTANCE;

  private static String TAG = "PushHandlerImpl(firebase)";

  public PushHandlerImpl() {
    _INSTANCE = this;
  }

  public static PushHandlerImpl getInstance() {
    if (_INSTANCE == null) {
      new PushHandlerImpl();
    }
    return _INSTANCE;
  }

  @Override public String registerForPushToken(Context context) {
    ConfigurationProvider.getInstance(context).setDeviceRegistered(false);
    String token = getPushToken(context);
    if (token != null) return token;
    return null;
  }

  @Override @Nullable public String getPushToken(final Context context) {
    try {
      if (!PushUtils.shouldRegisterForPush(context)) return null;
      final String[] token = new String[1];
      token[0] = null;
      FirebaseInstanceId.getInstance()
          .getInstanceId()
          .addOnCompleteListener(new OnCompleteListener<InstanceIdResult>() {
            @Override public void onComplete(@NonNull Task<InstanceIdResult> task) {
              try {
                if (task.isSuccessful()) {
                  // Get new Instance ID token
                  token[0] = task.getResult().getToken();
                  if (!TextUtils.isEmpty(token[0])) {
                    PushManager.getInstance().refreshTokenInternal(context, token[0], PushManager.TOKEN_BY_MOE);
                  } else {
                    Logger.e(TAG + " onComplete() : getToken() API returned an empty token");
                  }
                } else {
                  Logger.e( TAG + " onComplete() : Task<InstanceIdResult> failed. ");
                  PushUtils.scheduleDeviceRegistrationCall(context);
                }
              } catch (Exception e) {
                Logger.e( TAG + " onComplete() : ", e);
              }
            }
          });
      return token[0];
    } catch (Exception e) {
      PushUtils.scheduleDeviceRegistrationCall(context);
      Logger.e("PushHandlerImpl(firebase):registerForPush ", e);
      MoEHelper.getInstance(context).getDelegate().logPushFailureEvent(context, e.getMessage());
    }
    return null;
  }

  @Override public void handlePushPayload(Context context, String pushPayload) {
    Logger.e("PushHandlerImpl(firebase):This method should only be called from the baidu module");
  }

  @Override public void handlePushPayload(Context context, Bundle extras) {
    try{
      if (null == extras) return;
      if (Looper.myLooper() == Looper.getMainLooper()) {
        MoEDispatcher.getInstance(context).addTaskToQueueBeginning(new MoEPushWorkerTask(context,
            PushManager.SHOW_NOTIFICATION, extras));
      } else {
        getMessageListener().onMessagereceived(context, extras);
      }
    } catch(Exception e){
      Logger.f("PushHandlerImpl(firebase): handlePushPayload() ",e);
    }
  }

  @Override public void handlePushPayload(Context context, Intent intent) {
    //not required anymore
  }

  @Override public void deleteToken(Context context, String senderId) {
/*    ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
    Logger.i("PushHandlerImpl(firebase):deleting token");
    try {
      if (senderId == null) {
        senderId = provider.getSenderIdIfAny();
      }
      //instanceID.deleteToken(senderId, GoogleCloudMessaging.INSTANCE_ID_SCOPE);
        *//*FirebaseInstanceId.getInstance().deleteToken(ConfigurationProvider.getInstance(context)
            .getGCMToken(), null);*//*
    } catch (Exception e) {
      Logger.e("PushHandlerImpl(firebase):delete GCM Token ", e);
    }
    provider.setGCMToken(null);*/
  }

  @Override public void offLoadToWorker(Context context, String extra) {
    PushUtils.offLoadTaskToWorker(context, extra);
  }

  @Override public void logNotificationClicked(Context context, Intent intent) {
    getMessageListener().logNotificationClicked(context, intent);
  }

  @Override public void setMessageListener(Object messageListener) {
    if (!(messageListener instanceof PushMessageListener)) {
      Logger.e("PushHandlerImpl(firebase):Custom Listener does not extend PushMessageListener");
      return;
    }
    this.pushMessageListener = (PushMessageListener) messageListener;
  }

  @Override public void setPushRegistrationFallback(Context context) {
    ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
    //this check is duplicated here as well as in MoEPushWorker. It is done to prevent useless
    // alarm from being set.
    if (PushUtils.shouldRegisterForPush(context) && TextUtils.isEmpty(provider.getGCMToken())) {
      PushUtils.schedulePushRegistration(context, 2, MoEPushWorker.PUSH_REG_FALLBACK);
    }
  }

  @Override public PushMessageListener getMessageListener() {
    if (pushMessageListener == null) {
      pushMessageListener = new PushMessageListener();
    }
    return pushMessageListener;
  }

  @Override public void handlePushPayload(Context context, Map<String, String> pushPayload) {
    Bundle bundle = MoEUtils.convertMapToBundle(pushPayload);
    if (bundle != null) handlePushPayload(context, bundle);
  }

  /**
   * This method is invoked whenever a new token is generated via callback from
   * {@link FirebaseMessagingService#onNewToken(String)}
   * @param context Application Context
   * @param token Push token
   */
  void onNewToken(Context context, String token){
    if (!PushUtils.shouldRegisterForPush(context)) {
      Logger.e( TAG + " onNewToken() : Ignoring token as MoEngage is not registering for push");
      return;
    }
    if (TextUtils.isEmpty(token)){
      Logger.e( TAG + " onNewToken() : Generated token is empty, returning");
      return;
    }
    PushManager.getInstance().refreshTokenInternal(context, token, PushManager.TOKEN_BY_MOE);
  }

}
