package com.moengage.firebase;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.moengage.core.Logger;
import com.moengage.push.PushManager;
import java.util.Map;

/**
 * Class for receiving Firebase Cloud Messaging.
 * @author Umang Chamaria
 */
public class MoEFireBaseMessagingService extends FirebaseMessagingService {

  @Override public void onMessageReceived(RemoteMessage remoteMessage) {
    try {
      if (remoteMessage == null){
        Logger.e("MoEFireBaseMessagingService:onMessageReceived : RemoteMessage Null");
        return;
      }
      Map<String, String> pushPayload = remoteMessage.getData();
      PushManager.getInstance().getPushHandler().handlePushPayload(getApplicationContext(), pushPayload);
    } catch (Exception e) {
      Logger.e( "MoEFireBaseMessagingService: onMessageReceived() : Exception ", e);
    }
  }

  @Override public void onNewToken(String token) {
    try {
      Logger.v( "MoEFireBaseMessagingService: onNewToken() : Push Token " + token);
      PushHandlerImpl.getInstance().onNewToken(getApplicationContext(), token);
    } catch (Exception e) {
      Logger.f(  "MoEFireBaseMessagingService: onNewToken() : Exception ", e);
    }
  }
}
