/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.geofence.internal.repository;

import androidx.annotation.Nullable;
import com.moe.pushlibrary.models.GeoLocation;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.rest.Response;
import com.moengage.geofence.internal.model.GeoCampaign;
import com.moengage.geofence.internal.model.GeofenceFetchResponse;
import com.moengage.geofence.internal.model.GeofenceHitResponse;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ResponseParser {
    private static final String TAG = "ResponseParser";
    private static final String DISTANCE = "distance";
    private static final String CAMPAIGN_ID = "cid";
    private static final String TRANSITION_TYPE = "transitionType";
    private static final String RESPONSIVENESS = "responsiveness_time";
    private static final String LATITUDE = "lat";
    private static final String LONGITUDE = "lng";
    private static final String GEOFENCE_ID = "geoId";
    private static final String LOITERING_DELAY = "ldelay";
    private static final String EXPIRY = "expiry";
    private static final String FENCES_INFO = "fencesInfo";
    static final String RESPONSE_ATTR_RESULT = "result";
    static final String RESULT_OK = "OK";

    GeofenceFetchResponse parseFetchResponse(Response response) {
        try {
            if (response == null) {
                return new GeofenceFetchResponse(false);
            }
            if (response.responseCode != 200) {
                return new GeofenceFetchResponse(false);
            }
            if (!this.isValidAPIResponse(response.responseBody)) {
                return new GeofenceFetchResponse(false);
            }
            JSONObject responseJson = new JSONObject(response.responseBody);
            JSONArray fenceInfo = responseJson.getJSONArray(FENCES_INFO);
            if (fenceInfo.length() == 0) {
                return new GeofenceFetchResponse(true, new ArrayList<GeoCampaign>());
            }
            ArrayList<GeoCampaign> campaignList = new ArrayList<GeoCampaign>();
            for (int i = 0; i < fenceInfo.length(); ++i) {
                JSONObject campaignJson = fenceInfo.getJSONObject(i);
                GeoCampaign campaign = this.campaignFromJson(campaignJson);
                if (campaign == null) continue;
                campaignList.add(campaign);
            }
            return new GeofenceFetchResponse(true, campaignList);
        }
        catch (Exception e) {
            Logger.e((String)"ResponseParser parseFetchResponse() : ", (Throwable)e);
            return new GeofenceFetchResponse(false);
        }
    }

    @Nullable
    GeoCampaign campaignFromJson(JSONObject campaignJson) {
        try {
            GeoCampaign campaign = new GeoCampaign(this.getTransitionTypeFromString(campaignJson.getString(TRANSITION_TYPE)), new GeoLocation(campaignJson.getDouble(LATITUDE), campaignJson.getDouble(LONGITUDE)), (float)campaignJson.getDouble(DISTANCE), campaignJson.optInt(EXPIRY, -1), campaignJson.optInt(LOITERING_DELAY, -1), campaignJson.optInt(RESPONSIVENESS), campaignJson.getString(GEOFENCE_ID), campaignJson.optString(CAMPAIGN_ID), campaignJson.getString(GEOFENCE_ID) + ":" + campaignJson.optString(CAMPAIGN_ID));
            if (campaign.transitionType == 4 && campaign.loiteringDelay == -1) {
                return null;
            }
            return campaign;
        }
        catch (Exception e) {
            Logger.e((String)"ResponseParser campaignFromJson() : ", (Throwable)e);
            return null;
        }
    }

    private int getTransitionTypeFromString(String transitionString) throws IllegalArgumentException {
        switch (transitionString) {
            case "enter": {
                return 1;
            }
            case "dwell": {
                return 4;
            }
            case "exit": {
                return 2;
            }
        }
        throw new IllegalArgumentException("Not a valid transition type");
    }

    boolean isValidAPIResponse(String response) throws JSONException {
        if (MoEUtils.isEmptyString((String)response)) {
            return false;
        }
        JSONObject jsonResponse = new JSONObject(response);
        String result = jsonResponse.getString(RESPONSE_ATTR_RESULT);
        return RESULT_OK.equals(result);
    }

    GeofenceHitResponse parseHitResponse(Response response) {
        try {
            if (response == null) {
                return new GeofenceHitResponse(false);
            }
            if (response.responseCode != 200) {
                return new GeofenceHitResponse(false);
            }
            return new GeofenceHitResponse(this.isValidAPIResponse(response.responseBody));
        }
        catch (Exception e) {
            Logger.e((String)"ResponseParser parseHitResponse() : ", (Throwable)e);
            return new GeofenceHitResponse(false);
        }
    }
}

