/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.geofence.internal.repository;

import com.moe.pushlibrary.models.GeoLocation;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.geofence.internal.model.GeoCampaign;
import com.moengage.geofence.internal.model.GeofenceFetchRequest;
import com.moengage.geofence.internal.model.GeofenceFetchResponse;
import com.moengage.geofence.internal.model.GeofenceHitRequest;
import com.moengage.geofence.internal.repository.LocalRepository;
import com.moengage.geofence.internal.repository.RemoteRepository;
import java.util.List;
import org.json.JSONException;

public class LocationRepository {
    private static final String TAG = "LocationRepository";
    private LocalRepository localRepository;
    private RemoteRepository remoteRepository;

    public LocationRepository(LocalRepository localRepository, RemoteRepository remoteRepository) {
        this.localRepository = localRepository;
        this.remoteRepository = remoteRepository;
    }

    public GeofenceFetchResponse fetchGeofence(GeoLocation lastKnownLocation, boolean isForeground) throws JSONException {
        GeofenceFetchRequest request = new GeofenceFetchRequest(this.localRepository.baseRequest(), lastKnownLocation, isForeground);
        GeofenceFetchResponse response = this.remoteRepository.fetchGeofence(request);
        Logger.v((String)("LocationRepository fetchGeofence() : Api response: " + response));
        if (!response.isSuccess) {
            return response;
        }
        this.localRepository.saveLastSyncTime(MoEUtils.currentMillis());
        return response;
    }

    public void geofenceHit(GeoLocation triggeringLocation, String geoId, String transitionType, boolean isForeground) {
        try {
            GeofenceHitRequest request = new GeofenceHitRequest(this.localRepository.baseRequest(), isForeground, triggeringLocation, transitionType, geoId, this.localRepository.getPushId());
            this.remoteRepository.geofenceHit(request);
        }
        catch (Exception e) {
            Logger.e((String)"LocationRepository geofenceHit() : ", (Throwable)e);
        }
    }

    public List<String> getSavedGeoIds() {
        return this.localRepository.getSavedGeoIds();
    }

    public long getLastSyncTime() {
        return this.localRepository.getLastSyncTime();
    }

    public void saveLocation(GeoLocation geoLocation) {
        this.localRepository.saveLocation(geoLocation);
    }

    public GeoLocation getLastLocation() {
        return this.localRepository.getSavedLocation();
    }

    public void saveRequestIdList(List<GeoCampaign> campaignList) {
        if (campaignList == null || campaignList.isEmpty()) {
            return;
        }
        this.localRepository.saveRequestIdList(campaignList);
    }
}

