/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.geofence.internal.repository;

import android.content.Context;
import com.moe.pushlibrary.models.GeoLocation;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.MoEUtils;
import com.moengage.core.RestUtils;
import com.moengage.core.model.BaseRequest;
import com.moengage.geofence.internal.model.GeoCampaign;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;

public class LocalRepository {
    private Context context;

    public LocalRepository(Context context) {
        this.context = context;
    }

    void saveLastSyncTime(long lastSyncTime) {
        ConfigurationProvider.getInstance((Context)this.context).setLastGeoFenceSyncTime(lastSyncTime);
    }

    void saveLocation(GeoLocation geoLocation) {
        ConfigurationProvider.getInstance((Context)this.context).saveLocation(geoLocation);
    }

    void saveRequestIdList(List<GeoCampaign> geofenceMetaList) {
        StringBuilder geoIDBuilder = new StringBuilder();
        int size = geofenceMetaList.size();
        for (int index = 0; index < size; ++index) {
            GeoCampaign meta = geofenceMetaList.get(index);
            geoIDBuilder.append(meta.requestId);
            geoIDBuilder.append(";");
        }
        ConfigurationProvider.getInstance((Context)this.context).saveGeoIDList(geoIDBuilder.toString());
    }

    BaseRequest baseRequest() throws JSONException {
        return RestUtils.getBaseRequest((Context)this.context);
    }

    List<String> getSavedGeoIds() {
        String geoList = ConfigurationProvider.getInstance((Context)this.context).getGeoIDList();
        ArrayList<String> oldGeoFenceList = null;
        if (MoEUtils.isEmptyString((String)geoList)) {
            return new ArrayList<String>();
        }
        if (geoList.contains(";")) {
            String[] geoIds = geoList.split(";");
            oldGeoFenceList = Arrays.asList(geoIds);
        } else {
            oldGeoFenceList = new ArrayList<String>();
            oldGeoFenceList.add(geoList);
        }
        return oldGeoFenceList;
    }

    String getPushId() {
        return ConfigurationProvider.getInstance((Context)this.context).getFcmToken();
    }

    long getLastSyncTime() {
        return ConfigurationProvider.getInstance((Context)this.context).getLastGeoFenceSyncTime();
    }

    GeoLocation getSavedLocation() {
        return ConfigurationProvider.getInstance((Context)this.context).getSavedLocation();
    }
}

