/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.geofence.internal.repository;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.RestUtils;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.rest.Response;
import com.moengage.core.rest.RestClient;
import com.moengage.core.utils.JsonBuilder;
import com.moengage.geofence.internal.model.GeofenceFetchRequest;
import com.moengage.geofence.internal.model.GeofenceHitRequest;
import org.json.JSONObject;

public class ApiManager {
    private static final String TAG = "Geofence_ApiManager";
    private static final String GEOFENCE_FETCH = "v1/geoFences";
    private static final String GEOFENCE_HIT = "v1/geoFenceHit";
    private static final String LATITUDE = "lat";
    private static final String LONGITUDE = "lng";
    private static final String IS_FOREGROUND = "isForeground";
    private static final String CURRENT_LATITUDE = "curr_lat";
    private static final String CURRENT_LONGITUDE = "curr_long";
    private static final String GEO_ID = "geoIds";
    private static final String PUSH_ID = "push_id";
    private static final String TRANSITION_TYPE = "transitionType";

    @Nullable
    Response fetchGeofence(GeofenceFetchRequest request) {
        try {
            Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath(GEOFENCE_FETCH);
            RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder((Uri)uriBuilder.build(), (RequestBuilder.RequestType)RequestBuilder.RequestType.POST, (String)request.appId);
            JsonBuilder requestParams = request.defaultParams;
            requestParams.putString(LATITUDE, String.valueOf(request.location.latitude)).putString(LONGITUDE, String.valueOf(request.location.longitude)).putBoolean(IS_FOREGROUND, request.isForeground);
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("query_params", (Object)requestParams.build());
            requestBuilder.addBody(jsonBody);
            return new RestClient(requestBuilder.build()).executeRequest();
        }
        catch (Exception e) {
            Logger.e((String)"Geofence_ApiManager fetchGeofence() : ", (Throwable)e);
            return null;
        }
    }

    @Nullable
    Response geofenceHit(GeofenceHitRequest request) {
        try {
            Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath(GEOFENCE_HIT);
            RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder((Uri)uriBuilder.build(), (RequestBuilder.RequestType)RequestBuilder.RequestType.POST, (String)request.appId);
            JsonBuilder requestParams = request.defaultParams;
            requestParams.putString(CURRENT_LATITUDE, String.valueOf(request.triggeringLocation.latitude)).putString(CURRENT_LONGITUDE, String.valueOf(request.triggeringLocation.longitude)).putString(GEO_ID, request.geoId).putBoolean(IS_FOREGROUND, request.isForeground).putString(TRANSITION_TYPE, request.transitionType).putString(PUSH_ID, request.pushId);
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("query_params", (Object)requestParams.build());
            requestBuilder.addBody(jsonBody);
            return new RestClient(requestBuilder.build()).executeRequest();
        }
        catch (Exception e) {
            Logger.e((String)"Geofence_ApiManager geofenceHit() : ", (Throwable)e);
            return null;
        }
    }
}

