/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.geofence.internal;

import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofenceStatusCodes;
import com.google.android.gms.location.GeofencingEvent;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.models.GeoLocation;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.Properties;
import com.moengage.core.SdkConfig;
import com.moengage.core.executor.ITask;
import com.moengage.core.model.MoEJobParameters;
import com.moengage.geofence.MoEGeofenceHelper;
import com.moengage.geofence.internal.CampaignSyncAlarm;
import com.moengage.geofence.internal.CampaignSyncJob;
import com.moengage.geofence.internal.GeoFenceBroadcastReceiver;
import com.moengage.geofence.internal.GeofenceFetchTask;
import com.moengage.geofence.internal.LocationInjector;
import com.moengage.geofence.internal.model.GeoCampaign;
import com.moengage.geofence.internal.repository.LocationRepository;
import com.moengage.geofence.listener.OnGeofenceHitListener;
import java.util.ArrayList;
import java.util.List;

public class LocationController {
    private static final String TAG = "Geofence_LocationController";
    public boolean isSynced;
    private Context context;
    private static LocationController instance;

    private LocationController(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocationController getInstance(Context context) {
        if (instance != null) return instance;
        Class<LocationController> clazz = LocationController.class;
        synchronized (LocationController.class) {
            if (instance != null) return instance;
            instance = new LocationController(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    void setSynced(boolean synced) {
        this.isSynced = synced;
    }

    void setGeofence(Context context, List<GeoCampaign> campaignList) {
        try {
            Geofence.Builder builder;
            if (campaignList.isEmpty()) {
                return;
            }
            ArrayList<Geofence> geofenceList = new ArrayList<Geofence>(campaignList.size());
            for (GeoCampaign campaign : campaignList) {
                builder = new Geofence.Builder();
                builder.setCircularRegion(campaign.location.latitude, campaign.location.longitude, campaign.radius).setRequestId(campaign.requestId).setTransitionTypes(campaign.transitionType);
                builder.setExpirationDuration(campaign.expiryDuration);
                if (campaign.loiteringDelay != -1) {
                    builder.setLoiteringDelay(campaign.loiteringDelay);
                }
                if (campaign.responsiveness != -1) {
                    builder.setNotificationResponsiveness(campaign.responsiveness);
                }
                geofenceList.add(builder.build());
            }
            this.removeGeofence();
            Intent intent = new Intent(context, GeoFenceBroadcastReceiver.class);
            PendingIntent geoPending = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0x8000000);
            builder = new GeofencingRequest.Builder();
            builder.addGeofences(geofenceList).setInitialTrigger(5);
            LocationServices.getGeofencingClient((Context)context).addGeofences(builder.build(), geoPending).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

                public void onSuccess(Void aVoid) {
                    Logger.v((String)"Geofence_LocationController onSuccess() : Fences set successfully.");
                }
            }).addOnFailureListener(new OnFailureListener(){

                public void onFailure(@NonNull Exception e) {
                    Logger.v((String)"Geofence_LocationController onFailure() : Fences could not be set.");
                }
            });
        }
        catch (Exception e) {
            Logger.e((String)"Geofence_LocationController setGeofences() : ", (Throwable)e);
        }
    }

    boolean hasRequiredPermission(Context context) {
        return MoEHelperUtils.hasPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") || MoEHelperUtils.hasPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION");
    }

    public void removeGeofence() {
        List<String> existingFenceIdList = LocationInjector.getInstance().getRepository(this.context).getSavedGeoIds();
        if (existingFenceIdList == null || existingFenceIdList.isEmpty()) {
            return;
        }
        LocationServices.getGeofencingClient((Context)this.context).removeGeofences(existingFenceIdList);
    }

    void updateFenceAndLocation(MoEJobParameters jobParameters) {
        Logger.v((String)"Geofence_LocationController updateFenceAndLocation() : Will try to update fence and location");
        if (!this.hasRequiredPermission(this.context)) {
            Logger.v((String)"Geofence_LocationController updateFenceAndLocation() : App does not have location permission cannot fetch location");
            return;
        }
        this.triggerLocationFetch(this.context, jobParameters);
    }

    @SuppressLint(value={"MissingPermission"})
    void scheduleGeofenceFetchIfRequired() {
        Logger.v((String)"Geofence_LocationController scheduleGeofenceFetchIfRequired() : ");
        if (!SdkConfig.getConfig().isGeofenceBackgroundSyncEnabled) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            JobScheduler jobScheduler;
            ComponentName serviceComponent = new ComponentName(this.context, CampaignSyncJob.class);
            JobInfo.Builder builder = new JobInfo.Builder(500006, serviceComponent);
            builder.setOverrideDeadline(MoEUtils.currentMillis() + 10800000L + 3600000L);
            builder.setMinimumLatency(10800000L);
            builder.setRequiredNetworkType(1);
            if (MoEHelperUtils.hasPermission((Context)this.context, (String)"android.permission.RECEIVE_BOOT_COMPLETED")) {
                builder.setPersisted(true);
            }
            if ((jobScheduler = (JobScheduler)this.context.getSystemService("jobscheduler")) != null) {
                jobScheduler.schedule(builder.build());
            }
        } else {
            Intent alarmIntent = new Intent(this.context, CampaignSyncAlarm.class);
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)500007, (Intent)alarmIntent, (int)0x8000000);
            AlarmManager alarmManager = (AlarmManager)this.context.getSystemService("alarm");
            if (alarmManager != null) {
                alarmManager.set(0, MoEUtils.currentMillis() + 10800000L, pendingIntent);
            }
        }
    }

    private void triggerLocationFetch(Context context, final MoEJobParameters jobParameters) {
        Logger.v((String)"Geofence_LocationController triggerLocationFetch() : Fetching last known location.");
        FusedLocationProviderClient client = LocationServices.getFusedLocationProviderClient((Context)context);
        client.getLastLocation().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Location>(){

            public void onComplete(@NonNull Task<Location> task) {
                try {
                    Logger.v((String)"Geofence_LocationController onComplete() : Location fetch completed.");
                    if (task == null) {
                        return;
                    }
                    GeoLocation geoLocation = new GeoLocation(0.0, 0.0);
                    Location lastLocation = (Location)task.getResult();
                    if (lastLocation != null) {
                        geoLocation.latitude = lastLocation.getLatitude();
                        geoLocation.longitude = lastLocation.getLongitude();
                    }
                    Logger.v((String)("Geofence_LocationController onComplete() : Location: " + geoLocation));
                    LocationController.this.updateLastKnownLocation(geoLocation);
                    LocationController.this.updateFencesIfRequired(geoLocation, jobParameters);
                }
                catch (Exception e) {
                    Logger.e((String)"Geofence_LocationController onComplete() : ", (Throwable)e);
                }
            }
        });
    }

    private void updateFencesIfRequired(GeoLocation location, MoEJobParameters jobParameters) {
        if (!SdkConfig.getConfig().isGeofenceTrackingOptedOut) {
            MoEDispatcher.getInstance((Context)this.context).startTask((ITask)new GeofenceFetchTask(this.context, location, jobParameters));
        }
    }

    private void updateLastKnownLocation(GeoLocation geoLocation) {
        if (SdkConfig.getConfig().isLocationTrackingOptedOut) {
            return;
        }
        LocationRepository repository = LocationInjector.getInstance().getRepository(this.context);
        GeoLocation storedLocation = repository.getLastLocation();
        if (!geoLocation.equals((Object)storedLocation)) {
            repository.saveLocation(geoLocation);
            MoEHelper.getInstance((Context)this.context).setUserAttribute("last_known_location", geoLocation);
        }
    }

    void onGeofenceHit(Intent geoFenceIntent) {
        try {
            if (geoFenceIntent == null) {
                return;
            }
            GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)geoFenceIntent);
            if (geofencingEvent.hasError()) {
                Logger.v((String)("Geofence_LocationController onGeofenceHit() : Received geofence transition intent has error.Error: " + GeofenceStatusCodes.getStatusCodeString((int)geofencingEvent.getErrorCode())));
                return;
            }
            OnGeofenceHitListener listener = MoEGeofenceHelper.getInstance().getListener();
            if (listener != null && listener.geofenceHit(geoFenceIntent)) {
                Logger.v((String)"Geofence_LocationController geoFenceHitInternal() : Geo-fence hit consumed by the client. SDK will not process hit intent.");
                return;
            }
            Logger.v((String)("Geofence_LocationController onGeofenceHit() : Trigger Fences: " + geofencingEvent.getTriggeringGeofences()));
            List triggeringGeoFences = geofencingEvent.getTriggeringGeofences();
            Location location = geofencingEvent.getTriggeringLocation();
            GeoLocation triggeringLocation = new GeoLocation(location.getLatitude(), location.getLongitude());
            if (triggeringGeoFences == null || triggeringGeoFences.isEmpty()) {
                return;
            }
            String transitionType = this.getTransitionString(geofencingEvent.getGeofenceTransition());
            for (Geofence fence : triggeringGeoFences) {
                Logger.v((String)("Geofence_LocationController onGeofenceHit() : Processing Fence: " + fence));
                LocationInjector.getInstance().getRepository(this.context).geofenceHit(triggeringLocation, this.getGeoIdFromRequestId(fence.getRequestId()), transitionType, MoEHelper.isAppInForeground());
                this.trackGeoFenceHitEvent(this.context, transitionType, fence, triggeringLocation);
            }
        }
        catch (Exception e) {
            Logger.e((String)"Geofence_LocationController onGeofenceHit() : ", (Throwable)e);
        }
    }

    private void trackGeoFenceHitEvent(Context context, String transitionType, Geofence fence, GeoLocation lastLocation) {
        String geoId;
        Properties attributes = new Properties();
        String campaignId = this.getCampaignIdFromRequestId(fence.getRequestId());
        if (TextUtils.isEmpty((CharSequence)campaignId)) {
            return;
        }
        attributes.addAttribute("campaign_id", (Object)campaignId);
        attributes.addAttribute("trigger_location", (Object)lastLocation);
        if (!TextUtils.isEmpty((CharSequence)transitionType)) {
            attributes.addAttribute("transition_type", (Object)transitionType);
        }
        if (!TextUtils.isEmpty((CharSequence)(geoId = this.getGeoIdFromRequestId(fence.getRequestId())))) {
            attributes.addAttribute("geo_id", (Object)geoId);
        }
        attributes.setNonInteractive();
        MoEHelper.getInstance((Context)context).trackEvent(MoEHelperConstants.EVENT_GEO_FENCE_HIT, attributes);
    }

    @Nullable
    private String getGeoIdFromRequestId(String requestId) {
        if (MoEUtils.isEmptyString((String)requestId)) {
            return null;
        }
        if (!requestId.contains(":")) {
            return requestId;
        }
        String[] splitString = requestId.split(":");
        if (splitString != null) {
            return splitString[0];
        }
        return null;
    }

    @Nullable
    private String getCampaignIdFromRequestId(String requestId) {
        String[] splitString;
        if (MoEUtils.isEmptyString((String)requestId)) {
            return null;
        }
        if (requestId.contains(":") && (splitString = requestId.split(":")) != null && splitString.length != 0) {
            return splitString[splitString.length - 1];
        }
        return null;
    }

    @Nullable
    private String getTransitionString(int geoFenceTransition) {
        switch (geoFenceTransition) {
            case 1: {
                return "enter";
            }
            case 4: {
                return "dwell";
            }
            case 2: {
                return "exit";
            }
        }
        return null;
    }

    void syncFencesAndScheduleFetch(MoEJobParameters jobParameters) {
        if (SdkConfig.getConfig().isBackgroundLocationFetchEnabled) {
            this.updateFenceAndLocation(jobParameters);
        } else {
            this.updateFencesIfRequired(LocationInjector.getInstance().getRepository(this.context).getLastLocation(), jobParameters);
        }
        this.scheduleGeofenceFetchIfRequired();
    }

    void syncFencesAndScheduleFetch() {
        this.syncFencesAndScheduleFetch(null);
    }
}

