/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.geofence.internal;

import android.content.Context;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.models.GeoLocation;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.MoEJobParameters;
import com.moengage.geofence.internal.LocationController;
import com.moengage.geofence.internal.LocationEvaluator;
import com.moengage.geofence.internal.LocationInjector;
import com.moengage.geofence.internal.model.GeofenceFetchResponse;
import com.moengage.geofence.internal.repository.LocationRepository;

public class GeofenceFetchTask
extends SDKTask {
    private static final String TAG = "Geofence_GeofenceFetchTask";
    private GeoLocation currentLocation;
    private MoEJobParameters jobParameters;

    GeofenceFetchTask(Context context, GeoLocation currentLocation) {
        this(context, currentLocation, null);
    }

    GeofenceFetchTask(Context context, GeoLocation location, MoEJobParameters jobParameters) {
        super(context);
        this.currentLocation = location;
        this.jobParameters = jobParameters;
    }

    public TaskResult execute() {
        try {
            Logger.v((String)"Geofence_GeofenceFetchTask execute() : Executing geofence fetch");
            LocationRepository repository = LocationInjector.getInstance().getRepository(this.context);
            if (!new LocationEvaluator().isSyncRequired(LocationController.getInstance((Context)this.context).isSynced, repository.getLastSyncTime(), MoEUtils.currentMillis())) {
                Logger.v((String)"Geofence_GeofenceFetchTask execute() : Geofence sync not required.");
                return this.taskResult;
            }
            GeofenceFetchResponse response = repository.fetchGeofence(this.currentLocation, MoEHelper.isAppInForeground());
            if (!response.isSuccess) {
                return this.taskResult;
            }
            this.taskResult.setIsSuccess(true);
            LocationController.getInstance(this.context).setGeofence(this.context, response.campaignList);
            LocationController.getInstance(this.context).setSynced(true);
            repository.saveRequestIdList(response.campaignList);
            if (this.jobParameters != null) {
                this.jobParameters.jobCompleteListener.jobComplete(this.jobParameters);
            }
        }
        catch (Exception e) {
            Logger.e((String)"Geofence_GeofenceFetchTask execute() : ", (Throwable)e);
        }
        Logger.v((String)"Geofence_GeofenceFetchTask execute() : Completed fetch");
        return this.taskResult;
    }

    public String getTaskTag() {
        return "GEOFENCE_FETCH";
    }

    public boolean isSynchronous() {
        return true;
    }
}

