package com.moengage.geofence.listener;

import android.content.Intent;

/**
 * Interface definition for a callback which is invoked whenever a Geo-fence condition is met.
 *
 * @author Umang Chamaria
 * Date: 2019-07-03
 */
public interface OnGeofenceHitListener {
  /**
   * Called whenever a Geo-fence condition is met.
   *
   * @param geoFenceHit Intent received from google's location services
   * @return true if the app wants to consume the hit and don't want MoEngage SDK to take any
   * action on this hit, else false
   */
  boolean geofenceHit(Intent geoFenceHit);
}