/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.geofence.internal;

/**
 * @author Umang Chamaria
 */
public interface LocationConstants {

  /**
   * Geo fence Transition type is exit
   */
  String TRANSITION_EXIT = "exit";
  /**
   * Geo fence Transition type is enter
   */
  String TRANSITION_ENTER = "enter";
  /**
   * Geo fence Transition type is enter
   */
  String TRANSITION_DWELL = "dwell";

  String EVENT_ATTRIBUTE_GEO_ID = "geo_id";

  String EVENT_ATTRIBUTE_CAMPAIGN_ID = "campaign_id";

  String EVENT_ATTRIBUTE_TRANSITION_TYPE = "transition_type";

  String EVENT_ATTRIBUTE_TRIGGER_LOCATION = "trigger_location";

  String GEO_ID_SEPARATOR = ":";

  long SYNC_DELAY = 900000;

  long BACKGROUND_SYNC_DELAY = 10800000L;

  String MODULE_TAG = "Geofence_";
  /**
   * Unique identifier for sync job
   */
  int CAMPAIGN_SYNC_JOB_ID = 500006;
  /**
   * Unique identifier for sync alarm
   */
  int CAMPAIGN_SYNC_ALARM_ID = 500007;
}
