package com.moengage.geofence;

import androidx.annotation.Nullable;
import com.moengage.geofence.listener.OnGeofenceHitListener;

/**
 * Helper class for interaction with MoEngage's Location Module.
 * @author Umang Chamaria
 * Date: 2019-07-03
 */
public class MoEGeofenceHelper {

  private static MoEGeofenceHelper instance;

  private OnGeofenceHitListener listener;

  public static MoEGeofenceHelper getInstance(){
    if (instance == null){
      synchronized (MoEGeofenceHelper.class){
        if (instance == null) instance = new MoEGeofenceHelper();
      }
    }
    return instance;
  }

  /**
   * Register a listener to receive a callback for geofence hit.
   * @param listener instance of {@link OnGeofenceHitListener}
   */
  public void registerGeofenceHitListener(OnGeofenceHitListener listener){
    this.listener = listener;
  }

  public void unregisterGeofenceHitListener(){
    listener = null;
  }


  @Nullable public OnGeofenceHitListener getListener(){
    return listener;
  }

}