/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.locationlibrary;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofenceStatusCodes;
import com.google.android.gms.location.GeofencingClient;
import com.google.android.gms.location.GeofencingEvent;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.PayloadBuilder;
import com.moe.pushlibrary.models.GeoLocation;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.GeoTask;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEEventManager;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.ITask;
import com.moengage.location.GeoManager;
import com.moengage.locationlibrary.GeofenceIntentService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationHandlerImpl
implements GeoManager.LocationHandler,
OnCompleteListener<Location> {
    private Context context;
    private int mode = -1;
    private GeoLocation geoLocation;
    private String geoResponse;
    private Intent geoFenceIntent;
    boolean isLocationSynced = false;
    private static final int SET_GEO_FENCE = 1;
    private static final int GEO_HIT = 2;
    private static final int UPDATE_FENCE = 3;

    public void setGeoFences(@NonNull Context context, String response) {
        Logger.v((String)"LocationHandlerImpl: inside setGeoFences()");
        this.context = context;
        this.mode = 1;
        this.geoResponse = response;
        this.setGeoFenceInternal();
    }

    public void onGeoFenceHit(@NonNull Context context, Intent intent) {
        Logger.v((String)"LocationHandlerImpl: inside onGeoFenceHit()");
        this.context = context;
        this.mode = 2;
        this.geoFenceIntent = intent;
        this.triggerLastLocationFetch();
    }

    public void updateFenceAndLocation(@NonNull Context context) {
        Logger.v((String)"LocationHandlerImpl: inside updateFenceAndLocation()");
        this.context = context;
        this.mode = 3;
        if (!(!this.isSyncRequired(context) || ConfigurationProvider.getInstance((Context)context).isTrackLocationProhibited() && ConfigurationProvider.getInstance((Context)context).isSetGeoFenceProhibited())) {
            this.triggerLastLocationFetch();
        }
    }

    public void removeGeoFences(Context context) {
        this.context = context;
        this.removeGeoFencesInternal();
    }

    private GeofencingClient getGeoFencingClient() {
        return LocationServices.getGeofencingClient((Context)this.context);
    }

    private void triggerLastLocationFetch() {
        try {
            if (MoEHelperUtils.hasPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") || MoEHelperUtils.hasPermission((Context)this.context, (String)"android.permission.ACCESS_COARSE_LOCATION")) {
                FusedLocationProviderClient client = LocationServices.getFusedLocationProviderClient((Context)this.context);
                client.getLastLocation().addOnCompleteListener((OnCompleteListener)this);
            }
        }
        catch (Exception e) {
            Logger.f((String)"LocationHandlerImpl: triggerLastLocationFetch() ", (Throwable)e);
        }
    }

    public void onComplete(@NonNull Task<Location> task) {
        try {
            if (task != null) {
                Location lastLocation = (Location)task.getResult();
                this.geoLocation = lastLocation != null ? new GeoLocation(lastLocation.getLatitude(), lastLocation.getLongitude()) : new GeoLocation(0.0, 0.0);
                switch (this.mode) {
                    case 1: {
                        this.setGeoFenceInternal();
                        break;
                    }
                    case 2: {
                        this.geoFenceHitInternal();
                        break;
                    }
                    case 3: {
                        this.updateFenceAndLocationInternal();
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.f((String)"LocationHandlerImpl: onComplete()", (Throwable)e);
        }
    }

    private void geoFenceHitInternal() {
        try {
            if (this.geoFenceIntent == null) {
                return;
            }
            GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)this.geoFenceIntent);
            if (geofencingEvent == null) {
                Logger.e((String)"LocationHandlerImpl : Null geo fence transition event");
                return;
            }
            if (geofencingEvent.hasError()) {
                Logger.e((String)("LocationHandlerImpl : Received geo fence transition intent with error" + GeofenceStatusCodes.getStatusCodeString((int)geofencingEvent.getErrorCode())));
                return;
            }
            Logger.v((String)("LocationHandlerImpl geoFenceHitInternal() triggering Fence :" + geofencingEvent.getTriggeringGeofences().toString()));
            Logger.v((String)("LocationHandlerImpl geoFenceHitInternal() transition: " + geofencingEvent.getGeofenceTransition()));
            Logger.v((String)"LocationHandlerImpl geoFenceHitInternal() : Received geo fence transition intent");
            int geoFenceTransition = geofencingEvent.getGeofenceTransition();
            if (geoFenceTransition == 1 || geoFenceTransition == 2 || geoFenceTransition == 4) {
                List triggeringGeoFences = geofencingEvent.getTriggeringGeofences();
                if (triggeringGeoFences != null && !triggeringGeoFences.isEmpty()) {
                    Logger.v((String)("LocationHandlerImpl : geoFenceHitInternal() received geo fences count: " + triggeringGeoFences.size()));
                    for (Geofence fence : triggeringGeoFences) {
                        Logger.v((String)("LocationHandlerImpl : geoFenceHitInternal() registering geo fencing hit for GeoId: " + fence.getRequestId()));
                        HashMap<String, String> paramsMap = this.buildRequestParams(geoFenceTransition, fence, this.geoLocation);
                        GeoTask geoFenceHitTask = new GeoTask(this.context, MoEUtils.getAPIRoute((Context)this.context) + "/v1/geoFenceHit", paramsMap, GeoManager.TASK_TYPE.GEOFENCE_HIT);
                        MoEDispatcher.getInstance((Context)this.context).addTaskToQueue((ITask)geoFenceHitTask);
                        this.trackGeoFenceHitEvent(geoFenceTransition, fence, this.geoLocation);
                    }
                }
            } else {
                Logger.e((String)("LocationHandlerImpl : geoFenceHitInternal() : Transition type was not in our interest: " + geoFenceTransition));
            }
        }
        catch (Exception e) {
            Logger.f((String)"LocationHandlerImpl : geoFenceHitInternal()", (Throwable)e);
        }
    }

    private void setGeoFenceInternal() {
        try {
            ArrayList<Geofence> tFences = this.parseGeoFences();
            if (tFences != null && !tFences.isEmpty()) {
                this.removeGeoFencesInternal();
                if (tFences.isEmpty()) {
                    Logger.v((String)"LocationHandlerImpl: setGeoFenceInternal(): No new geo fences found");
                    return;
                }
                StringBuilder geoIDBuilder = new StringBuilder();
                int size = tFences.size();
                for (int index = 0; index < size; ++index) {
                    Geofence fence = tFences.get(index);
                    geoIDBuilder.append(fence.getRequestId());
                    if (index >= size - 2) continue;
                    geoIDBuilder.append(";");
                }
                ConfigurationProvider.getInstance((Context)this.context).saveGeoIDList(geoIDBuilder.toString());
                Intent intent = new Intent(this.context, GeofenceIntentService.class);
                PendingIntent geoPending = PendingIntent.getService((Context)this.context, (int)0, (Intent)intent, (int)0x8000000);
                GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
                builder.addGeofences(tFences);
                try {
                    this.getGeoFencingClient().addGeofences(builder.build(), geoPending);
                }
                catch (Exception e) {
                    Logger.f((String)"LocationHandlerImpl: setGeoFenceInternal()", (Throwable)e);
                }
            } else {
                Logger.v((String)"LocationHandlerImpl: setGeoFenceInternal(): no fences to set");
            }
        }
        catch (Exception e) {
            Logger.f((String)"LocationHandlerImpl: setGeoFenceInternal() ", (Throwable)e);
        }
    }

    private void updateFenceAndLocationInternal() {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (!ConfigurationProvider.getInstance((Context)this.context).isTrackLocationProhibited()) {
            this.updateLastKnownLocation();
        }
        if (!ConfigurationProvider.getInstance((Context)this.context).isSetGeoFenceProhibited()) {
            GeoLocation geoLocation = ConfigurationProvider.getInstance((Context)this.context).getLastKnownUserLocation();
            if (geoLocation == null) {
                geoLocation = new GeoLocation(0.0, 0.0);
            }
            paramsMap.put("lat", Double.toString(geoLocation.latitude));
            paramsMap.put("lng", Double.toString(geoLocation.longitude));
            MoEDispatcher.getInstance((Context)this.context).addTaskToQueue((ITask)new GeoTask(this.context, MoEUtils.getAPIRoute((Context)this.context) + "/v1/geoFences", paramsMap, GeoManager.TASK_TYPE.GET_GEOFENCE));
        }
        this.isLocationSynced = true;
    }

    private void updateLastKnownLocation() {
        Logger.v((String)"LocationHandlerImpl: inside updateLastKnownLocation()");
        GeoLocation storedLocation = ConfigurationProvider.getInstance((Context)this.context).getLastKnownUserLocation();
        if (!this.geoLocation.equals((Object)storedLocation)) {
            ConfigurationProvider.getInstance((Context)this.context).storeLastKnownLocation(this.geoLocation);
            MoEHelper.getInstance((Context)this.context).setUserAttribute("last_known_location", this.geoLocation);
        }
    }

    private ArrayList<Geofence> parseGeoFences() {
        if (!TextUtils.isEmpty((CharSequence)this.geoResponse)) {
            try {
                JSONObject jsonResponse = new JSONObject(this.geoResponse);
                JSONArray jsonPlaces = jsonResponse.getJSONArray("fencesInfo");
                int placesLength = jsonPlaces.length();
                ArrayList<Geofence> newFences = new ArrayList<Geofence>(placesLength);
                for (int i = 0; i < placesLength; ++i) {
                    try {
                        JSONObject jsonFence = jsonPlaces.getJSONObject(i);
                        String reqTransition = jsonFence.getString("transitionType");
                        if (TextUtils.isEmpty((CharSequence)reqTransition)) continue;
                        int transitionType = 1;
                        if (reqTransition.equals("exit")) {
                            transitionType = 2;
                        } else if (reqTransition.equals("dwell")) {
                            transitionType = 4;
                        }
                        Geofence.Builder builder = new Geofence.Builder().setRequestId(this.getGeoId(jsonFence)).setCircularRegion(jsonFence.getDouble("lat"), jsonFence.getDouble("lng"), (float)jsonFence.getDouble("distance")).setExpirationDuration(-1L).setTransitionTypes(transitionType);
                        if (jsonFence.has("ldelay")) {
                            builder.setLoiteringDelay(Integer.parseInt(jsonFence.getString("ldelay")));
                        }
                        if (jsonFence.has("expiry")) {
                            builder.setExpirationDuration(Long.parseLong(jsonFence.getString("expiry")));
                        }
                        if (jsonFence.has("responsiveness_time")) {
                            builder.setNotificationResponsiveness(jsonFence.getInt("responsiveness_time"));
                        }
                        newFences.add(builder.build());
                        continue;
                    }
                    catch (Exception e) {
                        Logger.f((String)"Location: parseFencesInfo() - INNER", (Throwable)e);
                    }
                }
                return newFences;
            }
            catch (Exception e) {
                Logger.f((String)"LocationHandlerImpl: parseFencesInfo()", (Throwable)e);
            }
        }
        return null;
    }

    private HashMap<String, String> buildRequestParams(int geoFenceTransition, Geofence fence, GeoLocation lastLocation) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        String transitionType = this.getTransitionString(geoFenceTransition);
        if (!TextUtils.isEmpty((CharSequence)transitionType)) {
            paramsMap.put("transitionType", transitionType);
        }
        if (lastLocation != null) {
            paramsMap.put("curr_lat", String.valueOf(lastLocation.latitude));
            paramsMap.put("curr_long", String.valueOf(lastLocation.longitude));
        }
        paramsMap.put("geoIds", this.getGeoIdFromRequestId(fence.getRequestId()));
        return paramsMap;
    }

    @Nullable
    private List<String> getSavedGeoIds() {
        String geoList = ConfigurationProvider.getInstance((Context)this.context).getGeoIDList();
        Logger.v((String)("LocationHandlerImpl: setGeoFenceInternal(): Existing fences: " + geoList));
        List<String> oldGeoFenceList = null;
        if (!TextUtils.isEmpty((CharSequence)geoList)) {
            if (geoList.contains(";")) {
                String[] geoIds = geoList.split(";");
                oldGeoFenceList = Arrays.asList(geoIds);
            } else {
                oldGeoFenceList = new ArrayList<String>();
                oldGeoFenceList.add(geoList);
            }
        }
        return oldGeoFenceList;
    }

    private boolean isSyncRequired(Context context) {
        long nextUpdate = ConfigurationProvider.getInstance((Context)context).getLastGeoFenceSyncTime() + 900000L;
        long currentTime = MoEUtils.currentTime();
        Logger.v((String)("Location: isSyncRequired: Next server sync will happen in " + (nextUpdate - currentTime) / 1000L + " seconds"));
        return !this.isLocationSynced || nextUpdate < currentTime;
    }

    private String getGeoId(JSONObject jsonFence) throws JSONException {
        String campaignId;
        String geoId = jsonFence.getString("geoId");
        if (jsonFence.has("cid") && !TextUtils.isEmpty((CharSequence)(campaignId = jsonFence.getString("cid"))) && !campaignId.equals("null")) {
            geoId = geoId.concat(":").concat(campaignId);
        }
        return geoId;
    }

    private void trackGeoFenceHitEvent(int geoFenceTransition, Geofence fence, GeoLocation lastLocation) {
        String geoId;
        PayloadBuilder attributes = new PayloadBuilder();
        String campaignId = this.getCampaignIdFromRequestId(fence.getRequestId());
        if (TextUtils.isEmpty((CharSequence)campaignId)) {
            return;
        }
        attributes.putAttrString("campaign_id", campaignId);
        attributes.putAttrLocation("trigger_location", lastLocation);
        String transitionType = this.getTransitionString(geoFenceTransition);
        if (!TextUtils.isEmpty((CharSequence)transitionType)) {
            attributes.putAttrString("transition_type", transitionType);
        }
        if (!TextUtils.isEmpty((CharSequence)(geoId = this.getGeoIdFromRequestId(fence.getRequestId())))) {
            attributes.putAttrString("geo_id", geoId);
        }
        MoEEventManager.getInstance((Context)this.context).trackEvent(MoEHelperConstants.EVENT_GEO_FENCE_HIT, attributes.build());
    }

    @Nullable
    private String getTransitionString(int geoFenceTransition) {
        switch (geoFenceTransition) {
            case 1: {
                return "enter";
            }
            case 4: {
                return "dwell";
            }
            case 2: {
                return "exit";
            }
        }
        return null;
    }

    @Nullable
    private String getCampaignIdFromRequestId(String requestId) {
        try {
            String[] splitString;
            if (TextUtils.isEmpty((CharSequence)requestId)) {
                return null;
            }
            if (requestId.contains(":") && (splitString = requestId.split(":")) != null && splitString.length != 0) {
                return splitString[splitString.length - 1];
            }
        }
        catch (Exception e) {
            Logger.f((String)"LocationHandlerImpl: getCampaignIdFromRequestId() ", (Throwable)e);
        }
        return null;
    }

    @Nullable
    private String getGeoIdFromRequestId(String requestId) {
        try {
            if (TextUtils.isEmpty((CharSequence)requestId)) {
                return null;
            }
            if (!requestId.contains(":")) {
                return requestId;
            }
            String[] splitString = requestId.split(":");
            if (splitString != null) {
                return splitString[0];
            }
        }
        catch (Exception e) {
            Logger.f((String)"LocationHandlerImpl getGeoIdFromRequestId() ", (Throwable)e);
        }
        return null;
    }

    private void removeGeoFencesInternal() {
        List<String> oldGeoFenceList = this.getSavedGeoIds();
        if (oldGeoFenceList != null) {
            Logger.v((String)"LocationHandlerImpl: removeGeoFencesInternal(): Removing all existing geo fences");
            this.getGeoFencingClient().removeGeofences(oldGeoFenceList);
        }
    }
}

